/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.sisu.siesta.server.internal;

import com.google.common.base.Preconditions;
import com.google.inject.Key;
import java.io.IOException;
import java.lang.annotation.Annotation;
import javax.inject.Inject;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Application;
import org.eclipse.sisu.BeanEntry;
import org.eclipse.sisu.Mediator;
import org.eclipse.sisu.inject.BeanLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.sonatype.sisu.siesta.server.ApplicationContainer;

public class SiestaServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(SiestaServlet.class);
    private static final long serialVersionUID = 1L;
    private final ApplicationContainer container;
    private final BeanLocator beanLocator;

    @Inject
    public SiestaServlet(ApplicationContainer container, BeanLocator beanLocator) {
        this.container = (ApplicationContainer)Preconditions.checkNotNull((Object)container);
        log.debug("Container: {}", (Object)container);
        this.beanLocator = beanLocator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(ServletConfig config) throws ServletException {
        Preconditions.checkNotNull((Object)config);
        log.debug("Initializing");
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        try {
            super.init(config);
            this.container.init(config);
            this.beanLocator.watch(Key.get(Application.class), (Mediator)new ApplicationMediator(), (Object)this.container);
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Preconditions.checkNotNull((Object)request);
        Preconditions.checkNotNull((Object)response);
        String uri = request.getRequestURI();
        if (request.getQueryString() != null) {
            uri = String.format("%s?%s", uri, request.getQueryString());
        }
        if (log.isDebugEnabled()) {
            log.debug("Processing: {} {} ({})", new Object[]{request.getMethod(), uri, request.getRequestURL()});
        }
        MDC.put((String)((Object)((Object)this)).getClass().getName(), (String)uri);
        try {
            this.container.service(request, response);
        }
        finally {
            MDC.remove((String)((Object)((Object)this)).getClass().getName());
        }
    }

    private class ApplicationMediator
    implements Mediator<Annotation, Application, ApplicationContainer> {
        private ApplicationMediator() {
        }

        public void add(BeanEntry<Annotation, Application> entry, ApplicationContainer container) throws Exception {
            log.debug("Adding application: {}", entry);
            try {
                container.add((Application)entry.getValue());
            }
            catch (Exception e) {
                log.error("Failed to add application", (Throwable)e);
            }
        }

        public void remove(BeanEntry<Annotation, Application> entry, ApplicationContainer container) throws Exception {
        }
    }
}

