/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.sisu.siesta.server.internal;

import com.google.common.base.Preconditions;
import com.google.inject.Key;
import java.util.Set;
import javax.inject.Inject;
import javax.ws.rs.Path;
import org.eclipse.sisu.BeanEntry;
import org.eclipse.sisu.inject.BeanLocator;
import org.sonatype.sisu.siesta.common.Resource;
import org.sonatype.sisu.siesta.server.ApplicationSupport;

public class ResourceDiscoveryApplication
extends ApplicationSupport {
    private final BeanLocator container;

    @Inject
    public ResourceDiscoveryApplication(BeanLocator container) {
        this.container = (BeanLocator)Preconditions.checkNotNull((Object)container);
    }

    @Override
    public Set<Class<?>> getClasses() {
        if (this.classes.isEmpty()) {
            this.findResources();
        }
        return super.getClasses();
    }

    private void findResources() {
        this.log.debug("Finding resources");
        for (BeanEntry entry : this.container.locate(Key.get(Resource.class))) {
            Class type = entry.getImplementationClass();
            Path path = type.getAnnotation(Path.class);
            if (path == null) continue;
            this.log.debug("Adding resource: {} -> {}", (Object)path.value(), (Object)type);
            this.classes.add(type);
        }
        this.log.debug("Found {} resources", (Object)this.classes.size());
    }
}

