/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.sisu.siesta.server.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.sisu.siesta.common.Resource;
import org.sonatype.sisu.siesta.server.internal.ComponentDiscoveryApplication;
import org.sonatype.sisu.siesta.server.internal.ComponentDiscoveryReporter;

@Named
@Singleton
public class ComponentDiscoveryReporterImpl
implements ComponentDiscoveryReporter {
    protected final Logger log;

    @Inject
    public ComponentDiscoveryReporterImpl() {
        this.log = LoggerFactory.getLogger(this.getClass());
    }

    public ComponentDiscoveryReporterImpl(Logger logger) {
        this.log = (Logger)Preconditions.checkNotNull((Object)logger);
    }

    @Override
    public void report(ComponentDiscoveryApplication application) {
        Preconditions.checkNotNull((Object)((Object)application));
        this.reportResources(application.getResources());
        this.reportComponents(application.getComponents());
    }

    protected String pathOf(Class<Resource> type) {
        Path path = type.getAnnotation(Path.class);
        return path.value();
    }

    protected void reportResources(Set<Class<Resource>> resources) {
        if (resources.isEmpty()) {
            this.log.info("No resources found");
        } else {
            this.log.info("Resources:");
            ArrayList paths = Lists.newArrayListWithCapacity((int)resources.size());
            for (Class<Resource> type : resources) {
                String path = this.pathOf(type);
                paths.add(path);
            }
            Collections.sort(paths);
            for (String path : paths) {
                this.log.info("  {}", (Object)path);
            }
        }
    }

    protected void reportComponents(Set<Class<?>> components) {
        if (components.isEmpty()) {
            this.log.info("No components found");
        } else {
            this.log.info("Components:");
            ArrayList types = Lists.newArrayListWithCapacity((int)components.size());
            for (Class<?> clazz : components) {
                types.add(clazz.getName());
            }
            Collections.sort(types);
            for (String string : types) {
                this.log.info("  {}", (Object)string);
            }
        }
    }
}

