/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.sisu.siesta.server.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.inject.Key;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.ws.rs.Path;
import org.eclipse.sisu.BeanEntry;
import org.eclipse.sisu.inject.BeanLocator;
import org.sonatype.sisu.siesta.common.Component;
import org.sonatype.sisu.siesta.common.Resource;
import org.sonatype.sisu.siesta.server.ApplicationSupport;
import org.sonatype.sisu.siesta.server.internal.ComponentDiscoveryReporter;

public class ComponentDiscoveryApplication
extends ApplicationSupport {
    private final BeanLocator container;
    private final Set<Class<Resource>> resources = Sets.newHashSet();
    private final Set<Class<?>> components = Sets.newHashSet();
    private final ComponentDiscoveryReporter reporter;

    @Inject
    public ComponentDiscoveryApplication(BeanLocator container, @Nullable ComponentDiscoveryReporter reporter) {
        this.container = (BeanLocator)Preconditions.checkNotNull((Object)container);
        this.reporter = reporter;
        if (reporter != null) {
            this.log.debug("Reporter: {}", (Object)reporter);
        }
    }

    public Set<Class<Resource>> getResources() {
        return this.resources;
    }

    public Set<Class<?>> getComponents() {
        return this.components;
    }

    @Override
    public Set<Class<?>> getClasses() {
        if (this.classes.isEmpty()) {
            this.findComponents();
            if (this.reporter != null) {
                this.reporter.report(this);
            }
        }
        return super.getClasses();
    }

    private void findComponents() {
        this.log.debug("Finding components");
        for (BeanEntry entry : this.container.locate(Key.get(Component.class))) {
            this.log.trace("Found: {}", (Object)entry);
            Class type = entry.getImplementationClass();
            if (Resource.class.isAssignableFrom(type)) {
                Path path = type.getAnnotation(Path.class);
                if (path == null) continue;
                this.log.debug("Adding resource: {} -> {}", (Object)path.value(), (Object)type);
                this.resources.add(type);
                continue;
            }
            this.log.debug("Adding component: {}", (Object)type);
            this.components.add(type);
        }
        this.classes.addAll(this.resources);
        this.classes.addAll(this.components);
        this.log.debug("Found {} components", (Object)this.classes.size());
    }
}

