/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.sisu.siesta.server;

import java.util.List;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import org.sonatype.sisu.siesta.common.SiestaMediaType;
import org.sonatype.sisu.siesta.common.validation.ValidationErrorXO;
import org.sonatype.sisu.siesta.server.ExceptionMapperSupport;

public abstract class ValidationErrorsExceptionMappersSupport<E extends Throwable>
extends ExceptionMapperSupport<E> {
    private final List<Variant> variants_v1 = Variant.mediaTypes((MediaType[])new MediaType[]{SiestaMediaType.VND_VALIDATION_ERRORS_V1_JSON_TYPE, SiestaMediaType.VND_VALIDATION_ERRORS_V1_XML_TYPE}).add().build();

    @Override
    protected Response convert(E exception, String id) {
        Variant variant_v1;
        Response.ResponseBuilder builder = Response.status((int)this.getStatusCode(exception));
        List<ValidationErrorXO> validationErrors = this.getValidationErrors(exception);
        if (validationErrors != null && !validationErrors.isEmpty() && (variant_v1 = this.getRequest().selectVariant(this.variants_v1)) != null) {
            builder.type(variant_v1.getMediaType()).entity((Object)new GenericEntity<List<ValidationErrorXO>>(validationErrors){

                public String toString() {
                    return ((List)this.getEntity()).toString();
                }
            });
        }
        return builder.build();
    }

    protected int getStatusCode(E exception) {
        return Response.Status.BAD_REQUEST.getStatusCode();
    }

    protected abstract List<ValidationErrorXO> getValidationErrors(E var1);
}

