/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.sisu.siesta.server;

import com.google.common.base.Preconditions;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.sisu.siesta.common.Component;
import org.sonatype.sisu.siesta.common.error.ErrorXO;

public abstract class ExceptionMapperSupport<E extends Throwable>
implements Component,
ExceptionMapper<E> {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private Provider<Request> requestProvider;

    private String generateId() {
        return UUID.randomUUID().toString();
    }

    public Response toResponse(E exception) {
        Response response;
        Preconditions.checkNotNull(exception);
        String id = this.generateId();
        if (this.log.isTraceEnabled()) {
            this.log.trace("(ID {}) Mapping exception: " + exception, (Object)id, exception);
        } else {
            this.log.debug("(ID {}) Mapping exception: " + exception, (Object)id);
        }
        try {
            response = this.convert(exception, id);
        }
        catch (Exception e) {
            this.log.warn("(ID {}) Failed to map exception", (Object)id, (Object)e);
            response = Response.serverError().entity((Object)new ErrorXO().withId(id)).build();
        }
        Object entity = response.getEntity();
        this.log.warn("(ID {}) Response: [{}] {} mapped from {}/{}", new Object[]{id, response.getStatus(), entity == null ? "(no entity/body)" : entity, exception.getClass().getName(), ((Throwable)exception).getMessage(), this.log.isDebugEnabled() ? exception : null});
        return response;
    }

    protected abstract Response convert(E var1, String var2);

    @Inject
    public void installRequestProvider(Provider<Request> requestProvider) {
        this.requestProvider = (Provider)Preconditions.checkNotNull(requestProvider);
    }

    protected Request getRequest() {
        Preconditions.checkState((this.requestProvider != null ? 1 : 0) != 0, (Object)"Request provider not installed");
        return (Request)this.requestProvider.get();
    }
}

