/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugins.mavenbridge.workspace;

import java.io.File;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.repository.WorkspaceReader;
import org.sonatype.aether.repository.WorkspaceRepository;
import org.sonatype.nexus.plugins.mavenbridge.workspace.NexusWorkspace;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.item.StorageFileItem;
import org.sonatype.nexus.proxy.maven.ArtifactStoreRequest;
import org.sonatype.nexus.proxy.maven.MavenRepository;
import org.sonatype.nexus.proxy.maven.gav.Gav;
import org.sonatype.nexus.proxy.storage.local.fs.DefaultFSLocalRepositoryStorage;

public class NexusWorkspaceReader
implements WorkspaceReader {
    private final NexusWorkspace nexusWorkspace;
    private final WorkspaceRepository workspaceRepository;

    public NexusWorkspaceReader(NexusWorkspace nexusWorkspace) {
        this.nexusWorkspace = nexusWorkspace;
        this.workspaceRepository = new WorkspaceRepository("nexus", (Object)nexusWorkspace.getId());
    }

    public WorkspaceRepository getRepository() {
        return this.workspaceRepository;
    }

    public File findArtifact(Artifact artifact) {
        Gav gav = this.toGav(artifact);
        for (MavenRepository mavenRepository : this.nexusWorkspace.getRepositories()) {
            ArtifactStoreRequest gavRequest = new ArtifactStoreRequest(mavenRepository, gav, false, false);
            try {
                StorageFileItem artifactFile = mavenRepository.getArtifactStoreHelper().retrieveArtifact(gavRequest);
                if (!(artifactFile.getRepositoryItemUid().getRepository().getLocalStorage() instanceof DefaultFSLocalRepositoryStorage)) continue;
                DefaultFSLocalRepositoryStorage ls = (DefaultFSLocalRepositoryStorage)artifactFile.getRepositoryItemUid().getRepository().getLocalStorage();
                return ls.getFileFromBase(artifactFile.getRepositoryItemUid().getRepository(), (ResourceStoreRequest)gavRequest);
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    private Gav toGav(Artifact artifact) {
        String classifier = StringUtils.isEmpty((String)artifact.getClassifier()) ? null : artifact.getClassifier();
        Gav gav = new Gav(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), classifier, artifact.getExtension(), null, null, null, false, null, false, null);
        return gav;
    }

    public List<String> findVersions(Artifact artifact) {
        Gav gav = this.toGav(artifact);
        if (gav.isSnapshot()) {
            for (MavenRepository mavenRepository : this.nexusWorkspace.getRepositories()) {
                ArtifactStoreRequest gavRequest = new ArtifactStoreRequest(mavenRepository, gav, false, false);
                try {
                    Gav snapshot = mavenRepository.getMetadataManager().resolveSnapshot(gavRequest, gav);
                    return Collections.singletonList(snapshot.getVersion());
                }
                catch (Exception e) {
                }
            }
        }
        return Collections.emptyList();
    }
}

