/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugins.mavenbridge.workspace;

import java.util.Collections;
import java.util.List;
import org.sonatype.aether.repository.WorkspaceReader;
import org.sonatype.nexus.plugins.mavenbridge.workspace.NexusWorkspaceReader;
import org.sonatype.nexus.proxy.maven.MavenRepository;

public class NexusWorkspace {
    private final String id;
    private final List<MavenRepository> repositories;

    public NexusWorkspace(String id, List<MavenRepository> repositories) {
        assert (id != null && id.trim().length() > 0) : "Workspace ID cannotbe null or empty!";
        assert (repositories != null) : "Repository cannot be null!";
        this.id = id;
        this.repositories = repositories;
    }

    public String getId() {
        return this.id;
    }

    public List<MavenRepository> getRepositories() {
        return Collections.unmodifiableList(this.repositories);
    }

    public WorkspaceReader getWorkspaceReader() {
        return new NexusWorkspaceReader(this);
    }
}

