/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugins.mavenbridge.internal;

import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.model.Model;
import org.apache.maven.model.building.ModelBuildingException;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelSource;
import org.sonatype.aether.RepositoryListener;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.collection.CollectRequest;
import org.sonatype.aether.collection.DependencyCollectionException;
import org.sonatype.aether.graph.Dependency;
import org.sonatype.aether.graph.DependencyNode;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.resolution.ArtifactResolutionException;
import org.sonatype.aether.util.listener.ChainedRepositoryListener;
import org.sonatype.nexus.plugins.mavenbridge.NexusAether;
import org.sonatype.nexus.plugins.mavenbridge.NexusMavenBridge;
import org.sonatype.nexus.plugins.mavenbridge.workspace.NexusWorkspace;
import org.sonatype.nexus.proxy.maven.MavenRepository;
import org.sonatype.sisu.maven.bridge.MavenDependencyTreeResolver;
import org.sonatype.sisu.maven.bridge.MavenModelResolver;
import org.sonatype.sisu.maven.bridge.support.CollectRequestBuilder;
import org.sonatype.sisu.maven.bridge.support.ModelBuildingRequestBuilder;

@Named
@Singleton
public class DefaultNexusMavenBridge
implements NexusMavenBridge {
    private final NexusAether nexusAether;
    private final MavenModelResolver modelResolver;
    private final MavenDependencyTreeResolver dependencyTreeResolver;

    @Inject
    DefaultNexusMavenBridge(NexusAether nexusAether, MavenModelResolver modelResolver, MavenDependencyTreeResolver dependencyTreeResolver) {
        this.nexusAether = nexusAether;
        this.modelResolver = modelResolver;
        this.dependencyTreeResolver = dependencyTreeResolver;
    }

    @Override
    public Model buildModel(ModelSource pom, List<MavenRepository> repositories, RepositoryListener ... listeners) throws ModelBuildingException {
        RepositorySystemSession session = this.createSession(repositories, new RepositoryListener[0]);
        return this.modelResolver.resolveModel((ModelBuildingRequest)ModelBuildingRequestBuilder.model().setModelSource(pom), session, new RemoteRepository[0]);
    }

    @Override
    public DependencyNode collectDependencies(Dependency dependency, List<MavenRepository> repositories, RepositoryListener ... listeners) throws DependencyCollectionException, ArtifactResolutionException {
        RepositorySystemSession session = this.createSession(repositories, new RepositoryListener[0]);
        return this.dependencyTreeResolver.resolveDependencyTree((CollectRequest)CollectRequestBuilder.tree().dependency(dependency), session, new RemoteRepository[0]);
    }

    @Override
    public DependencyNode resolveDependencies(Dependency dependency, List<MavenRepository> repositories, RepositoryListener ... listeners) throws DependencyCollectionException, ArtifactResolutionException {
        RepositorySystemSession session = this.createSession(repositories, new RepositoryListener[0]);
        DependencyNode node = this.dependencyTreeResolver.resolveDependencyTree((CollectRequest)CollectRequestBuilder.tree().dependency(dependency), session, new RemoteRepository[0]);
        this.nexusAether.getRepositorySystem().resolveDependencies(session, node, null);
        return node;
    }

    @Override
    public DependencyNode collectDependencies(Model model, List<MavenRepository> repositories, RepositoryListener ... listeners) throws DependencyCollectionException, ArtifactResolutionException {
        RepositorySystemSession session = this.createSession(repositories, new RepositoryListener[0]);
        return this.dependencyTreeResolver.resolveDependencyTree((CollectRequest)CollectRequestBuilder.tree().model(model), session, new RemoteRepository[0]);
    }

    @Override
    public DependencyNode resolveDependencies(Model model, List<MavenRepository> repositories, RepositoryListener ... listeners) throws DependencyCollectionException, ArtifactResolutionException {
        RepositorySystemSession session = this.createSession(repositories, new RepositoryListener[0]);
        DependencyNode node = this.dependencyTreeResolver.resolveDependencyTree((CollectRequest)CollectRequestBuilder.tree().model(model), session, new RemoteRepository[0]);
        this.nexusAether.getRepositorySystem().resolveDependencies(session, node, null);
        return node;
    }

    protected RepositorySystemSession createSession(List<MavenRepository> repositories, RepositoryListener ... listeners) {
        NexusWorkspace nexusWorkspace = this.nexusAether.createWorkspace(repositories);
        return this.nexusAether.getNexusEnabledRepositorySystemSession(nexusWorkspace, (RepositoryListener)new ChainedRepositoryListener(listeners));
    }
}

