/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugins.mavenbridge.internal;

import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.repository.internal.MavenRepositorySystemSession;
import org.sonatype.aether.RepositoryListener;
import org.sonatype.aether.RepositorySystem;
import org.sonatype.aether.repository.LocalRepository;
import org.sonatype.aether.util.DefaultRepositorySystemSession;
import org.sonatype.nexus.configuration.application.ApplicationConfiguration;
import org.sonatype.nexus.plugins.mavenbridge.NexusAether;
import org.sonatype.nexus.plugins.mavenbridge.workspace.NexusWorkspace;
import org.sonatype.nexus.proxy.maven.MavenRepository;

@Named
@Singleton
public class DefaultNexusAether
implements NexusAether {
    public static final String LOCAL_REPO_DIR = "maven2-local-repository";
    private final ApplicationConfiguration applicationConfiguration;
    private final RepositorySystem repositorySystem;

    @Inject
    public DefaultNexusAether(ApplicationConfiguration applicationConfiguration, RepositorySystem repositorySystem) {
        this.applicationConfiguration = applicationConfiguration;
        this.repositorySystem = repositorySystem;
    }

    @Override
    public NexusWorkspace createWorkspace(List<MavenRepository> participants) {
        if (participants == null || participants.isEmpty()) {
            throw new IllegalArgumentException("Participant repositories in NexusWorkspace must have at least one element!");
        }
        return new NexusWorkspace(UUID.randomUUID().toString(), participants);
    }

    @Override
    public NexusWorkspace createWorkspace(MavenRepository ... participants) {
        if (participants == null) {
            throw new IllegalArgumentException("Participant repositories in NexusWorkspace must have at least one element!");
        }
        return this.createWorkspace(Arrays.asList(participants));
    }

    @Override
    public synchronized RepositorySystem getRepositorySystem() {
        return this.repositorySystem;
    }

    public DefaultRepositorySystemSession getDefaultRepositorySystemSession() {
        MavenRepositorySystemSession session = new MavenRepositorySystemSession();
        LocalRepository localRepo = new LocalRepository(this.applicationConfiguration.getWorkingDirectory(LOCAL_REPO_DIR));
        session.setLocalRepositoryManager(this.getRepositorySystem().newLocalRepositoryManager(localRepo));
        return session;
    }

    public DefaultRepositorySystemSession getNexusEnabledRepositorySystemSession(NexusWorkspace nexusWorkspace, RepositoryListener listener) {
        return this.getNexusEnabledRepositorySystemSession(this.getDefaultRepositorySystemSession(), nexusWorkspace, listener);
    }

    public DefaultRepositorySystemSession getNexusEnabledRepositorySystemSession(DefaultRepositorySystemSession session, NexusWorkspace nexusWorkspace, RepositoryListener listener) {
        session.setWorkspaceReader(nexusWorkspace.getWorkspaceReader());
        session.setOffline(true);
        session.setRepositoryListener(listener);
        return session;
    }
}

