/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.metrics.httpclient;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricsRegistry;
import java.util.concurrent.TimeUnit;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.DnsResolver;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.impl.conn.SchemeRegistryFactory;
import org.apache.http.impl.conn.SystemDefaultDnsResolver;

public class InstrumentedClientConnManager
extends PoolingClientConnectionManager {
    public InstrumentedClientConnManager() {
        this(SchemeRegistryFactory.createDefault());
    }

    public InstrumentedClientConnManager(SchemeRegistry registry) {
        this(registry, -1L, TimeUnit.MILLISECONDS);
    }

    public InstrumentedClientConnManager(SchemeRegistry registry, long connTTL, TimeUnit connTTLTimeUnit) {
        this(Metrics.defaultRegistry(), registry, connTTL, connTTLTimeUnit);
    }

    public InstrumentedClientConnManager(MetricsRegistry metricsRegistry, SchemeRegistry registry, long connTTL, TimeUnit connTTLTimeUnit) {
        this(metricsRegistry, registry, connTTL, connTTLTimeUnit, (DnsResolver)new SystemDefaultDnsResolver());
    }

    public InstrumentedClientConnManager(MetricsRegistry metricsRegistry, SchemeRegistry schemeRegistry, long connTTL, TimeUnit connTTLTimeUnit, DnsResolver dnsResolver) {
        super(schemeRegistry, connTTL, connTTLTimeUnit, dnsResolver);
        metricsRegistry.newGauge(ClientConnectionManager.class, "available-connections", (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return InstrumentedClientConnManager.this.getTotalStats().getAvailable();
            }
        });
        metricsRegistry.newGauge(ClientConnectionManager.class, "leased-connections", (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return InstrumentedClientConnManager.this.getTotalStats().getLeased();
            }
        });
        metricsRegistry.newGauge(ClientConnectionManager.class, "max-connections", (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return InstrumentedClientConnManager.this.getTotalStats().getMax();
            }
        });
        metricsRegistry.newGauge(ClientConnectionManager.class, "pending-connections", (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return InstrumentedClientConnManager.this.getTotalStats().getPending();
            }
        });
    }
}

