/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.clm.dto.model.rhc;

import com.sonatype.clm.dto.model.License;
import com.sonatype.clm.dto.model.SecurityVulnerability;
import com.sonatype.clm.dto.model.component.ComponentDetails;
import com.sonatype.clm.dto.model.component.ComponentIdentifier;
import com.sonatype.clm.dto.model.rhc.RepoHealthCheckLicense;
import com.sonatype.clm.dto.model.rhc.RepoHealthCheckLicenseInfo;
import com.sonatype.clm.dto.model.rhc.RepoHealthCheckSecurityVulnerability;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class RepoHealthCheckComponentDetails
implements RepoHealthCheckLicenseInfo {
    private ComponentIdentifier componentIdentifier;
    private List<RepoHealthCheckSecurityVulnerability> securityVulnerabilities;
    private Set<License> declaredLicenses;
    private Set<License> observedLicenses;
    private String licenseThreatLevelId;
    private String licenseThreatName;

    private static List<RepoHealthCheckSecurityVulnerability> transform(List<SecurityVulnerability> svs) {
        if (svs == null) {
            return null;
        }
        ArrayList<RepoHealthCheckSecurityVulnerability> result = new ArrayList<RepoHealthCheckSecurityVulnerability>(svs.size());
        for (SecurityVulnerability sv : svs) {
            result.add(new RepoHealthCheckSecurityVulnerability(sv));
        }
        return result;
    }

    public ComponentIdentifier getComponentIdentifier() {
        return this.componentIdentifier;
    }

    public void setComponentIdentifier(ComponentIdentifier componentIdentifier) {
        this.componentIdentifier = componentIdentifier;
    }

    public List<RepoHealthCheckSecurityVulnerability> getSecurityVulnerabilities() {
        return this.securityVulnerabilities;
    }

    public void setSecurityVulnerabilities(List<RepoHealthCheckSecurityVulnerability> securityVulnerabilities) {
        this.securityVulnerabilities = securityVulnerabilities;
    }

    public Set<License> getDeclaredLicenses() {
        return this.declaredLicenses;
    }

    public void setDeclaredLicenses(Set<License> declaredLicenses) {
        this.declaredLicenses = declaredLicenses;
    }

    public Set<License> getObservedLicenses() {
        return this.observedLicenses;
    }

    public void setObservedLicenses(Set<License> observedLicenses) {
        this.observedLicenses = observedLicenses;
    }

    public String getLicenseThreatLevelId() {
        return this.licenseThreatLevelId;
    }

    @Override
    public void setLicenseThreatLevelId(String licenseThreatLevelId) {
        this.licenseThreatLevelId = licenseThreatLevelId;
    }

    public String getLicenseThreatName() {
        return this.licenseThreatName;
    }

    @Override
    public void setLicenseThreatName(String licenseThreatName) {
        this.licenseThreatName = licenseThreatName;
    }

    public RepoHealthCheckComponentDetails() {
    }

    public RepoHealthCheckComponentDetails(ComponentDetails componentDetails) {
        this.setDeclaredLicenses(componentDetails.getDeclaredLicenses());
        this.setObservedLicenses(componentDetails.getObservedLicenses());
        this.setSecurityVulnerabilities(RepoHealthCheckComponentDetails.transform(componentDetails.getSecurityVulnerabilities()));
        this.setComponentIdentifier(componentDetails.getComponentIdentifier());
    }

    @Override
    public void addLicense(RepoHealthCheckLicense license) {
    }
}

