/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.clm.dto.model.policy;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.sonatype.clm.dto.model.component.ComponentDisplayName;
import com.sonatype.clm.dto.model.component.ComponentIdentifier;
import com.sonatype.clm.dto.model.policy.ConstraintFact;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class ComponentFact
implements Cloneable {
    private ComponentIdentifier componentIdentifier;
    @Deprecated
    private String groupId;
    @Deprecated
    private String artifactId;
    @Deprecated
    private String version;
    private String hash;
    private List<ConstraintFact> constraintFacts;
    private List<String> pathnames = new ArrayList<String>();
    private ComponentDisplayName displayName;

    public ComponentFact() {
    }

    public ComponentFact(ComponentIdentifier componentIdentifier, String hash) {
        this.componentIdentifier = componentIdentifier;
        this.hash = hash;
        this.setGav();
    }

    @Deprecated
    private void setGav() {
        if (this.componentIdentifier != null && this.componentIdentifier.isMaven()) {
            this.groupId = this.componentIdentifier.get("groupId");
            this.artifactId = this.componentIdentifier.get("artifactId");
            this.version = this.componentIdentifier.get("version");
        }
    }

    public ComponentIdentifier getComponentIdentifier() {
        return this.componentIdentifier;
    }

    @Deprecated
    public String getGroupId() {
        return this.groupId;
    }

    @Deprecated
    public String getArtifactId() {
        return this.artifactId;
    }

    @Deprecated
    public String getVersion() {
        return this.version;
    }

    public String getHash() {
        return this.hash;
    }

    public ComponentDisplayName getDisplayName() {
        return this.displayName;
    }

    public List<ConstraintFact> getConstraintFacts() {
        return this.constraintFacts != null ? Collections.unmodifiableList(this.constraintFacts) : Collections.EMPTY_LIST;
    }

    public List<String> getPathnames() {
        return Collections.unmodifiableList(this.pathnames);
    }

    public void addConstraintFact(ConstraintFact constraintFact) {
        if (this.constraintFacts == null) {
            this.constraintFacts = new ArrayList<ConstraintFact>();
        }
        this.constraintFacts.add(constraintFact);
    }

    public void addPathnames(List<String> paths) {
        if (paths == null || paths.isEmpty()) {
            return;
        }
        for (String pathname : paths) {
            if (pathname == null || pathname.trim().isEmpty()) continue;
            this.pathnames.add(pathname);
        }
    }

    public void setDisplayName(ComponentDisplayName displayName) {
        this.displayName = displayName;
    }

    public ComponentFact with(List<ConstraintFact> newConstraintFacts) {
        try {
            ComponentFact clone = (ComponentFact)this.clone();
            clone.constraintFacts = newConstraintFacts;
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new UnsupportedOperationException();
        }
    }

    public ComponentFact with(ConstraintFact ... newConstraintFacts) {
        return this.with(Arrays.asList(newConstraintFacts));
    }

    @JsonIgnore
    public String getComponentId() {
        return this.hash;
    }

    public String toString() {
        return "\n Component(displayName=" + this.displayName + ", hash=" + this.hash + ") " + this.constraintFacts;
    }
}

