/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.clm.dto.model.component;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.sonatype.clm.dto.model.component.InvalidComponentIdentifierException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;

public class ComponentIdentifier
implements Comparable<ComponentIdentifier> {
    static final String MUST_HAVE_FORMAT_MESSAGE = "A component identifier must have a format.";
    static final String MUST_HAVE_COORDINATE_MESSAGE = "A component identifier must have at least one coordinate.";
    static final String INCORRECT_COORDINATES = "Coordinates contain the following incorrect entries for the given format: ";
    private static final SortedMap<String, String> UNMODIFIABLE_EMPTY_SORTED_MAP = Collections.unmodifiableSortedMap(new TreeMap());
    private String format;
    private SortedMap<String, String> coordinates;
    public static final String NUGET_PACKAGE_ID = "packageId";
    public static final String VERSION = "version";
    public static final String MAVEN_EXTENSION = "extension";
    public static final String MAVEN_CLASSIFIER = "classifier";
    public static final String MAVEN_ARTIFACT_ID = "artifactId";
    public static final String MAVEN_GROUP_ID = "groupId";
    private static final LinkedHashSet<String> MAVEN_COORDINATE_NAMES = new LinkedHashSet<String>(Arrays.asList("groupId", "artifactId", "version", "classifier", "extension"));
    private static final LinkedHashSet<String> NUGET_COORDINATE_NAMES = new LinkedHashSet<String>(Arrays.asList("packageId", "version"));
    public static final String FORMAT_MAVEN = "maven";
    public static final String FORMAT_NUGET = "nuget";

    public ComponentIdentifier() {
    }

    public ComponentIdentifier(String format, Map<String, String> coordinates) {
        this.format = format;
        this.setCoordinates(coordinates);
        this.validate();
    }

    public String get(String property) {
        return (String)this.coordinates.get(property);
    }

    public ComponentIdentifier createAlternativeVersion(String version) {
        LinkedHashMap<String, String> coordinates = new LinkedHashMap<String, String>(this.coordinates);
        coordinates.put(VERSION, version);
        return new ComponentIdentifier(this.format, coordinates);
    }

    public static ComponentIdentifier createNugetCoordinates(String packageId, String version) {
        LinkedHashMap<String, String> coords = new LinkedHashMap<String, String>();
        coords.put(NUGET_PACKAGE_ID, packageId);
        coords.put(VERSION, version);
        return new ComponentIdentifier(FORMAT_NUGET, coords);
    }

    public static ComponentIdentifier createMavenCoordinates(String groupId, String artifactId, String version, String classifier, String extension) {
        LinkedHashMap<String, String> coords = new LinkedHashMap<String, String>();
        coords.put(MAVEN_GROUP_ID, groupId);
        coords.put(MAVEN_ARTIFACT_ID, artifactId);
        coords.put(VERSION, version);
        coords.put(MAVEN_CLASSIFIER, classifier);
        coords.put(MAVEN_EXTENSION, extension);
        return new ComponentIdentifier(FORMAT_MAVEN, coords);
    }

    public static ComponentIdentifier createMavenCoordinates(String groupId, String artifactId, String version) {
        LinkedHashMap<String, String> coords = new LinkedHashMap<String, String>();
        coords.put(MAVEN_GROUP_ID, groupId);
        coords.put(MAVEN_ARTIFACT_ID, artifactId);
        coords.put(VERSION, version);
        return new ComponentIdentifier(FORMAT_MAVEN, coords);
    }

    public String toString() {
        return this.format + ": " + this.coordinates;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + ComponentIdentifier.hash(this.format);
        result = 31 * result + ComponentIdentifier.hash(this.coordinates);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ComponentIdentifier)) {
            return false;
        }
        ComponentIdentifier other = (ComponentIdentifier)obj;
        if (!ComponentIdentifier.eq(this.format, other.format)) {
            return false;
        }
        return this.coordinates.equals(other.getCoordinates());
    }

    private static <T> boolean eq(T obj1, T obj2) {
        return obj1 == null ? obj2 == null : obj1.equals(obj2);
    }

    private static int hash(Object obj) {
        return obj == null ? 0 : obj.hashCode();
    }

    @Override
    public int compareTo(ComponentIdentifier that) {
        int rel = this.format.compareTo(that.format);
        if (rel != 0) {
            return rel;
        }
        if (this.isMaven()) {
            return this.compareCoordinates(that, MAVEN_COORDINATE_NAMES);
        }
        if (FORMAT_NUGET.equals(this.format)) {
            return this.compareCoordinates(that, NUGET_COORDINATE_NAMES);
        }
        return ComponentIdentifier.join(this.coordinates).compareTo(ComponentIdentifier.join(that.coordinates));
    }

    private int compareCoordinates(ComponentIdentifier that, LinkedHashSet<String> coordinateNames) {
        for (String coordinateName : coordinateNames) {
            int rel = ComponentIdentifier.compareNullableStrings(this.get(coordinateName), that.get(coordinateName));
            if (rel == 0) continue;
            return rel;
        }
        return 0;
    }

    private static String join(Map<String, String> coordinates) {
        if (coordinates == null) {
            return "";
        }
        StringBuffer result = new StringBuffer();
        for (String value : coordinates.values()) {
            result.append(value);
        }
        return result.toString();
    }

    private static int compareNullableStrings(String s1, String s2) {
        if (s1 == null) {
            if (s2 == null) {
                return 0;
            }
            return 1;
        }
        if (s2 == null) {
            return -1;
        }
        return s1.compareTo(s2);
    }

    public String getFormat() {
        return this.format;
    }

    public SortedMap<String, String> getCoordinates() {
        if (this.coordinates == null) {
            return UNMODIFIABLE_EMPTY_SORTED_MAP;
        }
        return Collections.unmodifiableSortedMap(this.coordinates);
    }

    public void validate() throws InvalidComponentIdentifierException {
        if (this.format == null || this.format.isEmpty()) {
            throw new InvalidComponentIdentifierException(MUST_HAVE_FORMAT_MESSAGE);
        }
        if (this.coordinates == null || this.coordinates.isEmpty()) {
            throw new InvalidComponentIdentifierException(MUST_HAVE_COORDINATE_MESSAGE);
        }
        Set<String> keys = this.coordinates.keySet();
        if (this.format.equals(FORMAT_MAVEN)) {
            this.validateCoordinates(keys, MAVEN_COORDINATE_NAMES);
        } else if (this.format.equals(FORMAT_NUGET)) {
            this.validateCoordinates(keys, NUGET_COORDINATE_NAMES);
        }
    }

    private void validateCoordinates(Set<String> keys, Set<String> expectedKeys) {
        if (!expectedKeys.containsAll(keys)) {
            TreeSet<String> keyCopy = new TreeSet<String>(keys);
            keyCopy.removeAll(expectedKeys);
            throw new InvalidComponentIdentifierException(INCORRECT_COORDINATES + keyCopy);
        }
    }

    private void setCoordinates(Map<String, String> coordinates) {
        if (coordinates == null) {
            return;
        }
        this.coordinates = new TreeMap<String, String>();
        for (Map.Entry<String, String> coordinate : coordinates.entrySet()) {
            if (coordinate.getValue() == null) continue;
            this.coordinates.put(coordinate.getKey(), coordinate.getValue());
        }
    }

    @JsonIgnore
    public boolean isMaven() {
        return FORMAT_MAVEN.equals(this.format);
    }
}

