/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.clm.dto.model.component;

import com.sonatype.clm.dto.model.component.ComponentDisplayName;
import com.sonatype.clm.dto.model.component.ComponentIdentifier;
import java.util.Map;

public class ComponentDisplayNameUtil {
    public static final String GAV_SEPARATOR = " : ";
    public static final String NUGET_SEPARATOR = " ";
    public static final String GROUP_LABEL = "Group";
    public static final String ARTIFACT_LABEL = "Artifact";
    public static final String VERSION_LABEL = "Version";
    public static final String EXTENSION_LABEL = "Extension";
    public static final String CLASSIFIER_LABEL = "Classifier";
    public static final String ID_LABEL = "ID";

    public static ComponentDisplayName fromGav(String groupId, String artifactId, String version) {
        return ComponentDisplayNameUtil.fromGavec(groupId, artifactId, version, null, null);
    }

    public static ComponentDisplayName fromGavec(String groupId, String artifactId, String version, String extension, String classifier) {
        boolean showExtension;
        if (groupId == null) {
            return null;
        }
        ComponentDisplayName componentDisplayName = new ComponentDisplayName().add(GROUP_LABEL, groupId).add(GAV_SEPARATOR).add(ARTIFACT_LABEL, artifactId);
        boolean hasClassifier = classifier != null && !classifier.isEmpty();
        boolean bl = showExtension = extension != null && !extension.isEmpty() && (!extension.equalsIgnoreCase("jar") || hasClassifier);
        if (showExtension) {
            componentDisplayName.add(GAV_SEPARATOR).add(EXTENSION_LABEL, extension);
        } else if (hasClassifier) {
            componentDisplayName.add(GAV_SEPARATOR);
        }
        if (hasClassifier) {
            componentDisplayName.add(GAV_SEPARATOR).add(CLASSIFIER_LABEL, classifier);
        }
        return componentDisplayName.add(GAV_SEPARATOR).add(VERSION_LABEL, version);
    }

    public static ComponentDisplayName fromNuGet(String packageId, String version) {
        return new ComponentDisplayName().add(ID_LABEL, packageId).add(NUGET_SEPARATOR).add(VERSION_LABEL, version);
    }

    public static ComponentDisplayName fromIdentifier(ComponentIdentifier identifier) {
        if (identifier == null) {
            return null;
        }
        if (identifier.isMaven()) {
            return ComponentDisplayNameUtil.fromGavec(identifier.get("groupId"), identifier.get("artifactId"), identifier.get("version"), identifier.get("extension"), identifier.get("classifier"));
        }
        if ("nuget".equals(identifier.getFormat())) {
            return ComponentDisplayNameUtil.fromNuGet(identifier.get("packageId"), identifier.get("version"));
        }
        ComponentDisplayName name = new ComponentDisplayName();
        boolean first = true;
        for (Map.Entry<String, String> entry : identifier.getCoordinates().entrySet()) {
            if (!first) {
                name.add(GAV_SEPARATOR);
            }
            first = false;
            name.add(entry.getKey(), entry.getValue());
        }
        return name;
    }
}

