/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.clm.dto.model.component;

import com.sonatype.clm.dto.model.ComponentInfo;
import com.sonatype.clm.dto.model.License;
import com.sonatype.clm.dto.model.SecurityVulnerability;
import com.sonatype.clm.dto.model.component.ComponentIdentifier;
import com.sonatype.clm.dto.model.ide.LicenseStatus;
import com.sonatype.clm.dto.model.policy.PolicyAlert;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class ComponentDetails
implements ComponentInfo {
    private String hash;
    private String matchState;
    private Set<License> declaredLicenses;
    private Set<License> observedLicenses = new LinkedHashSet<License>();
    private Set<License> overriddenLicenses;
    private Set<License> effectiveLicenses;
    private LicenseStatus effectiveLicenseStatus;
    private Long catalogDate;
    private Integer relativePopularity;
    private List<SecurityVulnerability> securityVulnerabilities;
    private String website;
    private List<PolicyAlert> policyAlerts;
    private Integer licenseThreatLevel;
    private List<String> licenseThreatGroupNames;
    @Deprecated
    private boolean majorRevisionStep;
    private String identificationSource;
    private String identificationSourceComment;
    private ComponentIdentifier componentIdentifier;

    public ComponentDetails() {
        this.declaredLicenses = new LinkedHashSet<License>();
        this.overriddenLicenses = new LinkedHashSet<License>();
        this.effectiveLicenses = new LinkedHashSet<License>();
        this.securityVulnerabilities = new ArrayList<SecurityVulnerability>();
    }

    @Deprecated
    public ComponentDetails(String groupId, String artifactId, String version) {
        this();
        this.componentIdentifier = ComponentIdentifier.createMavenCoordinates(groupId, artifactId, version);
    }

    public ComponentDetails(ComponentIdentifier componentIdentifier) {
        this();
        this.componentIdentifier = componentIdentifier;
    }

    @Override
    @Deprecated
    public String getArtifactId() {
        return this.getMavenCoordinate("artifactId");
    }

    @Override
    public Long getCatalogDate() {
        return this.catalogDate;
    }

    public Set<License> getDeclaredLicenses() {
        return this.declaredLicenses;
    }

    @Override
    @Deprecated
    public String getGroupId() {
        return this.getMavenCoordinate("groupId");
    }

    public Set<License> getObservedLicenses() {
        return this.observedLicenses;
    }

    public Set<License> getOverriddenLicenses() {
        return this.overriddenLicenses;
    }

    public Set<License> getEffectiveLicenses() {
        return this.effectiveLicenses;
    }

    public LicenseStatus getEffectiveLicenseStatus() {
        return this.effectiveLicenseStatus;
    }

    public void setEffectiveLicenses(Set<License> effectiveLicenses) {
        this.effectiveLicenses = effectiveLicenses;
    }

    public void setEffectiveLicenseStatus(LicenseStatus effectiveLicenseStatus) {
        this.effectiveLicenseStatus = effectiveLicenseStatus;
    }

    public List<PolicyAlert> getPolicyAlerts() {
        return this.policyAlerts;
    }

    @Override
    public Integer getRelativePopularity() {
        return this.relativePopularity;
    }

    @Override
    public List<SecurityVulnerability> getSecurityVulnerabilities() {
        return this.securityVulnerabilities;
    }

    @Override
    @Deprecated
    public String getVersion() {
        return this.getMavenCoordinate("version");
    }

    private String getMavenCoordinate(String coordinate) {
        return this.componentIdentifier != null && this.componentIdentifier.isMaven() ? this.componentIdentifier.get(coordinate) : null;
    }

    public void setCatalogDate(Long catalogDate) {
        this.catalogDate = catalogDate;
    }

    public void setDeclaredLicenses(Set<License> declaredLicenses) {
        this.declaredLicenses = declaredLicenses;
    }

    public void setObservedLicenses(Set<License> observedLicenses) {
        this.observedLicenses = observedLicenses;
    }

    public void setOverriddenLicenses(Set<License> overriddenLicenses) {
        this.overriddenLicenses = overriddenLicenses;
    }

    public void setPolicyAlerts(List<PolicyAlert> policyAlerts) {
        this.policyAlerts = policyAlerts;
    }

    public void setRelativePopularity(int relativePopularity) {
        this.relativePopularity = relativePopularity;
    }

    public void setSecurityVulnerabilities(List<SecurityVulnerability> securityVulnerabilities) {
        this.securityVulnerabilities = securityVulnerabilities;
    }

    public void addSecurityVulnerability(SecurityVulnerability securityVulnerability) {
        if (securityVulnerability == null) {
            return;
        }
        this.securityVulnerabilities.add(securityVulnerability);
    }

    public Integer getLicenseThreatLevel() {
        return this.licenseThreatLevel;
    }

    public void setLicenseThreatLevel(Integer licenseThreatLevel) {
        this.licenseThreatLevel = licenseThreatLevel;
    }

    public List<String> getLicenseThreatGroupNames() {
        return this.licenseThreatGroupNames;
    }

    public void setLicenseThreatGroupNames(List<String> licenseThreatGroupNames) {
        this.licenseThreatGroupNames = licenseThreatGroupNames;
    }

    @Override
    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    @Override
    public String getMatchState() {
        return this.matchState;
    }

    public void setMatchState(String matchState) {
        this.matchState = matchState;
    }

    @Override
    public Set<String> getDeclaredLicenseIds() {
        return this.toLicenseIds(this.getDeclaredLicenses());
    }

    @Override
    public Set<String> getObservedLicenseIds() {
        return this.toLicenseIds(this.getObservedLicenses());
    }

    private Set<String> toLicenseIds(Set<License> licenses) {
        if (licenses == null) {
            return null;
        }
        LinkedHashSet<String> licenseIds = new LinkedHashSet<String>();
        for (License license : licenses) {
            licenseIds.add(license.getLicenseId());
        }
        return licenseIds;
    }

    public boolean isMajorRevisionStep() {
        return this.majorRevisionStep;
    }

    public void setMajorRevisionStep(boolean majorRevisionStep) {
        this.majorRevisionStep = majorRevisionStep;
    }

    @Override
    public String getIdentificationSource() {
        return this.identificationSource;
    }

    public void setIdentificationSource(String identificationSource) {
        this.identificationSource = identificationSource;
    }

    public String getIdentificationSourceComment() {
        return this.identificationSourceComment;
    }

    public void setIdentificationSourceComment(String identificationSourceComment) {
        this.identificationSourceComment = identificationSourceComment;
    }

    public String getWebsite() {
        return this.website;
    }

    public void setWebsite(String website) {
        this.website = website;
    }

    @Override
    public ComponentIdentifier getComponentIdentifier() {
        return this.componentIdentifier;
    }

    public void setComponentIdentifier(ComponentIdentifier componentIdentifier) {
        this.componentIdentifier = componentIdentifier;
    }
}

