/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.smile;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.base.ParserBase;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.core.sym.BytesToNameCanonicalizer;
import com.fasterxml.jackson.core.sym.Name;
import com.fasterxml.jackson.dataformat.smile.PackageVersion;
import com.fasterxml.jackson.dataformat.smile.SmileBufferRecycler;
import com.fasterxml.jackson.dataformat.smile.SmileConstants;
import com.fasterxml.jackson.dataformat.smile.SmileUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;

public class SmileParser
extends ParserBase {
    private static final int[] NO_INTS = new int[0];
    private static final String[] NO_STRINGS = new String[0];
    protected ObjectCodec _objectCodec;
    protected boolean _mayContainRawBinary;
    protected final SmileBufferRecycler<String> _smileBufferRecycler;
    protected InputStream _inputStream;
    protected byte[] _inputBuffer;
    protected boolean _bufferRecyclable;
    protected boolean _tokenIncomplete = false;
    protected int _typeByte;
    protected boolean _got32BitFloat;
    protected final BytesToNameCanonicalizer _symbols;
    protected int[] _quadBuffer = NO_INTS;
    protected int _quad1;
    protected int _quad2;
    protected String[] _seenNames = NO_STRINGS;
    protected int _seenNameCount = 0;
    protected String[] _seenStringValues = null;
    protected int _seenStringValueCount = -1;
    protected static final ThreadLocal<SoftReference<SmileBufferRecycler<String>>> _smileRecyclerRef = new ThreadLocal();

    public SmileParser(IOContext iOContext, int n, int n2, ObjectCodec objectCodec, BytesToNameCanonicalizer bytesToNameCanonicalizer, InputStream inputStream, byte[] byArray, int n3, int n4, boolean bl) {
        super(iOContext, n);
        this._objectCodec = objectCodec;
        this._symbols = bytesToNameCanonicalizer;
        this._inputStream = inputStream;
        this._inputBuffer = byArray;
        this._inputPtr = n3;
        this._inputEnd = n4;
        this._bufferRecyclable = bl;
        this._tokenInputRow = -1;
        this._tokenInputCol = -1;
        this._smileBufferRecycler = SmileParser._smileBufferRecycler();
    }

    public ObjectCodec getCodec() {
        return this._objectCodec;
    }

    public void setCodec(ObjectCodec objectCodec) {
        this._objectCodec = objectCodec;
    }

    protected boolean handleSignature(boolean bl, boolean bl2) throws IOException, JsonParseException {
        byte by;
        int n;
        if (bl) {
            ++this._inputPtr;
        }
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (this._inputBuffer[this._inputPtr] != 41) {
            if (bl2) {
                this._reportError("Malformed content: signature not valid, starts with 0x3a but followed by 0x" + Integer.toHexString(this._inputBuffer[this._inputPtr]) + ", not 0x29");
            }
            return false;
        }
        if (++this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (this._inputBuffer[this._inputPtr] != 10) {
            if (bl2) {
                this._reportError("Malformed content: signature not valid, starts with 0x3a, 0x29, but followed by 0x" + Integer.toHexString(this._inputBuffer[this._inputPtr]) + ", not 0xA");
            }
            return false;
        }
        if (++this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if ((n = (by = this._inputBuffer[this._inputPtr++]) >> 4 & 0xF) != 0) {
            this._reportError("Header version number bits (0x" + Integer.toHexString(n) + ") indicate unrecognized version; only 0x0 handled by parser");
        }
        if ((by & 1) == 0) {
            this._seenNames = null;
            this._seenNameCount = -1;
        }
        if ((by & 2) != 0) {
            this._seenStringValues = NO_STRINGS;
            this._seenStringValueCount = 0;
        }
        this._mayContainRawBinary = (by & 4) != 0;
        return true;
    }

    protected static final SmileBufferRecycler<String> _smileBufferRecycler() {
        SmileBufferRecycler<String> smileBufferRecycler;
        SoftReference<SmileBufferRecycler<String>> softReference = _smileRecyclerRef.get();
        SmileBufferRecycler<String> smileBufferRecycler2 = smileBufferRecycler = softReference == null ? null : softReference.get();
        if (smileBufferRecycler == null) {
            smileBufferRecycler = new SmileBufferRecycler();
            _smileRecyclerRef.set(new SoftReference<SmileBufferRecycler<String>>(smileBufferRecycler));
        }
        return smileBufferRecycler;
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public int releaseBuffered(OutputStream outputStream) throws IOException {
        int n = this._inputEnd - this._inputPtr;
        if (n < 1) {
            return 0;
        }
        int n2 = this._inputPtr;
        outputStream.write(this._inputBuffer, n2, n);
        return n;
    }

    public Object getInputSource() {
        return this._inputStream;
    }

    public JsonLocation getTokenLocation() {
        return new JsonLocation(this._ioContext.getSourceReference(), this._tokenInputTotal, -1L, -1, (int)this._tokenInputTotal);
    }

    public JsonLocation getCurrentLocation() {
        long l = this._currInputProcessed + (long)this._inputPtr;
        return new JsonLocation(this._ioContext.getSourceReference(), l, -1L, -1, (int)l);
    }

    protected final boolean loadMore() throws IOException {
        this._currInputProcessed += (long)this._inputEnd;
        if (this._inputStream != null) {
            int n = this._inputStream.read(this._inputBuffer, 0, this._inputBuffer.length);
            if (n > 0) {
                this._inputPtr = 0;
                this._inputEnd = n;
                return true;
            }
            this._closeInput();
            if (n == 0) {
                throw new IOException("InputStream.read() returned 0 characters when trying to read " + this._inputBuffer.length + " bytes");
            }
        }
        return false;
    }

    protected final boolean _loadToHaveAtLeast(int n) throws IOException {
        if (this._inputStream == null) {
            return false;
        }
        int n2 = this._inputEnd - this._inputPtr;
        if (n2 > 0 && this._inputPtr > 0) {
            this._currInputProcessed += (long)this._inputPtr;
            System.arraycopy(this._inputBuffer, this._inputPtr, this._inputBuffer, 0, n2);
            this._inputEnd = n2;
        } else {
            this._inputEnd = 0;
        }
        this._inputPtr = 0;
        while (this._inputEnd < n) {
            int n3 = this._inputStream.read(this._inputBuffer, this._inputEnd, this._inputBuffer.length - this._inputEnd);
            if (n3 < 1) {
                this._closeInput();
                if (n3 == 0) {
                    throw new IOException("InputStream.read() returned 0 characters when trying to read " + n2 + " bytes");
                }
                return false;
            }
            this._inputEnd += n3;
        }
        return true;
    }

    protected void _closeInput() throws IOException {
        if (this._inputStream != null) {
            if (this._ioContext.isResourceManaged() || this.isEnabled(JsonParser.Feature.AUTO_CLOSE_SOURCE)) {
                this._inputStream.close();
            }
            this._inputStream = null;
        }
    }

    protected void _finishString() throws IOException, JsonParseException {
        this._throwInternal();
    }

    public void close() throws IOException {
        super.close();
        this._symbols.release();
    }

    public boolean hasTextCharacters() {
        if (this._currToken == JsonToken.VALUE_STRING) {
            return this._textBuffer.hasTextAsCharacters();
        }
        if (this._currToken == JsonToken.FIELD_NAME) {
            return this._nameCopied;
        }
        return false;
    }

    protected void _releaseBuffers() throws IOException {
        Object[] objectArray;
        super._releaseBuffers();
        if (this._bufferRecyclable && (objectArray = this._inputBuffer) != null) {
            this._inputBuffer = null;
            this._ioContext.releaseReadIOBuffer(objectArray);
        }
        if ((objectArray = (Object[])this._seenNames) != null && objectArray.length > 0) {
            this._seenNames = null;
            if (this._seenNameCount > 0) {
                Arrays.fill(objectArray, 0, this._seenNameCount, null);
            }
            this._smileBufferRecycler.releaseSeenNamesBuffer((String[])objectArray);
        }
        if ((objectArray = (Object[])this._seenStringValues) != null && objectArray.length > 0) {
            this._seenStringValues = null;
            if (this._seenStringValueCount > 0) {
                Arrays.fill(objectArray, 0, this._seenStringValueCount, null);
            }
            this._smileBufferRecycler.releaseSeenStringValuesBuffer((String[])objectArray);
        }
    }

    public boolean mayContainRawBinary() {
        return this._mayContainRawBinary;
    }

    public JsonToken nextToken() throws IOException, JsonParseException {
        int n;
        this._numTypesValid = 0;
        if (this._tokenIncomplete) {
            this._skipIncomplete();
        }
        this._tokenInputTotal = this._currInputProcessed + (long)this._inputPtr;
        this._binaryValue = null;
        if (this._parsingContext.inObject() && this._currToken != JsonToken.FIELD_NAME) {
            this._currToken = this._handleFieldName();
            return this._currToken;
        }
        if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
            this._handleEOF();
            this.close();
            this._currToken = null;
            return null;
        }
        this._typeByte = n = this._inputBuffer[this._inputPtr++];
        switch (n >> 5 & 7) {
            case 0: {
                if (n == 0) {
                    this._reportError("Invalid token byte 0x00");
                }
                return this._handleSharedString(n - 1);
            }
            case 1: {
                int n2 = n & 0x1F;
                if (n2 < 4) {
                    switch (n2) {
                        case 0: {
                            this._textBuffer.resetWithEmpty();
                            this._currToken = JsonToken.VALUE_STRING;
                            return this._currToken;
                        }
                        case 1: {
                            this._currToken = JsonToken.VALUE_NULL;
                            return this._currToken;
                        }
                        case 2: {
                            this._currToken = JsonToken.VALUE_FALSE;
                            return this._currToken;
                        }
                    }
                    this._currToken = JsonToken.VALUE_TRUE;
                    return this._currToken;
                }
                if (n2 < 8) {
                    if ((n2 & 3) > 2) break;
                    this._tokenIncomplete = true;
                    this._numTypesValid = 0;
                    this._currToken = JsonToken.VALUE_NUMBER_INT;
                    return this._currToken;
                }
                if (n2 < 12) {
                    int n3 = n2 & 3;
                    if (n3 > 2) break;
                    this._tokenIncomplete = true;
                    this._numTypesValid = 0;
                    this._got32BitFloat = n3 == 0;
                    this._currToken = JsonToken.VALUE_NUMBER_FLOAT;
                    return this._currToken;
                }
                if (n2 == 26 && this.handleSignature(false, false)) {
                    if (this._currToken == null) {
                        return this.nextToken();
                    }
                    this._currToken = null;
                    return null;
                }
                this._reportError("Unrecognized token byte 0x3A (malformed segment header?");
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this._currToken = JsonToken.VALUE_STRING;
                if (this._seenStringValueCount >= 0) {
                    this._addSeenStringValue();
                } else {
                    this._tokenIncomplete = true;
                }
                return this._currToken;
            }
            case 6: {
                this._numberInt = SmileUtil.zigzagDecode(n & 0x1F);
                this._numTypesValid = 1;
                this._currToken = JsonToken.VALUE_NUMBER_INT;
                return this._currToken;
            }
            case 7: {
                switch (n & 0x1F) {
                    case 0: 
                    case 4: {
                        this._tokenIncomplete = true;
                        this._currToken = JsonToken.VALUE_STRING;
                        return this._currToken;
                    }
                    case 8: {
                        this._tokenIncomplete = true;
                        this._currToken = JsonToken.VALUE_EMBEDDED_OBJECT;
                        return this._currToken;
                    }
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: {
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        return this._handleSharedString(((n & 3) << 8) + (this._inputBuffer[this._inputPtr++] & 0xFF));
                    }
                    case 24: {
                        this._parsingContext = this._parsingContext.createChildArrayContext(-1, -1);
                        this._currToken = JsonToken.START_ARRAY;
                        return this._currToken;
                    }
                    case 25: {
                        if (!this._parsingContext.inArray()) {
                            this._reportMismatchedEndMarker(93, '}');
                        }
                        this._parsingContext = this._parsingContext.getParent();
                        this._currToken = JsonToken.END_ARRAY;
                        return this._currToken;
                    }
                    case 26: {
                        this._parsingContext = this._parsingContext.createChildObjectContext(-1, -1);
                        this._currToken = JsonToken.START_OBJECT;
                        return this._currToken;
                    }
                    case 27: {
                        this._reportError("Invalid type marker byte 0xFB in value mode (would be END_OBJECT in key mode)");
                    }
                    case 29: {
                        this._tokenIncomplete = true;
                        this._currToken = JsonToken.VALUE_EMBEDDED_OBJECT;
                        return this._currToken;
                    }
                    case 31: {
                        this._currToken = null;
                        return null;
                    }
                }
            }
        }
        this._reportError("Invalid type marker byte 0x" + Integer.toHexString(n & 0xFF) + " for expected value token");
        return null;
    }

    private final JsonToken _handleSharedString(int n) throws IOException, JsonParseException {
        if (n >= this._seenStringValueCount) {
            this._reportInvalidSharedStringValue(n);
        }
        this._textBuffer.resetWithString(this._seenStringValues[n]);
        this._currToken = JsonToken.VALUE_STRING;
        return this._currToken;
    }

    private final void _addSeenStringValue() throws IOException, JsonParseException {
        this._finishToken();
        if (this._seenStringValueCount < this._seenStringValues.length) {
            this._seenStringValues[this._seenStringValueCount++] = this._textBuffer.contentsAsString();
            return;
        }
        this._expandSeenStringValues();
    }

    private final void _expandSeenStringValues() {
        String[] stringArray;
        String[] stringArray2 = this._seenStringValues;
        int n = stringArray2.length;
        if (n == 0) {
            stringArray = this._smileBufferRecycler.allocSeenStringValuesBuffer();
            if (stringArray == null) {
                stringArray = new String[64];
            }
        } else if (n == 1024) {
            stringArray = stringArray2;
            this._seenStringValueCount = 0;
        } else {
            int n2 = n == 64 ? 256 : 1024;
            stringArray = new String[n2];
            System.arraycopy(stringArray2, 0, stringArray, 0, stringArray2.length);
        }
        this._seenStringValues = stringArray;
        this._seenStringValues[this._seenStringValueCount++] = this._textBuffer.contentsAsString();
    }

    public JsonParser.NumberType getNumberType() throws IOException, JsonParseException {
        if (this._got32BitFloat) {
            return JsonParser.NumberType.FLOAT;
        }
        return super.getNumberType();
    }

    public boolean nextFieldName(SerializableString serializableString) throws IOException, JsonParseException {
        if (this._parsingContext.inObject() && this._currToken != JsonToken.FIELD_NAME) {
            JsonToken jsonToken;
            byte[] byArray = serializableString.asQuotedUTF8();
            int n = byArray.length;
            if (this._inputPtr + n + 1 < this._inputEnd) {
                int n2;
                int n3 = this._inputPtr;
                this._typeByte = n2 = this._inputBuffer[n3++];
                block0 : switch (n2 >> 6 & 3) {
                    case 0: {
                        switch (n2) {
                            case 32: {
                                this._currToken = JsonToken.FIELD_NAME;
                                this._inputPtr = n3;
                                this._parsingContext.setCurrentName("");
                                return n == 0;
                            }
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: {
                                int n4 = ((n2 & 3) << 8) + (this._inputBuffer[n3++] & 0xFF);
                                if (n4 >= this._seenNameCount) {
                                    this._reportInvalidSharedName(n4);
                                }
                                String string = this._seenNames[n4];
                                this._parsingContext.setCurrentName(string);
                                this._inputPtr = n3;
                                this._currToken = JsonToken.FIELD_NAME;
                                return string.equals(serializableString.getValue());
                            }
                        }
                        break;
                    }
                    case 1: {
                        int n5 = n2 & 0x3F;
                        if (n5 >= this._seenNameCount) {
                            this._reportInvalidSharedName(n5);
                        }
                        this._parsingContext.setCurrentName(this._seenNames[n5]);
                        String string = this._seenNames[n5];
                        this._parsingContext.setCurrentName(string);
                        this._inputPtr = n3;
                        this._currToken = JsonToken.FIELD_NAME;
                        return string.equals(serializableString.getValue());
                    }
                    case 2: {
                        int n6 = 1 + (n2 & 0x3F);
                        if (n6 != n) break;
                        for (int i = 0; i < n6; ++i) {
                            if (byArray[i] != this._inputBuffer[n3 + i]) break block0;
                        }
                        this._inputPtr = n3 + n6;
                        String string = serializableString.getValue();
                        if (this._seenNames != null) {
                            if (this._seenNameCount >= this._seenNames.length) {
                                this._seenNames = this._expandSeenNames(this._seenNames);
                            }
                            this._seenNames[this._seenNameCount++] = string;
                        }
                        this._parsingContext.setCurrentName(string);
                        this._currToken = JsonToken.FIELD_NAME;
                        return true;
                    }
                    case 3: {
                        int n7 = n2 & 0x3F;
                        if (n7 > 55) {
                            if (n7 != 59) break;
                            this._currToken = JsonToken.END_OBJECT;
                            if (!this._parsingContext.inObject()) {
                                this._reportMismatchedEndMarker(125, ']');
                            }
                            this._inputPtr = n3;
                            this._parsingContext = this._parsingContext.getParent();
                            return false;
                        }
                        if ((n7 += 2) != n) break;
                        for (int i = 0; i < n7; ++i) {
                            if (byArray[i] != this._inputBuffer[n3 + i]) break block0;
                        }
                        this._inputPtr = n3 + n7;
                        String string = serializableString.getValue();
                        if (this._seenNames != null) {
                            if (this._seenNameCount >= this._seenNames.length) {
                                this._seenNames = this._expandSeenNames(this._seenNames);
                            }
                            this._seenNames[this._seenNameCount++] = string;
                        }
                        this._parsingContext.setCurrentName(string);
                        this._currToken = JsonToken.FIELD_NAME;
                        return true;
                    }
                }
            }
            this._currToken = jsonToken = this._handleFieldName();
            return jsonToken == JsonToken.FIELD_NAME && serializableString.getValue().equals(this._parsingContext.getCurrentName());
        }
        return this.nextToken() == JsonToken.FIELD_NAME && serializableString.getValue().equals(this.getCurrentName());
    }

    public String nextTextValue() throws IOException, JsonParseException {
        if (!this._parsingContext.inObject() || this._currToken == JsonToken.FIELD_NAME) {
            int n;
            if (this._tokenIncomplete) {
                this._skipIncomplete();
            }
            if ((n = this._inputPtr) >= this._inputEnd) {
                if (!this.loadMore()) {
                    this._handleEOF();
                    this.close();
                    this._currToken = null;
                    return null;
                }
                n = this._inputPtr;
            }
            int n2 = this._inputBuffer[n++];
            this._tokenInputTotal = this._currInputProcessed + (long)this._inputPtr;
            this._binaryValue = null;
            this._typeByte = n2;
            switch (n2 >> 5 & 7) {
                case 0: {
                    if (n2 == 0) {
                        this._reportError("Invalid token byte 0x00");
                    }
                    if (--n2 >= this._seenStringValueCount) {
                        this._reportInvalidSharedStringValue(n2);
                    }
                    this._inputPtr = n;
                    String string = this._seenStringValues[n2];
                    this._textBuffer.resetWithString(string);
                    this._currToken = JsonToken.VALUE_STRING;
                    return string;
                }
                case 1: {
                    int n3 = n2 & 0x1F;
                    if (n3 != 0) break;
                    this._inputPtr = n;
                    this._textBuffer.resetWithEmpty();
                    this._currToken = JsonToken.VALUE_STRING;
                    return "";
                }
                case 2: 
                case 3: {
                    String string;
                    this._currToken = JsonToken.VALUE_STRING;
                    this._inputPtr = n;
                    this._decodeShortAsciiValue(1 + (n2 & 0x3F));
                    if (this._seenStringValueCount >= 0) {
                        if (this._seenStringValueCount < this._seenStringValues.length) {
                            string = this._textBuffer.contentsAsString();
                            this._seenStringValues[this._seenStringValueCount++] = string;
                        } else {
                            this._expandSeenStringValues();
                            string = this._textBuffer.contentsAsString();
                        }
                    } else {
                        string = this._textBuffer.contentsAsString();
                    }
                    return string;
                }
                case 4: 
                case 5: {
                    String string;
                    this._currToken = JsonToken.VALUE_STRING;
                    this._inputPtr = n;
                    this._decodeShortUnicodeValue(2 + (n2 & 0x3F));
                    if (this._seenStringValueCount >= 0) {
                        if (this._seenStringValueCount < this._seenStringValues.length) {
                            string = this._textBuffer.contentsAsString();
                            this._seenStringValues[this._seenStringValueCount++] = string;
                        } else {
                            this._expandSeenStringValues();
                            string = this._textBuffer.contentsAsString();
                        }
                    } else {
                        string = this._textBuffer.contentsAsString();
                    }
                    return string;
                }
                case 6: {
                    break;
                }
            }
        }
        return this.nextToken() == JsonToken.VALUE_STRING ? this.getText() : null;
    }

    public int nextIntValue(int n) throws IOException, JsonParseException {
        if (this.nextToken() == JsonToken.VALUE_NUMBER_INT) {
            return this.getIntValue();
        }
        return n;
    }

    public long nextLongValue(long l) throws IOException, JsonParseException {
        if (this.nextToken() == JsonToken.VALUE_NUMBER_INT) {
            return this.getLongValue();
        }
        return l;
    }

    public Boolean nextBooleanValue() throws IOException, JsonParseException {
        switch (this.nextToken()) {
            case VALUE_TRUE: {
                return Boolean.TRUE;
            }
            case VALUE_FALSE: {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    public String getText() throws IOException, JsonParseException {
        if (this._tokenIncomplete) {
            this._tokenIncomplete = false;
            int n = this._typeByte;
            int n2 = n >> 5 & 7;
            if (n2 == 2 || n2 == 3) {
                this._decodeShortAsciiValue(1 + (n & 0x3F));
                return this._textBuffer.contentsAsString();
            }
            if (n2 == 4 || n2 == 5) {
                this._decodeShortUnicodeValue(2 + (n & 0x3F));
                return this._textBuffer.contentsAsString();
            }
            this._finishToken();
        }
        if (this._currToken == JsonToken.VALUE_STRING) {
            return this._textBuffer.contentsAsString();
        }
        JsonToken jsonToken = this._currToken;
        if (jsonToken == null) {
            return null;
        }
        if (jsonToken == JsonToken.FIELD_NAME) {
            return this._parsingContext.getCurrentName();
        }
        if (jsonToken.isNumeric()) {
            return this.getNumberValue().toString();
        }
        return this._currToken.asString();
    }

    public char[] getTextCharacters() throws IOException, JsonParseException {
        if (this._currToken != null) {
            if (this._tokenIncomplete) {
                this._finishToken();
            }
            switch (this._currToken) {
                case VALUE_STRING: {
                    return this._textBuffer.getTextBuffer();
                }
                case FIELD_NAME: {
                    if (!this._nameCopied) {
                        String string = this._parsingContext.getCurrentName();
                        int n = string.length();
                        if (this._nameCopyBuffer == null) {
                            this._nameCopyBuffer = this._ioContext.allocNameCopyBuffer(n);
                        } else if (this._nameCopyBuffer.length < n) {
                            this._nameCopyBuffer = new char[n];
                        }
                        string.getChars(0, n, this._nameCopyBuffer, 0);
                        this._nameCopied = true;
                    }
                    return this._nameCopyBuffer;
                }
                case VALUE_NUMBER_INT: 
                case VALUE_NUMBER_FLOAT: {
                    return this.getNumberValue().toString().toCharArray();
                }
            }
            return this._currToken.asCharArray();
        }
        return null;
    }

    public int getTextLength() throws IOException, JsonParseException {
        if (this._currToken != null) {
            if (this._tokenIncomplete) {
                this._finishToken();
            }
            switch (this._currToken) {
                case VALUE_STRING: {
                    return this._textBuffer.size();
                }
                case FIELD_NAME: {
                    return this._parsingContext.getCurrentName().length();
                }
                case VALUE_NUMBER_INT: 
                case VALUE_NUMBER_FLOAT: {
                    return this.getNumberValue().toString().length();
                }
            }
            return this._currToken.asCharArray().length;
        }
        return 0;
    }

    public int getTextOffset() throws IOException, JsonParseException {
        return 0;
    }

    public String getValueAsString() throws IOException, JsonParseException {
        if (!(this._currToken == JsonToken.VALUE_STRING || this._currToken != null && this._currToken != JsonToken.VALUE_NULL && this._currToken.isScalarValue())) {
            return null;
        }
        return this.getText();
    }

    public String getValueAsString(String string) throws IOException, JsonParseException {
        if (!(this._currToken == JsonToken.VALUE_STRING || this._currToken != null && this._currToken != JsonToken.VALUE_NULL && this._currToken.isScalarValue())) {
            return string;
        }
        return this.getText();
    }

    public byte[] getBinaryValue(Base64Variant base64Variant) throws IOException, JsonParseException {
        if (this._tokenIncomplete) {
            this._finishToken();
        }
        if (this._currToken != JsonToken.VALUE_EMBEDDED_OBJECT) {
            this._reportError("Current token (" + this._currToken + ") not VALUE_EMBEDDED_OBJECT, can not access as binary");
        }
        return this._binaryValue;
    }

    public Object getEmbeddedObject() throws IOException, JsonParseException {
        if (this._tokenIncomplete) {
            this._finishToken();
        }
        if (this._currToken == JsonToken.VALUE_EMBEDDED_OBJECT) {
            return this._binaryValue;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readBinaryValue(Base64Variant base64Variant, OutputStream outputStream) throws IOException, JsonParseException {
        if (this._currToken != JsonToken.VALUE_EMBEDDED_OBJECT) {
            this._reportError("Current token (" + this._currToken + ") not VALUE_EMBEDDED_OBJECT, can not access as binary");
        }
        if (!this._tokenIncomplete) {
            if (this._binaryValue == null) {
                return 0;
            }
            int n = this._binaryValue.length;
            outputStream.write(this._binaryValue, 0, n);
            return n;
        }
        if (this._typeByte == -3) {
            int n;
            int n2;
            for (int i = n = this._readUnsignedVInt(); i > 0; i -= n2) {
                int n3 = this._inputEnd - this._inputPtr;
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                    n3 = this._inputEnd - this._inputPtr;
                }
                n2 = Math.min(n3, i);
                outputStream.write(this._inputBuffer, this._inputPtr, n2);
                this._inputPtr += n2;
            }
            this._tokenIncomplete = false;
            return n;
        }
        if (this._typeByte != -24) {
            this._throwInternal();
        }
        int n = this._readUnsignedVInt();
        byte[] byArray = this._ioContext.allocBase64Buffer();
        try {
            this._readBinaryEncoded(outputStream, n, byArray);
        }
        finally {
            this._ioContext.releaseBase64Buffer(byArray);
        }
        this._tokenIncomplete = false;
        return n;
    }

    private void _readBinaryEncoded(OutputStream outputStream, int n, byte[] byArray) throws IOException, JsonParseException {
        int n2;
        int n3;
        int n4 = 0;
        int n5 = byArray.length - 7;
        while (n > 7) {
            if (this._inputEnd - this._inputPtr < 8) {
                this._loadToHaveAtLeast(8);
            }
            n3 = (this._inputBuffer[this._inputPtr++] << 25) + (this._inputBuffer[this._inputPtr++] << 18) + (this._inputBuffer[this._inputPtr++] << 11) + (this._inputBuffer[this._inputPtr++] << 4);
            n2 = this._inputBuffer[this._inputPtr++];
            int n6 = ((n2 & 7) << 21) + (this._inputBuffer[this._inputPtr++] << 14) + (this._inputBuffer[this._inputPtr++] << 7) + this._inputBuffer[this._inputPtr++];
            byArray[n4++] = (byte)((n3 += n2 >> 3) >> 24);
            byArray[n4++] = (byte)(n3 >> 16);
            byArray[n4++] = (byte)(n3 >> 8);
            byArray[n4++] = (byte)n3;
            byArray[n4++] = (byte)(n6 >> 16);
            byArray[n4++] = (byte)(n6 >> 8);
            byArray[n4++] = (byte)n6;
            n -= 7;
            if (n4 <= n5) continue;
            outputStream.write(byArray, 0, n4);
            n4 = 0;
        }
        if (n > 0) {
            if (this._inputEnd - this._inputPtr < n + 1) {
                this._loadToHaveAtLeast(n + 1);
            }
            n3 = this._inputBuffer[this._inputPtr++];
            for (n2 = 1; n2 < n; ++n2) {
                n3 = (n3 << 7) + this._inputBuffer[this._inputPtr++];
                byArray[n4++] = (byte)(n3 >> 7 - n2);
            }
            byArray[n4++] = (byte)((n3 <<= n) + this._inputBuffer[this._inputPtr++]);
        }
        if (n4 > 0) {
            outputStream.write(byArray, 0, n4);
        }
    }

    protected final JsonToken _handleFieldName() throws IOException, JsonParseException {
        int n;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        this._typeByte = n = this._inputBuffer[this._inputPtr++];
        switch (n >> 6 & 3) {
            case 0: {
                switch (n) {
                    case 32: {
                        this._parsingContext.setCurrentName("");
                        return JsonToken.FIELD_NAME;
                    }
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: {
                        int n2;
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if ((n2 = ((n & 3) << 8) + (this._inputBuffer[this._inputPtr++] & 0xFF)) >= this._seenNameCount) {
                            this._reportInvalidSharedName(n2);
                        }
                        this._parsingContext.setCurrentName(this._seenNames[n2]);
                        return JsonToken.FIELD_NAME;
                    }
                    case 52: {
                        this._handleLongFieldName();
                        return JsonToken.FIELD_NAME;
                    }
                }
                break;
            }
            case 1: {
                int n3 = n & 0x3F;
                if (n3 >= this._seenNameCount) {
                    this._reportInvalidSharedName(n3);
                }
                this._parsingContext.setCurrentName(this._seenNames[n3]);
                return JsonToken.FIELD_NAME;
            }
            case 2: {
                String string;
                int n4 = 1 + (n & 0x3F);
                Name name = this._findDecodedFromSymbols(n4);
                if (name != null) {
                    string = name.getName();
                    this._inputPtr += n4;
                } else {
                    string = this._decodeShortAsciiName(n4);
                    string = this._addDecodedToSymbols(n4, string);
                }
                if (this._seenNames != null) {
                    if (this._seenNameCount >= this._seenNames.length) {
                        this._seenNames = this._expandSeenNames(this._seenNames);
                    }
                    this._seenNames[this._seenNameCount++] = string;
                }
                this._parsingContext.setCurrentName(string);
                return JsonToken.FIELD_NAME;
            }
            case 3: {
                String string;
                if ((n &= 0x3F) > 55) {
                    if (n != 59) break;
                    if (!this._parsingContext.inObject()) {
                        this._reportMismatchedEndMarker(125, ']');
                    }
                    this._parsingContext = this._parsingContext.getParent();
                    return JsonToken.END_OBJECT;
                }
                int n5 = n + 2;
                Name name = this._findDecodedFromSymbols(n5);
                if (name != null) {
                    string = name.getName();
                    this._inputPtr += n5;
                } else {
                    string = this._decodeShortUnicodeName(n5);
                    string = this._addDecodedToSymbols(n5, string);
                }
                if (this._seenNames != null) {
                    if (this._seenNameCount >= this._seenNames.length) {
                        this._seenNames = this._expandSeenNames(this._seenNames);
                    }
                    this._seenNames[this._seenNameCount++] = string;
                }
                this._parsingContext.setCurrentName(string);
                return JsonToken.FIELD_NAME;
            }
        }
        this._reportError("Invalid type marker byte 0x" + Integer.toHexString(this._typeByte) + " for expected field name (or END_OBJECT marker)");
        return null;
    }

    private final String[] _expandSeenNames(String[] stringArray) {
        String[] stringArray2;
        int n = stringArray.length;
        if (n == 0) {
            stringArray2 = this._smileBufferRecycler.allocSeenNamesBuffer();
            if (stringArray2 == null) {
                stringArray2 = new String[64];
            }
        } else if (n == 1024) {
            stringArray2 = stringArray;
            this._seenNameCount = 0;
        } else {
            int n2 = n == 64 ? 256 : 1024;
            stringArray2 = new String[n2];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        }
        return stringArray2;
    }

    private final String _addDecodedToSymbols(int n, String string) {
        if (n < 5) {
            return this._symbols.addName(string, this._quad1, 0).getName();
        }
        if (n < 9) {
            return this._symbols.addName(string, this._quad1, this._quad2).getName();
        }
        int n2 = n + 3 >> 2;
        return this._symbols.addName(string, this._quadBuffer, n2).getName();
    }

    private final String _decodeShortAsciiName(int n) throws IOException, JsonParseException {
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        int n2 = 0;
        byte[] byArray = this._inputBuffer;
        int n3 = this._inputPtr;
        int n4 = n3 + n - 3;
        while (n3 < n4) {
            cArray[n2++] = (char)byArray[n3++];
            cArray[n2++] = (char)byArray[n3++];
            cArray[n2++] = (char)byArray[n3++];
            cArray[n2++] = (char)byArray[n3++];
        }
        n4 = n & 3;
        if (n4 > 0) {
            cArray[n2++] = (char)byArray[n3++];
            if (n4 > 1) {
                cArray[n2++] = (char)byArray[n3++];
                if (n4 > 2) {
                    cArray[n2++] = (char)byArray[n3++];
                }
            }
        }
        this._inputPtr = n3;
        this._textBuffer.setCurrentLength(n);
        return this._textBuffer.contentsAsString();
    }

    private final String _decodeShortUnicodeName(int n) throws IOException, JsonParseException {
        int n2 = 0;
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        int n3 = this._inputPtr;
        this._inputPtr += n;
        int[] nArray = SmileConstants.sUtf8UnitLengths;
        byte[] byArray = this._inputBuffer;
        int n4 = n3 + n;
        while (n3 < n4) {
            int n5;
            int n6;
            if ((n6 = nArray[n5 = byArray[n3++] & 0xFF]) != 0) {
                switch (n6) {
                    case 1: {
                        n5 = (n5 & 0x1F) << 6 | byArray[n3++] & 0x3F;
                        break;
                    }
                    case 2: {
                        n5 = (n5 & 0xF) << 12 | (byArray[n3++] & 0x3F) << 6 | byArray[n3++] & 0x3F;
                        break;
                    }
                    case 3: {
                        n5 = (n5 & 7) << 18 | (byArray[n3++] & 0x3F) << 12 | (byArray[n3++] & 0x3F) << 6 | byArray[n3++] & 0x3F;
                        cArray[n2++] = (char)(0xD800 | (n5 -= 65536) >> 10);
                        n5 = 0xDC00 | n5 & 0x3FF;
                        break;
                    }
                    default: {
                        this._reportError("Invalid byte " + Integer.toHexString(n5) + " in short Unicode text block");
                    }
                }
            }
            cArray[n2++] = (char)n5;
        }
        this._textBuffer.setCurrentLength(n2);
        return this._textBuffer.contentsAsString();
    }

    private final Name _decodeLongUnicodeName(int[] nArray, int n, int n2) throws IOException, JsonParseException {
        int n3;
        int n4 = n & 3;
        if (n4 < 4) {
            n3 = nArray[n2 - 1];
            nArray[n2 - 1] = n3 << (4 - n4 << 3);
        } else {
            n3 = 0;
        }
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        int n5 = 0;
        int n6 = 0;
        while (n6 < n) {
            int n7 = nArray[n6 >> 2];
            int n8 = n6 & 3;
            n7 = n7 >> (3 - n8 << 3) & 0xFF;
            ++n6;
            if (n7 > 127) {
                int n9;
                if ((n7 & 0xE0) == 192) {
                    n7 &= 0x1F;
                    n9 = 1;
                } else if ((n7 & 0xF0) == 224) {
                    n7 &= 0xF;
                    n9 = 2;
                } else if ((n7 & 0xF8) == 240) {
                    n7 &= 7;
                    n9 = 3;
                } else {
                    this._reportInvalidInitial(n7);
                    n7 = 1;
                    n9 = 1;
                }
                if (n6 + n9 > n) {
                    this._reportInvalidEOF(" in long field name");
                }
                int n10 = nArray[n6 >> 2];
                n8 = n6 & 3;
                ++n6;
                if (((n10 >>= 3 - n8 << 3) & 0xC0) != 128) {
                    this._reportInvalidOther(n10);
                }
                n7 = n7 << 6 | n10 & 0x3F;
                if (n9 > 1) {
                    n10 = nArray[n6 >> 2];
                    n8 = n6 & 3;
                    ++n6;
                    if (((n10 >>= 3 - n8 << 3) & 0xC0) != 128) {
                        this._reportInvalidOther(n10);
                    }
                    n7 = n7 << 6 | n10 & 0x3F;
                    if (n9 > 2) {
                        n10 = nArray[n6 >> 2];
                        n8 = n6 & 3;
                        ++n6;
                        if (((n10 >>= 3 - n8 << 3) & 0xC0) != 128) {
                            this._reportInvalidOther(n10 & 0xFF);
                        }
                        n7 = n7 << 6 | n10 & 0x3F;
                    }
                }
                if (n9 > 2) {
                    n7 -= 65536;
                    if (n5 >= cArray.length) {
                        cArray = this._textBuffer.expandCurrentSegment();
                    }
                    cArray[n5++] = (char)(55296 + (n7 >> 10));
                    n7 = 0xDC00 | n7 & 0x3FF;
                }
            }
            if (n5 >= cArray.length) {
                cArray = this._textBuffer.expandCurrentSegment();
            }
            cArray[n5++] = (char)n7;
        }
        String string = new String(cArray, 0, n5);
        if (n4 < 4) {
            nArray[n2 - 1] = n3;
        }
        return this._symbols.addName(string, nArray, n2);
    }

    private final void _handleLongFieldName() throws IOException, JsonParseException {
        Name name;
        int n;
        byte[] byArray = this._inputBuffer;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (true) {
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if (-4 == (n = byArray[this._inputPtr++])) {
                n3 = 0;
                break;
            }
            n4 = n & 0xFF;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if (-4 == (n = byArray[this._inputPtr++])) {
                n3 = 1;
                break;
            }
            n4 = n4 << 8 | n & 0xFF;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if (-4 == (n = byArray[this._inputPtr++])) {
                n3 = 2;
                break;
            }
            n4 = n4 << 8 | n & 0xFF;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if (-4 == (n = byArray[this._inputPtr++])) {
                n3 = 3;
                break;
            }
            n4 = n4 << 8 | n & 0xFF;
            if (n2 >= this._quadBuffer.length) {
                this._quadBuffer = SmileParser._growArrayTo(this._quadBuffer, this._quadBuffer.length + 256);
            }
            this._quadBuffer[n2++] = n4;
        }
        n = n2 << 2;
        if (n3 > 0) {
            if (n2 >= this._quadBuffer.length) {
                this._quadBuffer = SmileParser._growArrayTo(this._quadBuffer, this._quadBuffer.length + 256);
            }
            this._quadBuffer[n2++] = n4;
            n += n3;
        }
        String string = (name = this._symbols.findName(this._quadBuffer, n2)) != null ? name.getName() : this._decodeLongUnicodeName(this._quadBuffer, n, n2).getName();
        if (this._seenNames != null) {
            if (this._seenNameCount >= this._seenNames.length) {
                this._seenNames = this._expandSeenNames(this._seenNames);
            }
            this._seenNames[this._seenNameCount++] = string;
        }
        this._parsingContext.setCurrentName(string);
    }

    private final Name _findDecodedFromSymbols(int n) throws IOException, JsonParseException {
        if (this._inputEnd - this._inputPtr < n) {
            this._loadToHaveAtLeast(n);
        }
        if (n < 5) {
            int n2 = this._inputPtr;
            byte[] byArray = this._inputBuffer;
            int n3 = byArray[n2] & 0xFF;
            if (--n > 0) {
                n3 = (n3 << 8) + (byArray[++n2] & 0xFF);
                if (--n > 0) {
                    n3 = (n3 << 8) + (byArray[++n2] & 0xFF);
                    if (--n > 0) {
                        n3 = (n3 << 8) + (byArray[++n2] & 0xFF);
                    }
                }
            }
            this._quad1 = n3;
            return this._symbols.findName(n3);
        }
        if (n < 9) {
            int n4 = this._inputPtr;
            byte[] byArray = this._inputBuffer;
            int n5 = (byArray[n4] & 0xFF) << 8;
            n5 += byArray[++n4] & 0xFF;
            n5 <<= 8;
            n5 += byArray[++n4] & 0xFF;
            n5 <<= 8;
            n5 += byArray[++n4] & 0xFF;
            int n6 = byArray[++n4] & 0xFF;
            if ((n -= 5) > 0) {
                n6 = (n6 << 8) + (byArray[++n4] & 0xFF);
                if (--n > 0) {
                    n6 = (n6 << 8) + (byArray[++n4] & 0xFF);
                    if (--n > 0) {
                        n6 = (n6 << 8) + (byArray[++n4] & 0xFF);
                    }
                }
            }
            this._quad1 = n5;
            this._quad2 = n6;
            return this._symbols.findName(n5, n6);
        }
        return this._findDecodedMedium(n);
    }

    private final Name _findDecodedMedium(int n) throws IOException, JsonParseException {
        int n2;
        int n3 = n + 3 >> 2;
        if (n3 > this._quadBuffer.length) {
            this._quadBuffer = SmileParser._growArrayTo(this._quadBuffer, n3);
        }
        n3 = 0;
        int n4 = this._inputPtr;
        byte[] byArray = this._inputBuffer;
        do {
            n2 = (byArray[n4++] & 0xFF) << 8;
            n2 |= byArray[n4++] & 0xFF;
            n2 <<= 8;
            n2 |= byArray[n4++] & 0xFF;
            n2 <<= 8;
            this._quadBuffer[n3++] = n2 |= byArray[n4++] & 0xFF;
        } while ((n -= 4) > 3);
        if (n > 0) {
            n2 = byArray[n4] & 0xFF;
            if (--n > 0) {
                n2 = (n2 << 8) + (byArray[++n4] & 0xFF);
                if (--n > 0) {
                    n2 = (n2 << 8) + (byArray[++n4] & 0xFF);
                }
            }
            this._quadBuffer[n3++] = n2;
        }
        return this._symbols.findName(this._quadBuffer, n3);
    }

    private static int[] _growArrayTo(int[] nArray, int n) {
        int[] nArray2 = new int[n + 4];
        if (nArray != null) {
            System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        }
        return nArray2;
    }

    protected void _parseNumericValue(int n) throws IOException, JsonParseException {
        if (this._tokenIncomplete) {
            int n2 = this._typeByte;
            if ((n2 >> 5 & 7) != 1) {
                this._reportError("Current token (" + this._currToken + ") not numeric, can not use numeric value accessors");
            }
            this._tokenIncomplete = false;
            this._finishNumberToken(n2);
        }
    }

    protected void _finishToken() throws IOException, JsonParseException {
        this._tokenIncomplete = false;
        int n = this._typeByte;
        int n2 = n >> 5 & 7;
        if (n2 == 1) {
            this._finishNumberToken(n);
            return;
        }
        if (n2 <= 3) {
            this._decodeShortAsciiValue(1 + (n & 0x3F));
            return;
        }
        if (n2 <= 5) {
            this._decodeShortUnicodeValue(2 + (n & 0x3F));
            return;
        }
        if (n2 == 7) {
            switch ((n &= 0x1F) >> 2) {
                case 0: {
                    this._decodeLongAscii();
                    return;
                }
                case 1: {
                    this._decodeLongUnicode();
                    return;
                }
                case 2: {
                    this._binaryValue = this._read7BitBinaryWithLength();
                    return;
                }
                case 7: {
                    this._finishRawBinary();
                    return;
                }
            }
        }
        this._throwInternal();
    }

    protected final void _finishNumberToken(int n) throws IOException, JsonParseException {
        int n2 = (n &= 0x1F) >> 2;
        if (n2 == 1) {
            int n3 = n & 3;
            if (n3 == 0) {
                this._finishInt();
            } else if (n3 == 1) {
                this._finishLong();
            } else if (n3 == 2) {
                this._finishBigInteger();
            } else {
                this._throwInternal();
            }
            return;
        }
        if (n2 == 2) {
            switch (n & 3) {
                case 0: {
                    this._finishFloat();
                    return;
                }
                case 1: {
                    this._finishDouble();
                    return;
                }
                case 2: {
                    this._finishBigDecimal();
                    return;
                }
            }
        }
        this._throwInternal();
    }

    private final void _finishInt() throws IOException, JsonParseException {
        int n;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if ((n = this._inputBuffer[this._inputPtr++]) < 0) {
            n &= 0x3F;
        } else {
            byte by;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((by = this._inputBuffer[this._inputPtr++]) >= 0) {
                n = (n << 7) + by;
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                if ((by = this._inputBuffer[this._inputPtr++]) >= 0) {
                    n = (n << 7) + by;
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if ((by = this._inputBuffer[this._inputPtr++]) >= 0) {
                        n = (n << 7) + by;
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if ((by = this._inputBuffer[this._inputPtr++]) >= 0) {
                            this._reportError("Corrupt input; 32-bit VInt extends beyond 5 data bytes");
                        }
                    }
                }
            }
            n = (n << 6) + (by & 0x3F);
        }
        this._numberInt = SmileUtil.zigzagDecode(n);
        this._numTypesValid = 1;
    }

    private final void _finishLong() throws IOException, JsonParseException {
        long l = this._fourBytesToInt();
        while (true) {
            byte by;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((by = this._inputBuffer[this._inputPtr++]) < 0) {
                l = (l << 6) + (long)(by & 0x3F);
                this._numberLong = SmileUtil.zigzagDecode(l);
                this._numTypesValid = 2;
                return;
            }
            l = (l << 7) + (long)by;
        }
    }

    private final void _finishBigInteger() throws IOException, JsonParseException {
        byte[] byArray = this._read7BitBinaryWithLength();
        this._numberBigInt = new BigInteger(byArray);
        this._numTypesValid = 4;
    }

    private final void _finishFloat() throws IOException, JsonParseException {
        int n = this._fourBytesToInt();
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        n = (n << 7) + this._inputBuffer[this._inputPtr++];
        float f = Float.intBitsToFloat(n);
        this._numberDouble = f;
        this._numTypesValid = 8;
    }

    private final void _finishDouble() throws IOException, JsonParseException {
        long l = this._fourBytesToInt();
        long l2 = (l << 28) + (long)this._fourBytesToInt();
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        l2 = (l2 << 7) + (long)this._inputBuffer[this._inputPtr++];
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        l2 = (l2 << 7) + (long)this._inputBuffer[this._inputPtr++];
        this._numberDouble = Double.longBitsToDouble(l2);
        this._numTypesValid = 8;
    }

    private final int _fourBytesToInt() throws IOException, JsonParseException {
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        int n = this._inputBuffer[this._inputPtr++];
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        n = (n << 7) + this._inputBuffer[this._inputPtr++];
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        n = (n << 7) + this._inputBuffer[this._inputPtr++];
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        return (n << 7) + this._inputBuffer[this._inputPtr++];
    }

    private final void _finishBigDecimal() throws IOException, JsonParseException {
        int n = SmileUtil.zigzagDecode(this._readUnsignedVInt());
        byte[] byArray = this._read7BitBinaryWithLength();
        this._numberBigDecimal = new BigDecimal(new BigInteger(byArray), n);
        this._numTypesValid = 16;
    }

    private final int _readUnsignedVInt() throws IOException, JsonParseException {
        int n = 0;
        while (true) {
            byte by;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((by = this._inputBuffer[this._inputPtr++]) < 0) {
                n = (n << 6) + (by & 0x3F);
                return n;
            }
            n = (n << 7) + by;
        }
    }

    private final byte[] _read7BitBinaryWithLength() throws IOException, JsonParseException {
        int n;
        int n2;
        int n3;
        int n4 = this._readUnsignedVInt();
        byte[] byArray = new byte[n4];
        int n5 = 0;
        int n6 = n4 - 7;
        while (n5 <= n6) {
            if (this._inputEnd - this._inputPtr < 8) {
                this._loadToHaveAtLeast(8);
            }
            n3 = (this._inputBuffer[this._inputPtr++] << 25) + (this._inputBuffer[this._inputPtr++] << 18) + (this._inputBuffer[this._inputPtr++] << 11) + (this._inputBuffer[this._inputPtr++] << 4);
            n2 = this._inputBuffer[this._inputPtr++];
            n = ((n2 & 7) << 21) + (this._inputBuffer[this._inputPtr++] << 14) + (this._inputBuffer[this._inputPtr++] << 7) + this._inputBuffer[this._inputPtr++];
            byArray[n5++] = (byte)((n3 += n2 >> 3) >> 24);
            byArray[n5++] = (byte)(n3 >> 16);
            byArray[n5++] = (byte)(n3 >> 8);
            byArray[n5++] = (byte)n3;
            byArray[n5++] = (byte)(n >> 16);
            byArray[n5++] = (byte)(n >> 8);
            byArray[n5++] = (byte)n;
        }
        n3 = byArray.length - n5;
        if (n3 > 0) {
            if (this._inputEnd - this._inputPtr < n3 + 1) {
                this._loadToHaveAtLeast(n3 + 1);
            }
            n2 = this._inputBuffer[this._inputPtr++];
            for (n = 1; n < n3; ++n) {
                n2 = (n2 << 7) + this._inputBuffer[this._inputPtr++];
                byArray[n5++] = (byte)(n2 >> 7 - n);
            }
            byArray[n5] = (byte)((n2 <<= n3) + this._inputBuffer[this._inputPtr++]);
        }
        return byArray;
    }

    protected final void _decodeShortAsciiValue(int n) throws IOException, JsonParseException {
        int n2;
        if (this._inputEnd - this._inputPtr < n) {
            this._loadToHaveAtLeast(n);
        }
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        int n3 = 0;
        byte[] byArray = this._inputBuffer;
        int n4 = n2 + n;
        for (n2 = this._inputPtr; n2 < n4; ++n2) {
            cArray[n3++] = (char)byArray[n2];
        }
        this._inputPtr = n2;
        this._textBuffer.setCurrentLength(n);
    }

    protected final void _decodeShortUnicodeValue(int n) throws IOException, JsonParseException {
        if (this._inputEnd - this._inputPtr < n) {
            this._loadToHaveAtLeast(n);
        }
        int n2 = 0;
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        int n3 = this._inputPtr;
        this._inputPtr += n;
        int[] nArray = SmileConstants.sUtf8UnitLengths;
        byte[] byArray = this._inputBuffer;
        int n4 = n3 + n;
        while (n3 < n4) {
            int n5;
            int n6;
            if ((n6 = nArray[n5 = byArray[n3++] & 0xFF]) != 0) {
                switch (n6) {
                    case 1: {
                        n5 = (n5 & 0x1F) << 6 | byArray[n3++] & 0x3F;
                        break;
                    }
                    case 2: {
                        n5 = (n5 & 0xF) << 12 | (byArray[n3++] & 0x3F) << 6 | byArray[n3++] & 0x3F;
                        break;
                    }
                    case 3: {
                        n5 = (n5 & 7) << 18 | (byArray[n3++] & 0x3F) << 12 | (byArray[n3++] & 0x3F) << 6 | byArray[n3++] & 0x3F;
                        cArray[n2++] = (char)(0xD800 | (n5 -= 65536) >> 10);
                        n5 = 0xDC00 | n5 & 0x3FF;
                        break;
                    }
                    default: {
                        this._reportError("Invalid byte " + Integer.toHexString(n5) + " in short Unicode text block");
                    }
                }
            }
            cArray[n2++] = (char)n5;
        }
        this._textBuffer.setCurrentLength(n2);
    }

    private final void _decodeLongAscii() throws IOException, JsonParseException {
        int n;
        int n2 = 0;
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        block0: while (true) {
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            n = this._inputPtr;
            int n3 = this._inputEnd - n;
            if (n2 >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n2 = 0;
            }
            n3 = Math.min(n3, cArray.length - n2);
            do {
                byte by;
                if ((by = this._inputBuffer[n++]) == -4) break block0;
                cArray[n2++] = (char)by;
            } while (--n3 > 0);
            this._inputPtr = n;
        }
        this._inputPtr = n;
        this._textBuffer.setCurrentLength(n2);
    }

    private final void _decodeLongUnicode() throws IOException, JsonParseException {
        int n = 0;
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        int[] nArray = SmileConstants.sUtf8UnitLengths;
        byte[] byArray = this._inputBuffer;
        while (true) {
            int n2;
            int n3;
            block14: {
                int n4;
                int n5;
                if ((n3 = this._inputPtr) >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                    n3 = this._inputPtr;
                }
                if (n >= cArray.length) {
                    cArray = this._textBuffer.finishCurrentSegment();
                    n = 0;
                }
                if ((n5 = n3 + (cArray.length - n)) < (n4 = this._inputEnd)) {
                    n4 = n5;
                }
                while (n3 < n4) {
                    if (nArray[n2 = byArray[n3++] & 0xFF] == 0) {
                        cArray[n++] = (char)n2;
                        continue;
                    }
                    break block14;
                }
                this._inputPtr = n3;
                continue;
            }
            this._inputPtr = n3;
            if (n2 == 252) break;
            switch (nArray[n2]) {
                case 1: {
                    n2 = this._decodeUtf8_2(n2);
                    break;
                }
                case 2: {
                    if (this._inputEnd - this._inputPtr >= 2) {
                        n2 = this._decodeUtf8_3fast(n2);
                        break;
                    }
                    n2 = this._decodeUtf8_3(n2);
                    break;
                }
                case 3: {
                    n2 = this._decodeUtf8_4(n2);
                    cArray[n++] = (char)(0xD800 | n2 >> 10);
                    if (n >= cArray.length) {
                        cArray = this._textBuffer.finishCurrentSegment();
                        n = 0;
                    }
                    n2 = 0xDC00 | n2 & 0x3FF;
                    break;
                }
                default: {
                    this._reportInvalidChar(n2);
                }
            }
            if (n >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n = 0;
            }
            cArray[n++] = (char)n2;
        }
        this._textBuffer.setCurrentLength(n);
    }

    private final void _finishRawBinary() throws IOException, JsonParseException {
        int n = this._readUnsignedVInt();
        this._binaryValue = new byte[n];
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        int n2 = 0;
        while (true) {
            int n3 = Math.min(n, this._inputEnd - this._inputPtr);
            System.arraycopy(this._inputBuffer, this._inputPtr, this._binaryValue, n2, n3);
            this._inputPtr += n3;
            n2 += n3;
            if ((n -= n3) <= 0) {
                return;
            }
            this.loadMoreGuaranteed();
        }
    }

    protected void _skipIncomplete() throws IOException, JsonParseException {
        this._tokenIncomplete = false;
        int n = this._typeByte;
        switch (n >> 5 & 7) {
            case 1: {
                switch ((n &= 0x1F) >> 2) {
                    case 1: {
                        switch (n & 3) {
                            case 1: {
                                this._skipBytes(4);
                            }
                            case 0: {
                                while (true) {
                                    int n2 = this._inputEnd;
                                    byte[] byArray = this._inputBuffer;
                                    while (this._inputPtr < n2) {
                                        if (byArray[this._inputPtr++] >= 0) continue;
                                        return;
                                    }
                                    this.loadMoreGuaranteed();
                                }
                            }
                            case 2: {
                                this._skip7BitBinary();
                                return;
                            }
                        }
                        break;
                    }
                    case 2: {
                        switch (n & 3) {
                            case 0: {
                                this._skipBytes(5);
                                return;
                            }
                            case 1: {
                                this._skipBytes(10);
                                return;
                            }
                            case 2: {
                                this._readUnsignedVInt();
                                this._skip7BitBinary();
                                return;
                            }
                        }
                    }
                }
                break;
            }
            case 2: 
            case 3: {
                this._skipBytes(1 + (n & 0x3F));
                return;
            }
            case 4: 
            case 5: {
                this._skipBytes(2 + (n & 0x3F));
                return;
            }
            case 7: {
                switch ((n &= 0x1F) >> 2) {
                    case 0: 
                    case 1: {
                        while (true) {
                            int n3 = this._inputEnd;
                            byte[] byArray = this._inputBuffer;
                            while (this._inputPtr < n3) {
                                if (byArray[this._inputPtr++] != -4) continue;
                                return;
                            }
                            this.loadMoreGuaranteed();
                        }
                    }
                    case 2: {
                        this._skip7BitBinary();
                        return;
                    }
                    case 7: {
                        this._skipBytes(this._readUnsignedVInt());
                        return;
                    }
                }
            }
        }
        this._throwInternal();
    }

    protected void _skipBytes(int n) throws IOException, JsonParseException {
        while (true) {
            int n2 = Math.min(n, this._inputEnd - this._inputPtr);
            this._inputPtr += n2;
            if ((n -= n2) <= 0) {
                return;
            }
            this.loadMoreGuaranteed();
        }
    }

    protected void _skip7BitBinary() throws IOException, JsonParseException {
        int n = this._readUnsignedVInt();
        int n2 = n / 7;
        int n3 = n2 * 8;
        if ((n -= 7 * n2) > 0) {
            n3 += 1 + n;
        }
        this._skipBytes(n3);
    }

    private final int _decodeUtf8_2(int n) throws IOException, JsonParseException {
        byte by;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((by = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by & 0xFF, this._inputPtr);
        }
        return (n & 0x1F) << 6 | by & 0x3F;
    }

    private final int _decodeUtf8_3(int n) throws IOException, JsonParseException {
        byte by;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        n &= 0xF;
        if (((by = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by & 0xFF, this._inputPtr);
        }
        int n2 = n << 6 | by & 0x3F;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((by = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by & 0xFF, this._inputPtr);
        }
        n2 = n2 << 6 | by & 0x3F;
        return n2;
    }

    private final int _decodeUtf8_3fast(int n) throws IOException, JsonParseException {
        byte by;
        n &= 0xF;
        if (((by = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by & 0xFF, this._inputPtr);
        }
        int n2 = n << 6 | by & 0x3F;
        if (((by = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by & 0xFF, this._inputPtr);
        }
        n2 = n2 << 6 | by & 0x3F;
        return n2;
    }

    private final int _decodeUtf8_4(int n) throws IOException, JsonParseException {
        byte by;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((by = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by & 0xFF, this._inputPtr);
        }
        n = (n & 7) << 6 | by & 0x3F;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((by = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by & 0xFF, this._inputPtr);
        }
        n = n << 6 | by & 0x3F;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((by = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by & 0xFF, this._inputPtr);
        }
        return (n << 6 | by & 0x3F) - 65536;
    }

    protected void _reportInvalidSharedName(int n) throws IOException {
        if (this._seenNames == null) {
            this._reportError("Encountered shared name reference, even though document header explicitly declared no shared name references are included");
        }
        this._reportError("Invalid shared name reference " + n + "; only got " + this._seenNameCount + " names in buffer (invalid content)");
    }

    protected void _reportInvalidSharedStringValue(int n) throws IOException {
        if (this._seenStringValues == null) {
            this._reportError("Encountered shared text value reference, even though document header did not declared shared text value references may be included");
        }
        this._reportError("Invalid shared text value reference " + n + "; only got " + this._seenStringValueCount + " names in buffer (invalid content)");
    }

    protected void _reportInvalidChar(int n) throws JsonParseException {
        if (n < 32) {
            this._throwInvalidSpace(n);
        }
        this._reportInvalidInitial(n);
    }

    protected void _reportInvalidInitial(int n) throws JsonParseException {
        this._reportError("Invalid UTF-8 start byte 0x" + Integer.toHexString(n));
    }

    protected void _reportInvalidOther(int n) throws JsonParseException {
        this._reportError("Invalid UTF-8 middle byte 0x" + Integer.toHexString(n));
    }

    protected void _reportInvalidOther(int n, int n2) throws JsonParseException {
        this._inputPtr = n2;
        this._reportInvalidOther(n);
    }

    public static enum Feature {
        REQUIRE_HEADER(true);

        final boolean _defaultState;
        final int _mask;

        public static int collectDefaults() {
            int n = 0;
            for (Feature feature : Feature.values()) {
                if (!feature.enabledByDefault()) continue;
                n |= feature.getMask();
            }
            return n;
        }

        private Feature(boolean bl) {
            this._defaultState = bl;
            this._mask = 1 << this.ordinal();
        }

        public boolean enabledByDefault() {
            return this._defaultState;
        }

        public int getMask() {
            return this._mask;
        }
    }
}

