/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.util;

import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.type.ClassType;
import com.sun.mirror.type.DeclaredType;
import com.sun.mirror.type.InterfaceType;
import com.sun.mirror.type.TypeMirror;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import net.sf.jelly.apt.Context;
import org.codehaus.enunciate.contract.jaxb.adapters.AdapterType;
import org.codehaus.enunciate.contract.jaxb.adapters.AdapterUtil;
import org.codehaus.enunciate.util.MapType;

public class MapTypeUtil {
    private static ThreadLocal<LinkedList<String>> TYPE_STACK = new ThreadLocal<LinkedList<String>>(){

        @Override
        protected LinkedList<String> initialValue() {
            return new LinkedList<String>();
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MapType findMapType(TypeMirror typeMirror) {
        if (!(typeMirror instanceof DeclaredType)) {
            return null;
        }
        if (typeMirror instanceof MapType) {
            return (MapType)typeMirror;
        }
        DeclaredType declaredType = (DeclaredType)typeMirror;
        TypeDeclaration declaration = declaredType.getDeclaration();
        if (declaration == null) {
            return null;
        }
        if ("java.util.Map".equals(declaration.getQualifiedName())) {
            TypeMirror keyType = null;
            TypeMirror valueType = null;
            Collection typeArgs = declaredType.getActualTypeArguments();
            if (typeArgs != null && typeArgs.size() == 2) {
                Iterator argIt = typeArgs.iterator();
                keyType = (TypeMirror)argIt.next();
                valueType = (TypeMirror)argIt.next();
            }
            if (keyType == null || valueType == null) {
                AnnotationProcessorEnvironment env = Context.getCurrentEnvironment();
                DeclaredType objectType = env.getTypeUtils().getDeclaredType(env.getTypeDeclaration(Object.class.getName()), new TypeMirror[0]);
                keyType = objectType;
                valueType = objectType;
            }
            return new MapType((InterfaceType)declaredType, keyType, valueType);
        }
        if (TYPE_STACK.get().contains(declaration.getQualifiedName())) {
            return null;
        }
        TYPE_STACK.get().push(declaration.getQualifiedName());
        try {
            InterfaceType superInterface;
            AdapterType adapterType = AdapterUtil.findAdapterType((Declaration)declaration);
            if (adapterType != null) {
                MapType valueType = MapTypeUtil.findMapType(adapterType.getAdaptingType());
                return valueType;
            }
            MapType mapType = null;
            Collection superInterfaces = declaredType.getSuperinterfaces();
            Iterator i$ = superInterfaces.iterator();
            while (i$.hasNext() && (mapType = MapTypeUtil.findMapType((TypeMirror)(superInterface = (InterfaceType)i$.next()))) == null) {
            }
            if (mapType == null && declaredType instanceof ClassType) {
                mapType = MapTypeUtil.findMapType((TypeMirror)((ClassType)declaredType).getSuperclass());
            }
            if (mapType != null) {
                mapType.setOriginalType(declaredType);
            }
            MapType mapType2 = mapType;
            return mapType2;
        }
        finally {
            TYPE_STACK.get().pop();
        }
    }
}

