/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import org.codehaus.enunciate.asm.ClassReader;
import org.codehaus.enunciate.asm.Type;
import org.codehaus.enunciate.asm.tree.AnnotationNode;
import org.codehaus.enunciate.asm.tree.ClassNode;

public class JaxbPackageInfoWriter {
    public String write(InputStream bytecode) throws IOException {
        ClassReader cr = new ClassReader(bytecode);
        ClassNode cn = new ClassNode();
        cr.accept(cn, 0);
        if (cn.visibleAnnotations != null && !cn.visibleAnnotations.isEmpty()) {
            StringWriter writer = new StringWriter();
            boolean jaxbFound = false;
            for (Object visibleAnnotation : cn.visibleAnnotations) {
                AnnotationNode annotation = (AnnotationNode)visibleAnnotation;
                if (!Type.getType(annotation.desc).getClassName().startsWith("javax.xml.bind")) continue;
                this.writeAnnotationNode(annotation, writer);
                writer.write(10);
                jaxbFound = true;
            }
            if (jaxbFound) {
                writer.write("package ");
                String classname = Type.getObjectType(cn.name).getClassName();
                writer.write(classname.substring(0, classname.length() - ".package-info".length()));
                writer.write(59);
                writer.flush();
                return writer.toString();
            }
        }
        return null;
    }

    protected void writeAnnotationNode(AnnotationNode annotation, Writer writer) throws IOException {
        writer.write(64);
        writer.write(Type.getType(annotation.desc).getClassName());
        writer.write(40);
        if (annotation.values != null) {
            boolean first = true;
            Iterator valuesIt = annotation.values.iterator();
            while (valuesIt.hasNext()) {
                if (!first) {
                    writer.write(44);
                }
                writer.write((String)valuesIt.next());
                Object value = valuesIt.next();
                writer.write(61);
                this.writeAnnotationValue(value, writer);
                first = false;
            }
        }
        writer.write(41);
    }

    protected void writeAnnotationValue(Object value, Writer writer) throws IOException {
        if (value instanceof Character) {
            writer.write(39);
            writer.write(value.toString());
            writer.write(39);
        } else if (value instanceof String) {
            writer.write(34);
            writer.write(value.toString());
            writer.write(34);
        } else if (value instanceof Type) {
            writer.write(((Type)value).getClassName());
            writer.write(".class");
        } else if (value instanceof String[]) {
            String[] enumValue = (String[])value;
            writer.write(Type.getType(enumValue[0]).getClassName());
            writer.write(46);
            writer.write(enumValue[1]);
        } else if (value instanceof AnnotationNode) {
            this.writeAnnotationNode((AnnotationNode)value, writer);
        } else if (value instanceof List) {
            List valueList = (List)value;
            writer.write(123);
            boolean first = true;
            for (Object valueItem : valueList) {
                if (!first) {
                    writer.write(44);
                }
                this.writeAnnotationValue(valueItem, writer);
                first = false;
            }
            writer.write(125);
        } else {
            writer.write(value.toString());
        }
    }
}

