/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.template.strategies.rest;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import net.sf.jelly.apt.TemplateException;
import net.sf.jelly.apt.TemplateModel;
import org.codehaus.enunciate.contract.jaxrs.ResourceMethod;
import org.codehaus.enunciate.contract.jaxrs.RootResource;
import org.codehaus.enunciate.doc.ExcludeFromDocumentation;
import org.codehaus.enunciate.template.strategies.EnunciateTemplateLoopStrategy;
import org.codehaus.enunciate.util.ResourceMethodPathComparator;

public class ResourceMethodsByPathLoopStrategy
extends EnunciateTemplateLoopStrategy<List<ResourceMethod>> {
    private String var = "resources";
    private boolean includeExcludedFromDocs = false;
    private boolean includeExcludedFromIDL = false;

    protected Iterator<List<ResourceMethod>> getLoop(TemplateModel model) throws TemplateException {
        TreeMap<String, ArrayList<ResourceMethod>> resourcesByPath = new TreeMap<String, ArrayList<ResourceMethod>>(new ResourceMethodPathComparator());
        for (RootResource rootResource : this.getModel().getRootResources()) {
            for (ResourceMethod resource : rootResource.getResourceMethods(true)) {
                ExcludeFromDocumentation excludeFromDocs = (ExcludeFromDocumentation)resource.getAnnotation(ExcludeFromDocumentation.class);
                if (excludeFromDocs != null && !this.includeExcludedFromDocs || excludeFromDocs != null && excludeFromDocs.excludeFromIDL() && !this.includeExcludedFromIDL) continue;
                String path = resource.getFullpath();
                ArrayList<ResourceMethod> resourceList = (ArrayList<ResourceMethod>)resourcesByPath.get(path);
                if (resourceList == null) {
                    resourceList = new ArrayList<ResourceMethod>();
                    resourcesByPath.put(path, resourceList);
                }
                resourceList.add(resource);
            }
        }
        return resourcesByPath.values().iterator();
    }

    protected void setupModelForLoop(TemplateModel model, List<ResourceMethod> resources, int index) throws TemplateException {
        super.setupModelForLoop(model, resources, index);
        if (this.var != null) {
            this.getModel().setVariable(this.var, resources);
        }
    }

    public String getVar() {
        return this.var;
    }

    public void setVar(String var) {
        this.var = var;
    }

    public boolean isIncludeExcludedFromDocs() {
        return this.includeExcludedFromDocs;
    }

    public void setIncludeExcludedFromDocs(boolean includeExcludedFromDocs) {
        this.includeExcludedFromDocs = includeExcludedFromDocs;
    }

    public boolean isIncludeExcludedFromIDL() {
        return this.includeExcludedFromIDL;
    }

    public void setIncludeExcludedFromIDL(boolean includeExcludedFromIDL) {
        this.includeExcludedFromIDL = includeExcludedFromIDL;
    }
}

