/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.template.strategies.jaxws;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import net.sf.jelly.apt.TemplateException;
import net.sf.jelly.apt.TemplateModel;
import net.sf.jelly.apt.strategies.MissingParameterException;
import org.codehaus.enunciate.config.WsdlInfo;
import org.codehaus.enunciate.contract.jaxws.EndpointInterface;
import org.codehaus.enunciate.contract.jaxws.WebFault;
import org.codehaus.enunciate.contract.jaxws.WebMessage;
import org.codehaus.enunciate.contract.jaxws.WebMethod;
import org.codehaus.enunciate.template.strategies.EnunciateTemplateLoopStrategy;

public class WebMessageLoopStrategy
extends EnunciateTemplateLoopStrategy<WebMessage> {
    private String var = "webMessage";
    private boolean includeInput = true;
    private boolean includeOutput = true;
    private boolean includeHeaders = true;
    private boolean includeFaults = true;
    private WebMethod webMethod;
    private WsdlInfo wsdl;

    protected Iterator<WebMessage> getLoop(TemplateModel model) throws TemplateException {
        Collection<WebMessage> messages;
        WebMethod webMethod = this.webMethod;
        WsdlInfo wsdlInfo = this.wsdl;
        if (webMethod == null && wsdlInfo == null) {
            throw new MissingParameterException("Either a webMethod or a wsdl must be specified to iterate over web messages.", "webMethod");
        }
        if (webMethod != null) {
            messages = webMethod.getMessages();
        } else {
            messages = new ArrayList<WebMessage>();
            HashSet<String> foundFaults = new HashSet<String>();
            for (EndpointInterface ei : wsdlInfo.getEndpointInterfaces()) {
                Collection<WebMethod> webMethods = ei.getWebMethods();
                for (WebMethod method : webMethods) {
                    for (WebMessage webMessage : method.getMessages()) {
                        if (webMessage.isFault() && !foundFaults.add(((WebFault)webMessage).getQualifiedName())) continue;
                        messages.add(webMessage);
                    }
                }
            }
        }
        ArrayList<WebMessage> io = new ArrayList<WebMessage>();
        for (WebMessage message : messages) {
            boolean include = this.includeHeaders || !message.isHeader();
            include &= this.includeOutput || !message.isOutput();
            include &= this.includeInput || !message.isInput();
            if (!(include &= this.includeFaults || !message.isFault())) continue;
            io.add(message);
        }
        return io.iterator();
    }

    protected void setupModelForLoop(TemplateModel model, WebMessage webMessage, int index) throws TemplateException {
        super.setupModelForLoop(model, (Object)webMessage, index);
        if (this.var != null) {
            model.setVariable(this.var, (Object)webMessage);
        }
    }

    public String getVar() {
        return this.var;
    }

    public void setVar(String var) {
        this.var = var;
    }

    public boolean isIncludeInput() {
        return this.includeInput;
    }

    public void setIncludeInput(boolean includeInput) {
        this.includeInput = includeInput;
    }

    public boolean isIncludeOutput() {
        return this.includeOutput;
    }

    public void setIncludeOutput(boolean includeOutput) {
        this.includeOutput = includeOutput;
    }

    public boolean isIncludeHeaders() {
        return this.includeHeaders;
    }

    public void setIncludeHeaders(boolean includeHeaders) {
        this.includeHeaders = includeHeaders;
    }

    public boolean isIncludeFaults() {
        return this.includeFaults;
    }

    public void setIncludeFaults(boolean includeFaults) {
        this.includeFaults = includeFaults;
    }

    public WebMethod getWebMethod() {
        return this.webMethod;
    }

    public void setWebMethod(WebMethod webMethod) {
        this.webMethod = webMethod;
    }

    public WsdlInfo getWsdl() {
        return this.wsdl;
    }

    public void setWsdl(WsdlInfo wsdl) {
        this.wsdl = wsdl;
    }
}

