/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.template.strategies;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import net.sf.jelly.apt.TemplateException;
import net.sf.jelly.apt.TemplateModel;
import org.codehaus.enunciate.config.WsdlInfo;
import org.codehaus.enunciate.contract.ServiceEndpoint;
import org.codehaus.enunciate.contract.jaxws.EndpointImplementation;
import org.codehaus.enunciate.contract.jaxws.EndpointInterface;
import org.codehaus.enunciate.template.strategies.EnunciateTemplateLoopStrategy;

public class ServiceEndpointLoopStrategy
extends EnunciateTemplateLoopStrategy<ServiceEndpoint> {
    private String var = "endpoint";

    protected Iterator<ServiceEndpoint> getLoop(TemplateModel model) throws TemplateException {
        TreeSet<ServiceEndpoint> interfaces = new TreeSet<ServiceEndpoint>(new Comparator<ServiceEndpoint>(){

            @Override
            public int compare(ServiceEndpoint e1, ServiceEndpoint e2) {
                return e1.getServiceEndpointId().compareTo(e2.getServiceEndpointId());
            }
        });
        Collection<WsdlInfo> wsdls = this.getNamespacesToWSDLs().values();
        for (WsdlInfo wsdl : wsdls) {
            for (EndpointInterface endpointInterface : wsdl.getEndpointInterfaces()) {
                for (EndpointImplementation impl : endpointInterface.getEndpointImplementations()) {
                    interfaces.add(impl);
                }
            }
        }
        return interfaces.iterator();
    }

    protected void setupModelForLoop(TemplateModel model, ServiceEndpoint endpoint, int index) throws TemplateException {
        super.setupModelForLoop(model, (Object)endpoint, index);
        if (this.var != null) {
            this.getModel().setVariable(this.var, endpoint);
        }
    }

    public String getVar() {
        return this.var;
    }

    public void setVar(String var) {
        this.var = var;
    }
}

