/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.template.strategies;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import net.sf.jelly.apt.strategies.FileStrategy;
import net.sf.jelly.apt.strategies.MissingParameterException;

public class EnunciateFileStrategy
extends FileStrategy {
    private final File outputDirectory;

    public EnunciateFileStrategy(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public PrintWriter getWriter() throws IOException, MissingParameterException {
        File dir = this.outputDirectory;
        if (dir == null) {
            return super.getWriter();
        }
        String pckg = this.getPackage();
        if (pckg != null && pckg.trim().length() > 0) {
            String[] dirnames;
            for (String dirname : dirnames = pckg.split("\\.")) {
                dir = new File(dir, dirname);
            }
        }
        dir.mkdirs();
        String charset = this.getCharset();
        if (charset != null) {
            return new PrintWriter(new File(dir, this.getName()), charset);
        }
        return new PrintWriter(new File(dir, this.getName()));
    }
}

