/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.template.freemarker;

import freemarker.ext.beans.BeansWrapper;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jelly.apt.freemarker.FreemarkerModel;
import org.codehaus.enunciate.apt.EnunciateFreemarkerModel;
import org.codehaus.enunciate.contract.jaxrs.ResourceMethod;
import org.codehaus.enunciate.contract.jaxrs.ResourceMethodMediaType;
import org.codehaus.enunciate.rest.MimeType;

public class UniqueContentTypesMethod
implements TemplateMethodModelEx {
    public Object exec(List list) throws TemplateModelException {
        List<ResourceMethod> resourceList;
        if (list.size() < 1) {
            throw new TemplateModelException("The uniqueContentTypes method must have a list of methods as a parameter.");
        }
        Object object = BeansWrapper.getDefaultInstance().unwrap((TemplateModel)list.get(0));
        if (object instanceof Collection) {
            resourceList = (List<ResourceMethod>)object;
        } else if (object instanceof ResourceMethod) {
            resourceList = Arrays.asList((ResourceMethod)((Object)object));
        } else {
            throw new TemplateModelException("The uniqueContentTypes method take a list of REST resources.  Not " + object.getClass().getName());
        }
        LinkedHashMap<String, ResourceMethodMediaType> supported = new LinkedHashMap<String, ResourceMethodMediaType>();
        for (ResourceMethod resource : resourceList) {
            for (ResourceMethodMediaType mediaType : resource.getApplicableMediaTypes()) {
                for (String applicableType : this.findAllKnownTypesAcceptableTo(mediaType)) {
                    Map subcontextMap;
                    ResourceMethodMediaType type = (ResourceMethodMediaType)supported.get(applicableType);
                    if (type == null) {
                        type = new ResourceMethodMediaType();
                        type.setType(applicableType);
                        supported.put(applicableType, type);
                    }
                    type.setProduceable(type.isProduceable() || mediaType.isProduceable());
                    type.setConsumable(type.isConsumable() || mediaType.isConsumable());
                    if (!mediaType.isProduceable() || (subcontextMap = (Map)resource.getMetaData().get("subcontexts")) == null) continue;
                    type.setSubcontexts((Set)subcontextMap.get(applicableType));
                }
            }
        }
        return supported.values();
    }

    protected List<String> findAllKnownTypesAcceptableTo(ResourceMethodMediaType mediaType) {
        Set<String> allKnownContentTypes = ((EnunciateFreemarkerModel)FreemarkerModel.get()).getContentTypesToIds().keySet();
        String typeValue = mediaType.getType();
        ArrayList<String> typeSet = new ArrayList<String>();
        typeSet.add(typeValue);
        try {
            MimeType mimeType = MimeType.parse((String)typeValue);
            for (String knownType : allKnownContentTypes) {
                try {
                    MimeType knownMimeType = MimeType.parse((String)knownType);
                    if (!mimeType.isAcceptable(knownMimeType)) continue;
                    typeSet.add(knownType);
                }
                catch (Exception e) {}
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return typeSet;
    }
}

