/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.template.freemarker;

import com.sun.mirror.declaration.PackageDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import freemarker.ext.beans.BeansWrapper;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import net.sf.jelly.apt.decorations.JavaDoc;
import net.sf.jelly.apt.freemarker.FreemarkerModel;
import org.codehaus.enunciate.apt.EnunciateFreemarkerModel;
import org.codehaus.enunciate.config.SchemaInfo;
import org.codehaus.enunciate.config.WsdlInfo;
import org.codehaus.enunciate.contract.jaxb.RootElementDeclaration;
import org.codehaus.enunciate.contract.jaxb.TypeDefinition;
import org.codehaus.enunciate.contract.jaxrs.ResourceMethod;
import org.codehaus.enunciate.contract.jaxrs.RootResource;
import org.codehaus.enunciate.contract.jaxws.EndpointInterface;
import org.codehaus.enunciate.contract.json.JsonSchemaInfo;
import org.codehaus.enunciate.contract.json.JsonTypeDefinition;
import org.codehaus.enunciate.doc.DocumentationGroup;
import org.codehaus.enunciate.util.Group;

public class GetGroupsMethod
implements TemplateMethodModelEx {
    public Object exec(List list) throws TemplateModelException {
        if (list.size() < 1) {
            throw new TemplateModelException("The getGroups method must have a parameter.");
        }
        TemplateModel from = (TemplateModel)list.get(0);
        Object unwrapped = BeansWrapper.getDefaultInstance().unwrap(from);
        TreeSet<Group> groups = new TreeSet<Group>();
        if (SchemaInfo.class.isInstance(unwrapped)) {
            SchemaInfo info = (SchemaInfo)unwrapped;
            for (TypeDefinition typeDef : info.getTypeDefinitions()) {
                this.gatherGroups((TypeDeclaration)typeDef, groups);
            }
            for (RootElementDeclaration element : info.getGlobalElements()) {
                this.gatherGroups((TypeDeclaration)element, groups);
            }
        } else if (JsonSchemaInfo.class.isInstance(unwrapped)) {
            JsonSchemaInfo schema = (JsonSchemaInfo)unwrapped;
            for (JsonTypeDefinition jsonTypeDefinition : schema.getTypes()) {
                this.gatherGroups((TypeDeclaration)jsonTypeDefinition, groups);
            }
        } else if (WsdlInfo.class.isInstance(unwrapped)) {
            WsdlInfo wsdl = (WsdlInfo)unwrapped;
            for (EndpointInterface ei : wsdl.getEndpointInterfaces()) {
                this.gatherGroups((TypeDeclaration)ei, groups);
            }
        } else if ("rest".equals(unwrapped)) {
            for (RootResource rootResource : GetGroupsMethod.getModel().getRootResources()) {
                for (ResourceMethod resourceMethod : rootResource.getResourceMethods(true)) {
                    this.gatherGroups(resourceMethod, groups);
                }
            }
        } else if (Collection.class.isInstance(unwrapped)) {
            Collection resources = (Collection)unwrapped;
            for (ResourceMethod resource : resources) {
                this.gatherGroups(resource, groups);
            }
        } else if (TypeDeclaration.class.isInstance(unwrapped)) {
            this.gatherGroups((TypeDeclaration)unwrapped, groups);
        } else {
            throw new TemplateModelException("Don't know how to gather groups for: " + unwrapped + ".");
        }
        return groups;
    }

    private void gatherGroups(ResourceMethod decl, Set<Group> groups) {
        if (decl != null) {
            DocumentationGroup documentationGroup = (DocumentationGroup)decl.getAnnotation(DocumentationGroup.class);
            if (documentationGroup != null) {
                for (String name : documentationGroup.value()) {
                    groups.add(new Group(name, new JavaDoc(null)));
                }
            } else {
                this.gatherGroups((TypeDeclaration)decl.getParent(), groups);
            }
        }
    }

    private void gatherGroups(TypeDeclaration decl, Set<Group> groups) {
        if (decl != null) {
            DocumentationGroup documentationGroup = (DocumentationGroup)decl.getAnnotation(DocumentationGroup.class);
            if (documentationGroup != null) {
                for (String name : documentationGroup.value()) {
                    groups.add(new Group(name, new JavaDoc(decl.getDocComment())));
                }
            } else {
                PackageDeclaration pkg = decl.getPackage();
                if (pkg != null) {
                    documentationGroup = (DocumentationGroup)pkg.getAnnotation(DocumentationGroup.class);
                    if (documentationGroup != null) {
                        for (String name : documentationGroup.value()) {
                            groups.add(new Group(name, new JavaDoc(pkg.getDocComment())));
                        }
                    } else {
                        groups.add(new Group(decl.getSimpleName(), new JavaDoc(decl.getDocComment())));
                    }
                }
            }
        }
    }

    protected static EnunciateFreemarkerModel getModel() {
        return (EnunciateFreemarkerModel)FreemarkerModel.get();
    }
}

