/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.template.freemarker;

import com.sun.mirror.declaration.PackageDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.declaration.TypeParameterDeclaration;
import com.sun.mirror.type.ArrayType;
import com.sun.mirror.type.DeclaredType;
import com.sun.mirror.type.TypeMirror;
import com.sun.mirror.type.TypeVariable;
import freemarker.ext.beans.BeansWrapper;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.codehaus.enunciate.ClientName;

public class ClientPackageForMethod
implements TemplateMethodModelEx {
    private final TreeMap<String, String> conversions = new TreeMap(new Comparator<String>(){

        @Override
        public int compare(String package1, String package2) {
            return package2.length() == package1.length() ? package1.compareTo(package2) : package2.length() - package1.length();
        }
    });
    private boolean useClientNameConversions = false;

    public ClientPackageForMethod(Map<String, String> conversions) {
        if (conversions != null) {
            this.conversions.putAll(conversions);
        }
    }

    public Object exec(List list) throws TemplateModelException {
        if (list.size() < 1) {
            throw new TemplateModelException("The convertPackage method must have the class or package as a parameter.");
        }
        Object unwrapped = this.unwrap(list.get(0));
        return this.convertUnwrappedObject(unwrapped);
    }

    protected Object unwrap(Object first) throws TemplateModelException {
        return BeansWrapper.getDefaultInstance().unwrap((TemplateModel)first);
    }

    public String convertUnwrappedObject(Object unwrapped) throws TemplateModelException {
        String conversion = unwrapped instanceof TypeMirror ? this.convert((TypeMirror)unwrapped) : (unwrapped instanceof TypeDeclaration ? this.convert((TypeDeclaration)unwrapped) : (unwrapped instanceof PackageDeclaration ? this.convert((PackageDeclaration)unwrapped) : this.convert(String.valueOf(unwrapped))));
        return conversion;
    }

    public String convert(TypeMirror typeMirror) throws TemplateModelException {
        String conversion;
        if (typeMirror instanceof DeclaredType) {
            conversion = this.convert(((DeclaredType)typeMirror).getDeclaration());
        } else if (typeMirror instanceof ArrayType) {
            conversion = this.convert(((ArrayType)typeMirror).getComponentType());
        } else if (typeMirror instanceof TypeVariable) {
            conversion = "Object";
            TypeParameterDeclaration parameterDeclaration = ((TypeVariable)typeMirror).getDeclaration();
            if (parameterDeclaration != null && parameterDeclaration.getBounds() != null && parameterDeclaration.getBounds().size() > 0) {
                conversion = this.convert((TypeMirror)parameterDeclaration.getBounds().iterator().next());
            }
        } else {
            conversion = String.valueOf(typeMirror);
        }
        return conversion;
    }

    public String convert(TypeDeclaration declaration) throws TemplateModelException {
        return this.convert(declaration.getPackage());
    }

    public String convert(PackageDeclaration packageDeclaration) {
        if (packageDeclaration == null) {
            return "";
        }
        ClientName specifiedName = this.isUseClientNameConversions() ? (ClientName)packageDeclaration.getAnnotation(ClientName.class) : null;
        return specifiedName == null ? this.convert(packageDeclaration.getQualifiedName()) : specifiedName.value();
    }

    public String convert(String fqn) {
        if (this.conversions.containsKey(fqn)) {
            return this.conversions.get(fqn);
        }
        for (String pkg : this.conversions.keySet()) {
            if (!fqn.startsWith(pkg)) continue;
            String conversion = this.conversions.get(pkg);
            return conversion + fqn.substring(pkg.length());
        }
        return fqn;
    }

    public boolean isUseClientNameConversions() {
        return this.useClientNameConversions;
    }

    public void setUseClientNameConversions(boolean useClientNameConversions) {
        this.useClientNameConversions = useClientNameConversions;
    }
}

