/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.template.freemarker;

import com.sun.mirror.declaration.PackageDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.declaration.TypeParameterDeclaration;
import com.sun.mirror.type.ArrayType;
import com.sun.mirror.type.DeclaredType;
import com.sun.mirror.type.TypeMirror;
import com.sun.mirror.type.TypeVariable;
import com.sun.mirror.type.WildcardType;
import freemarker.ext.beans.BeansWrapper;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.codehaus.enunciate.contract.jaxb.Accessor;
import org.codehaus.enunciate.contract.jaxb.ImplicitChildElement;
import org.codehaus.enunciate.template.freemarker.ClientPackageForMethod;

public class ClassnameForMethod
extends ClientPackageForMethod {
    private static final ThreadLocal<Boolean> FORCE_NOT_15 = new ThreadLocal();
    private final LinkedList<String> typeParameterDeclarationStack = new LinkedList();
    private boolean jdk15 = false;

    public ClassnameForMethod(Map<String, String> conversions) {
        super(conversions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object exec(List list) throws TemplateModelException {
        FORCE_NOT_15.set(list.size() > 1 && Boolean.TRUE.equals(BeansWrapper.getDefaultInstance().unwrap((TemplateModel)list.get(1))));
        try {
            Object object = super.exec(list);
            return object;
        }
        finally {
            FORCE_NOT_15.remove();
        }
    }

    @Override
    public String convertUnwrappedObject(Object unwrapped) throws TemplateModelException {
        if (unwrapped instanceof Accessor) {
            return this.convert((Accessor)unwrapped);
        }
        if (unwrapped instanceof ImplicitChildElement) {
            return this.convert((ImplicitChildElement)unwrapped);
        }
        if (unwrapped instanceof TypeParameterDeclaration) {
            return this.convert((TypeParameterDeclaration)unwrapped);
        }
        return super.convertUnwrappedObject(unwrapped);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String convert(TypeParameterDeclaration typeParameterDeclaration) throws TemplateModelException {
        String conversion = typeParameterDeclaration.getSimpleName();
        if (typeParameterDeclaration.getBounds() != null && !typeParameterDeclaration.getBounds().isEmpty() && !this.typeParameterDeclarationStack.contains(conversion)) {
            this.typeParameterDeclarationStack.addFirst(conversion);
            try {
                conversion = conversion + " extends " + this.convert((TypeMirror)typeParameterDeclaration.getBounds().iterator().next());
            }
            finally {
                this.typeParameterDeclarationStack.removeFirst();
            }
        }
        return conversion;
    }

    public String convert(ImplicitChildElement childElement) throws TemplateModelException {
        TypeMirror elementType = childElement.getType();
        return this.convert(elementType);
    }

    public String convert(Accessor accessor) throws TemplateModelException {
        TypeMirror accessorType = accessor.getAccessorType();
        return this.convert(accessorType);
    }

    @Override
    public String convert(TypeMirror typeMirror) throws TemplateModelException {
        String conversion;
        if (typeMirror instanceof WildcardType) {
            WildcardType wildCard = (WildcardType)typeMirror;
            conversion = wildCard.getLowerBounds() != null && !wildCard.getLowerBounds().isEmpty() ? "? super " + this.convert((TypeMirror)wildCard.getLowerBounds().iterator().next()) : (wildCard.getUpperBounds() != null && !wildCard.getUpperBounds().isEmpty() ? "? extends " + this.convert((TypeMirror)wildCard.getUpperBounds().iterator().next()) : "?");
        } else if (typeMirror instanceof TypeVariable) {
            TypeParameterDeclaration declaration = ((TypeVariable)typeMirror).getDeclaration();
            conversion = declaration != null && this.isJdk15() ? declaration.getSimpleName() : (declaration != null && declaration.getBounds() != null && !declaration.getBounds().isEmpty() ? this.convert((TypeMirror)declaration.getBounds().iterator().next()) : this.convert(Object.class.getName()));
        } else {
            DeclaredType declaredType;
            Collection actualTypeArguments;
            conversion = super.convert(typeMirror);
            boolean isArray = typeMirror instanceof ArrayType;
            if (this.isJdk15() && typeMirror instanceof DeclaredType && (actualTypeArguments = (declaredType = (DeclaredType)typeMirror).getActualTypeArguments()).size() > 0) {
                StringBuilder typeArgs = new StringBuilder("<");
                Iterator it = actualTypeArguments.iterator();
                while (it.hasNext()) {
                    TypeMirror mirror = (TypeMirror)it.next();
                    typeArgs.append(this.convert(mirror));
                    if (!it.hasNext()) continue;
                    typeArgs.append(", ");
                }
                typeArgs.append(">");
                conversion = conversion + typeArgs;
            }
            if (isArray) {
                conversion = conversion + "[]";
            }
        }
        return conversion;
    }

    @Override
    public String convert(TypeDeclaration declaration) throws TemplateModelException {
        PackageDeclaration pkg = declaration.getPackage();
        String convertedPackage = this.convertPackage(pkg);
        String simpleName = declaration.getSimpleName();
        return convertedPackage + this.getPackageSeparator() + simpleName;
    }

    protected String convertPackage(PackageDeclaration pkg) {
        return super.convert(pkg);
    }

    protected String getPackageSeparator() {
        return ".";
    }

    @Override
    public String convert(PackageDeclaration packageDeclaration) {
        throw new UnsupportedOperationException("packages don't have a classname.");
    }

    public boolean isJdk15() {
        return this.jdk15 && (FORCE_NOT_15.get() == null || FORCE_NOT_15.get() == false);
    }

    public void setJdk15(boolean jdk15) {
        this.jdk15 = jdk15;
    }
}

