/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.modules;

import freemarker.cache.TemplateLoader;
import freemarker.cache.URLTemplateLoader;
import freemarker.core.Environment;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import org.codehaus.enunciate.EnunciateException;
import org.codehaus.enunciate.apt.EnunciateFreemarkerModel;
import org.codehaus.enunciate.apt.EnunciateModelAware;
import org.codehaus.enunciate.modules.BasicDeploymentModule;

public abstract class FreemarkerDeploymentModule
extends BasicDeploymentModule
implements EnunciateModelAware {
    private EnunciateFreemarkerModel model = null;

    @Override
    protected final void doGenerate() throws EnunciateException, IOException {
        try {
            this.doFreemarkerGenerate();
        }
        catch (TemplateException e) {
            throw new EnunciateException(e);
        }
    }

    public abstract void doFreemarkerGenerate() throws EnunciateException, IOException, TemplateException;

    public void processTemplate(URL templateURL, Object model) throws IOException, TemplateException {
        this.processTemplate(templateURL, model, System.out);
    }

    public void processTemplate(URL templateURL, Object model, PrintStream out) throws IOException, TemplateException {
        this.debug("Processing template %s.", templateURL);
        Configuration configuration = this.getConfiguration();
        configuration.setDefaultEncoding("UTF-8");
        Template template = configuration.getTemplate(templateURL.toString());
        this.processTemplate(template, model, out);
    }

    public void processTemplate(Template template, Object model) throws TemplateException, IOException {
        this.processTemplate(template, model, System.out);
    }

    public void processTemplate(Template template, Object model, PrintStream out) throws TemplateException, IOException {
        template.process(model, (Writer)new OutputStreamWriter(out));
    }

    public EnunciateFreemarkerModel getModel() {
        EnunciateFreemarkerModel model = this.getModelInternal();
        if (model == null) {
            throw new IllegalStateException("A model must be established.");
        }
        model.setObjectWrapper(this.getObjectWrapper());
        model.setFileOutputDirectory(this.getGenerateDir());
        return model;
    }

    protected EnunciateFreemarkerModel getModelInternal() {
        return this.model;
    }

    protected ObjectWrapper getObjectWrapper() {
        return new DefaultObjectWrapper();
    }

    protected Configuration getConfiguration() {
        Configuration configuration = new Configuration();
        configuration.setTemplateLoader((TemplateLoader)this.getTemplateLoader());
        configuration.setTemplateExceptionHandler(this.getTemplateExceptionHandler());
        configuration.setLocalizedLookup(false);
        return configuration;
    }

    protected TemplateExceptionHandler getTemplateExceptionHandler() {
        return new TemplateExceptionHandler(){

            public void handleTemplateException(TemplateException templateException, Environment environment, Writer writer) throws TemplateException {
                templateException.printStackTrace(System.err);
                throw templateException;
            }
        };
    }

    protected URLTemplateLoader getTemplateLoader() {
        return new URLTemplateLoader(){

            protected URL getURL(String name) {
                try {
                    return new URL(name);
                }
                catch (MalformedURLException e) {
                    return null;
                }
            }
        };
    }

    @Override
    public void close() throws EnunciateException {
        super.close();
        this.model = null;
    }

    @Override
    public void initModel(EnunciateFreemarkerModel model) {
        this.model = model;
    }
}

