/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.modules;

import java.io.File;
import java.io.IOException;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.digester.RuleSet;
import org.codehaus.enunciate.EnunciateException;
import org.codehaus.enunciate.contract.validation.Validator;
import org.codehaus.enunciate.main.Enunciate;
import org.codehaus.enunciate.modules.DeploymentModule;

public class BasicDeploymentModule
implements DeploymentModule {
    protected Enunciate enunciate;
    private boolean disabled;
    private File specifiedGenerateDir = null;
    private File specifiedCompileDir = null;
    private File specifiedBuildDir = null;
    private File specifiedPackageDir = null;
    private final Set<String> aliases = new TreeSet<String>();

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public Set<String> getAliases() {
        return this.aliases;
    }

    @Override
    public Validator getValidator() {
        return null;
    }

    @Override
    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    @Override
    public void init(Enunciate enunciate) throws EnunciateException {
        this.enunciate = enunciate;
    }

    public Enunciate getEnunciate() {
        return this.enunciate;
    }

    @Override
    public void step(Enunciate.Target target) throws EnunciateException, IOException {
        switch (target) {
            case GENERATE: {
                this.doGenerate();
                break;
            }
            case BUILD: {
                this.doBuild();
                break;
            }
            case COMPILE: {
                this.doCompile();
                break;
            }
            case PACKAGE: {
                this.doPackage();
            }
        }
    }

    protected void doGenerate() throws EnunciateException, IOException {
    }

    protected void doBuild() throws EnunciateException, IOException {
    }

    protected void doCompile() throws EnunciateException, IOException {
    }

    protected void doPackage() throws EnunciateException, IOException {
    }

    @Override
    public void close() throws EnunciateException {
    }

    @Override
    public RuleSet getConfigurationRules() {
        return null;
    }

    @Override
    public int getOrder() {
        return 0;
    }

    public File getGenerateDir() {
        return this.specifiedGenerateDir == null ? new File(this.getEnunciate().getGenerateDir(), this.getName()) : this.specifiedGenerateDir;
    }

    public void setGenerateDir(File generateDir) {
        this.specifiedGenerateDir = generateDir;
    }

    public File getCompileDir() {
        return this.specifiedCompileDir == null ? new File(this.getEnunciate().getCompileDir(), this.getName()) : this.specifiedCompileDir;
    }

    public void setCompileDir(File compileDir) {
        this.specifiedCompileDir = compileDir;
    }

    public File getBuildDir() {
        return this.specifiedBuildDir == null ? new File(this.getEnunciate().getBuildDir(), this.getName()) : this.specifiedBuildDir;
    }

    public void setBuildDir(File buildDir) {
        this.specifiedBuildDir = buildDir;
    }

    public File getPackageDir() {
        return this.specifiedPackageDir == null ? new File(this.getEnunciate().getPackageDir(), this.getName()) : this.specifiedPackageDir;
    }

    public void setPackageDir(File packageDir) {
        this.specifiedPackageDir = packageDir;
    }

    public void info(String message, Object ... formatArgs) {
        if (this.enunciate != null) {
            this.enunciate.info('[' + this.getName() + "] " + message, formatArgs);
        }
    }

    public void debug(String message, Object ... formatArgs) {
        if (this.enunciate != null) {
            this.enunciate.debug('[' + this.getName() + "] " + message, formatArgs);
        }
    }

    public void warn(String message, Object ... formatArgs) {
        if (this.enunciate != null) {
            this.enunciate.warn('[' + this.getName() + "] " + message, formatArgs);
        }
    }
}

