/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.modules;

import com.sun.tools.apt.Main;
import freemarker.ext.dom.NodeModel;
import freemarker.template.Configuration;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.TreeSet;
import java.util.jar.Manifest;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.jelly.apt.Context;
import net.sf.jelly.apt.freemarker.FreemarkerModel;
import org.apache.commons.digester.RuleSet;
import org.codehaus.enunciate.EnunciateException;
import org.codehaus.enunciate.apt.EnunciateFreemarkerModel;
import org.codehaus.enunciate.config.war.CopyResources;
import org.codehaus.enunciate.config.war.IncludeExcludeLibs;
import org.codehaus.enunciate.config.war.WebAppConfig;
import org.codehaus.enunciate.contract.validation.Validator;
import org.codehaus.enunciate.main.Enunciate;
import org.codehaus.enunciate.main.FileArtifact;
import org.codehaus.enunciate.main.webapp.BaseWebAppFragment;
import org.codehaus.enunciate.main.webapp.FilterComponent;
import org.codehaus.enunciate.main.webapp.WebAppComponent;
import org.codehaus.enunciate.main.webapp.WebAppFragment;
import org.codehaus.enunciate.modules.DeploymentModule;
import org.codehaus.enunciate.modules.FreemarkerDeploymentModule;
import org.codehaus.enunciate.util.AntPatternMatcher;
import org.codehaus.enunciate.util.PatternFileFilter;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class BasicAppModule
extends FreemarkerDeploymentModule {
    @Override
    public String getName() {
        return "basic-app";
    }

    protected URL getWebXmlTemplateURL() {
        return BasicAppModule.class.getResource("web.xml.fmt");
    }

    protected URL getMergeWebXmlTemplateURL() {
        return BasicAppModule.class.getResource("merge-web-xml.fmt");
    }

    @Override
    public void init(Enunciate enunciate) throws EnunciateException {
        super.init(enunciate);
        if (!this.isDisabled() && this.getWebAppConfig() != null && !this.getWebAppConfig().getGlobalServletFilters().isEmpty()) {
            for (FilterComponent globalServletFilter : this.getWebAppConfig().getGlobalServletFilters()) {
                if (globalServletFilter.getName() == null) {
                    throw new EnunciateException("A global servlet filter (as specified in the enunciate config) requires a name.");
                }
                if (globalServletFilter.getClassname() != null) continue;
                throw new EnunciateException("A global servlet filter (as specified in the enunciate config) requires a classname.");
            }
        }
    }

    @Override
    public void doFreemarkerGenerate() throws EnunciateException, IOException, TemplateException {
    }

    @Override
    protected void doCompile() throws EnunciateException, IOException {
        Enunciate enunciate = this.getEnunciate();
        if (this.getWebAppConfig() != null && !this.getWebAppConfig().isDoCompile()) {
            this.debug("Compilation has been disabled.  No server-side classes will be compiled, nor will any resources be copied.", new Object[0]);
            return;
        }
        File compileDir = this.getCompileDir();
        if (!enunciate.isUpToDateWithSources(compileDir)) {
            enunciate.compileSources(compileDir);
            if (this.getWebAppConfig() != null && !this.getWebAppConfig().getCopyResources().isEmpty()) {
                AntPatternMatcher matcher = new AntPatternMatcher();
                for (CopyResources copyResource : this.getWebAppConfig().getCopyResources()) {
                    File configFile;
                    String pattern = copyResource.getPattern();
                    if (pattern == null) {
                        throw new EnunciateException("A pattern must be specified for copying resources.");
                    }
                    if (!matcher.isPattern(pattern)) {
                        this.warn("'%s' is not a valid pattern.  Resources NOT copied!", pattern);
                        continue;
                    }
                    File basedir = copyResource.getDir() == null ? ((configFile = enunciate.getConfigFile()) != null ? configFile.getAbsoluteFile().getParentFile() : new File(System.getProperty("user.dir"))) : enunciate.resolvePath(copyResource.getDir());
                    for (String file : enunciate.getFiles(basedir, new PatternFileFilter(basedir, pattern, matcher))) {
                        enunciate.copyFile(new File(file), basedir, compileDir);
                    }
                }
            }
        } else {
            this.info("Skipping compilation as everything appears up-to-date...", new Object[0]);
        }
    }

    @Override
    protected void doBuild() throws IOException, EnunciateException {
        File buildDir;
        Enunciate enunciate = this.getEnunciate();
        if (!enunciate.isUpToDateWithSources(buildDir = this.getBuildDir())) {
            this.copyPreBase();
            this.debug("Building the expanded WAR in %s", buildDir);
            if (this.getWebAppConfig() != null && !this.getWebAppConfig().getGlobalServletFilters().isEmpty()) {
                TreeSet<String> allServletNames = new TreeSet<String>();
                for (WebAppFragment fragment : enunciate.getWebAppFragments()) {
                    if (fragment.getServlets() == null) continue;
                    for (WebAppComponent webAppComponent : fragment.getServlets()) {
                        allServletNames.add(webAppComponent.getName());
                    }
                }
                for (FilterComponent filter : this.getWebAppConfig().getGlobalServletFilters()) {
                    filter.setServletNames(allServletNames);
                    filter.setDispatchers(new TreeSet<String>(Arrays.asList("FORWARD", "REQUEST")));
                }
                WebAppFragment fragment = new BaseWebAppFragment("global-servlet-filters");
                ((BaseWebAppFragment)fragment).setFilters(this.getWebAppConfig().getGlobalServletFilters());
                enunciate.addWebAppFragment(fragment);
            }
            for (WebAppFragment fragment : enunciate.getWebAppFragments()) {
                if (fragment.getBaseDir() == null) continue;
                enunciate.copyDir(fragment.getBaseDir(), buildDir, new File[0]);
            }
            if (this.getWebAppConfig() == null || this.getWebAppConfig().isDoCompile()) {
                File webinf = new File(buildDir, "WEB-INF");
                File webinfClasses = new File(webinf, "classes");
                enunciate.copyDir(this.getCompileDir(), webinfClasses, new File[0]);
            }
            if (this.getWebAppConfig() == null || this.getWebAppConfig().isDoLibCopy()) {
                this.doLibCopy();
            } else {
                this.debug("Lib copy has been disabled.  No libs will be copied, nor any manifest written.", new Object[0]);
            }
            this.generateWebXml();
            this.copyPostBase();
        } else {
            this.info("Skipping the build of the expanded war as everything appears up-to-date...", new Object[0]);
        }
        enunciate.addArtifact(new FileArtifact(this.getName(), "app.dir", buildDir));
    }

    protected void copyPostBase() throws IOException {
        Enunciate enunciate = this.getEnunciate();
        File buildDir = this.getBuildDir();
        WebAppConfig webAppConfig = this.getWebAppConfig();
        if (webAppConfig != null && webAppConfig.getPostBase() != null) {
            File postBase = enunciate.resolvePath(webAppConfig.getPostBase());
            if (postBase.isDirectory()) {
                this.debug("Copying postBase directory %s to %s...", postBase, buildDir);
                enunciate.copyDir(postBase, buildDir, new File[0]);
            } else {
                this.debug("Extracting postBase zip file %s to %s...", postBase, buildDir);
                enunciate.extractBase(new FileInputStream(postBase), buildDir);
            }
        }
    }

    protected void copyPreBase() throws IOException {
        Enunciate enunciate = this.getEnunciate();
        File buildDir = this.getBuildDir();
        WebAppConfig webAppConfig = this.getWebAppConfig();
        if (webAppConfig != null && webAppConfig.getPreBase() != null) {
            File preBase = enunciate.resolvePath(webAppConfig.getPreBase());
            if (preBase.isDirectory()) {
                this.debug("Copying preBase directory %s to %s...", preBase, buildDir);
                enunciate.copyDir(preBase, buildDir, new File[0]);
            } else {
                this.debug("Extracting preBase zip file %s to %s...", preBase, buildDir);
                enunciate.extractBase(new FileInputStream(preBase), buildDir);
            }
        }
    }

    protected void generateWebXml() throws IOException, EnunciateException {
        Enunciate enunciate = this.getEnunciate();
        File buildDir = this.getBuildDir();
        File webinf = new File(buildDir, "WEB-INF");
        webinf.mkdirs();
        File destWebXML = new File(webinf, "web.xml");
        File configDir = this.getGenerateDir();
        File webXML = new File(configDir, "web.xml");
        EnunciateFreemarkerModel model = this.getModel();
        model.setFileOutputDirectory(configDir);
        try {
            model.put("displayName", model.getEnunciateConfig().getLabel());
            model.put("webAppFragments", enunciate.getWebAppFragments());
            List<Object> envEntries = Collections.emptyList();
            List<Object> resourceEnvRefs = Collections.emptyList();
            List<Object> resourceRefs = Collections.emptyList();
            WebAppConfig webAppConfig = this.getWebAppConfig();
            if (webAppConfig != null) {
                envEntries = webAppConfig.getEnvEntries();
                resourceEnvRefs = webAppConfig.getResourceEnvRefs();
                resourceRefs = webAppConfig.getResourceRefs();
            }
            model.put("envEntries", envEntries);
            model.put("resourceEnvRefs", resourceEnvRefs);
            model.put("resourceRefs", resourceRefs);
            if (webAppConfig != null) {
                model.put("webappAttributes", webAppConfig.getWebXmlAttributes());
            }
            this.processTemplate(this.getWebXmlTemplateURL(), (Object)model);
        }
        catch (TemplateException e) {
            throw new EnunciateException("Error processing web.xml template file.", e);
        }
        File mergedWebXml = webXML;
        WebAppConfig webAppConfig = this.getWebAppConfig();
        if (webAppConfig != null && (webAppConfig.getMergeWebXMLURL() != null || webAppConfig.getMergeWebXML() != null)) {
            URL webXmlToMerge = webAppConfig.getMergeWebXMLURL();
            if (webXmlToMerge == null) {
                webXmlToMerge = enunciate.resolvePath(webAppConfig.getMergeWebXML()).toURL();
            }
            try {
                Document source1Doc = this.loadMergeXml(webXmlToMerge.openStream());
                NodeModel.simplify((Node)source1Doc);
                Document source2Doc = this.loadMergeXml(new FileInputStream(webXML));
                NodeModel.simplify((Node)source2Doc);
                HashMap<String, String> mergedAttributes = new HashMap<String, String>();
                NamedNodeMap source2Attributes = source2Doc.getDocumentElement().getAttributes();
                for (int i = 0; i < source2Attributes.getLength(); ++i) {
                    mergedAttributes.put(source2Attributes.item(i).getNodeName(), source2Attributes.item(i).getNodeValue());
                }
                NamedNodeMap source1Attributes = source1Doc.getDocumentElement().getAttributes();
                for (int i = 0; i < source1Attributes.getLength(); ++i) {
                    mergedAttributes.put(source1Attributes.item(i).getNodeName(), source1Attributes.item(i).getNodeValue());
                }
                model.put("source1", NodeModel.wrap((Node)source1Doc.getDocumentElement()));
                model.put("source2", NodeModel.wrap((Node)source2Doc.getDocumentElement()));
                model.put("mergedAttributes", mergedAttributes);
                this.processTemplate(this.getMergeWebXmlTemplateURL(), (Object)model);
            }
            catch (TemplateException e) {
                throw new EnunciateException("Error while merging web xml files.", e);
            }
            File mergeTarget = new File(this.getGenerateDir(), "merged-web.xml");
            if (!mergeTarget.exists()) {
                throw new EnunciateException("Error: " + mergeTarget + " doesn't exist.");
            }
            this.debug("Merged %s and %s into %s...", webXmlToMerge, webXML, mergeTarget);
            mergedWebXml = mergeTarget;
        }
        if (webAppConfig != null && (webAppConfig.getWebXMLTransformURL() != null || webAppConfig.getWebXMLTransform() != null)) {
            URL transformURL = webAppConfig.getWebXMLTransformURL();
            if (transformURL == null) {
                transformURL = enunciate.resolvePath(webAppConfig.getWebXMLTransform()).toURI().toURL();
            }
            this.debug("web.xml transform has been specified as %s.", transformURL);
            try {
                StreamSource source = new StreamSource(transformURL.openStream());
                Transformer transformer = TransformerFactory.newInstance().newTransformer(source);
                this.debug("Transforming %s to %s.", mergedWebXml, destWebXML);
                transformer.transform(new StreamSource(new FileReader(mergedWebXml)), new StreamResult(destWebXML));
            }
            catch (TransformerException e) {
                throw new EnunciateException("Error during transformation of the web.xml (stylesheet " + transformURL + ", file " + mergedWebXml + ")", e);
            }
        } else {
            enunciate.copyFile(mergedWebXml, destWebXML);
        }
    }

    protected Document loadMergeXml(InputStream inputStream) throws EnunciateException {
        Document doc;
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setNamespaceAware(false);
            builderFactory.setValidating(false);
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            builder.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    return new InputSource(new StringReader(""));
                }
            });
            doc = builder.parse(inputStream);
        }
        catch (Exception e) {
            throw new EnunciateException("Error parsing web.xml file for merging", e);
        }
        return doc;
    }

    protected void doLibCopy() throws IOException {
        Manifest manifest;
        Enunciate enunciate = this.getEnunciate();
        File buildDir = this.getBuildDir();
        File webinf = new File(buildDir, "WEB-INF");
        File webinfClasses = new File(webinf, "classes");
        File webinfLib = new File(webinf, "lib");
        AntPatternMatcher pathMatcher = new AntPatternMatcher();
        pathMatcher.setPathSeparator(File.separator);
        ArrayList<File> explicitIncludes = new ArrayList<File>();
        ArrayList<String> includePatterns = new ArrayList<String>();
        WebAppConfig webAppConfig = this.getWebAppConfig();
        if (webAppConfig != null) {
            for (IncludeExcludeLibs el : webAppConfig.getIncludeLibs()) {
                String pattern;
                if (el.getFile() != null) {
                    explicitIncludes.add(el.getFile());
                }
                if ((pattern = el.getPattern()) == null) continue;
                if (pathMatcher.isPattern(pattern = pattern.replace('/', File.separatorChar))) {
                    includePatterns.add(pattern);
                    continue;
                }
                this.warn("Pattern '%s' is not a valid pattern, so it will not be applied.", pattern);
            }
        }
        if (includePatterns.isEmpty()) {
            String starPattern = "**" + File.separatorChar + "*";
            this.debug("No include patterns have been specified.  Using the implicit '%s' pattern.", starPattern);
            includePatterns.add(starPattern);
        }
        ArrayList<String> warLibs = new ArrayList<String>();
        if (webAppConfig == null || webAppConfig.isIncludeClasspathLibs()) {
            this.debug("Using the Enunciate classpath as the initial list of libraries to be passed through the include/exclude filter.", new Object[0]);
            warLibs.addAll(Arrays.asList(enunciate.getEnunciateRuntimeClasspath().split(File.pathSeparator)));
        }
        ArrayList<File> includedLibs = new ArrayList<File>();
        block1: for (String warLib : warLibs) {
            File libFile = new File(warLib);
            if (!libFile.exists()) continue;
            for (String includePattern : includePatterns) {
                String absolutePath = libFile.getAbsolutePath();
                if (absolutePath.startsWith(File.separator)) {
                    absolutePath = absolutePath.substring(1);
                }
                if (pathMatcher.match(includePattern, absolutePath)) {
                    this.debug("Library '%s' passed the include filter. It matches pattern '%s'.", libFile.getAbsolutePath(), includePattern);
                    includedLibs.add(libFile);
                    continue block1;
                }
                if (!enunciate.isDebug()) continue;
                this.debug("Library '%s' did NOT match include pattern '%s'.", includePattern);
            }
        }
        boolean excludeDefaults = webAppConfig == null || webAppConfig.isExcludeDefaultLibs();
        ArrayList<String> manifestClasspath = new ArrayList<String>();
        Iterator toBeIncludedIt = includedLibs.iterator();
        block3: while (toBeIncludedIt.hasNext()) {
            File toBeIncluded = (File)toBeIncludedIt.next();
            if (excludeDefaults && this.knownExclude(toBeIncluded)) {
                toBeIncludedIt.remove();
                continue;
            }
            if (webAppConfig == null) continue;
            for (IncludeExcludeLibs excludeLibs : webAppConfig.getExcludeLibs()) {
                boolean exclude = false;
                if (excludeLibs.getFile() != null && excludeLibs.getFile().equals(toBeIncluded)) {
                    exclude = true;
                    this.debug("%s was explicitly excluded.", toBeIncluded);
                } else {
                    String pattern = excludeLibs.getPattern();
                    if (pattern != null && pathMatcher.isPattern(pattern = pattern.replace('/', File.separatorChar))) {
                        String absolutePath = toBeIncluded.getAbsolutePath();
                        if (absolutePath.startsWith(File.separator)) {
                            absolutePath = absolutePath.substring(1);
                        }
                        if (pathMatcher.match(pattern, absolutePath)) {
                            exclude = true;
                            this.debug("%s was excluded because it matches pattern '%s'", toBeIncluded, pattern);
                        }
                    }
                }
                if (!exclude) continue;
                toBeIncludedIt.remove();
                if (!excludeLibs.isIncludeInManifest() || toBeIncluded.isDirectory()) continue block3;
                manifestClasspath.add(toBeIncluded.getName());
                this.debug("'%s' will be included in the manifest classpath.", toBeIncluded.getName());
                continue block3;
            }
        }
        includedLibs.addAll(explicitIncludes);
        for (File includedLib : includedLibs) {
            if (includedLib.isDirectory()) {
                this.debug("Adding the contents of %s to WEB-INF/classes.", includedLib);
                enunciate.copyDir(includedLib, webinfClasses, new File[0]);
                continue;
            }
            this.debug("Including %s in WEB-INF/lib.", includedLib);
            enunciate.copyFile(includedLib, includedLib.getParentFile(), webinfLib);
        }
        Manifest manifest2 = manifest = webAppConfig == null ? WebAppConfig.getDefaultManifest() : webAppConfig.getManifest();
        if (manifestClasspath.size() > 0 && manifest.getMainAttributes().getValue("Class-Path") == null) {
            StringBuilder manifestClasspathValue = new StringBuilder();
            Iterator manifestClasspathIt = manifestClasspath.iterator();
            while (manifestClasspathIt.hasNext()) {
                String entry = (String)manifestClasspathIt.next();
                manifestClasspathValue.append(entry);
                if (!manifestClasspathIt.hasNext()) continue;
                manifestClasspathValue.append(" ");
            }
            manifest.getMainAttributes().putValue("Class-Path", manifestClasspathValue.toString());
        }
        File metaInf = new File(buildDir, "META-INF");
        metaInf.mkdirs();
        FileOutputStream manifestFileOut = new FileOutputStream(new File(metaInf, "MANIFEST.MF"));
        manifest.write(manifestFileOut);
        manifestFileOut.flush();
        manifestFileOut.close();
    }

    @Override
    protected void doPackage() throws EnunciateException, IOException {
        if (this.getWebAppConfig() == null || this.getWebAppConfig().isDoPackage()) {
            File buildDir = this.getBuildDir();
            File warFile = this.getWarFile();
            Enunciate enunciate = this.getEnunciate();
            if (!enunciate.isUpToDate(buildDir, warFile)) {
                if (!warFile.getParentFile().exists()) {
                    warFile.getParentFile().mkdirs();
                }
                this.debug("Creating %s", warFile.getAbsolutePath());
                enunciate.zip(warFile, buildDir);
            } else {
                this.info("Skipping war file creation as everything appears up-to-date...", new Object[0]);
            }
            enunciate.addArtifact(new FileArtifact(this.getName(), "war.file", warFile));
        } else {
            this.debug("Packaging has been disabled.  No packaging will be performed.", new Object[0]);
        }
    }

    public File getWarFile() {
        WebAppConfig config = this.getWebAppConfig();
        if (config != null && config.getWar() != null) {
            return this.getEnunciate().resolvePath(config.getWar());
        }
        String filename = "enunciate.war";
        if (this.getEnunciate().getConfig().getLabel() != null) {
            filename = this.getEnunciate().getConfig().getLabel() + ".war";
        }
        return new File(this.getPackageDir(), filename);
    }

    protected boolean knownExclude(File file) throws IOException {
        URLClassLoader loader = new URLClassLoader(new URL[]{file.toURL()}, null);
        if (loader.findResource("META-INF/enunciate/preserve-in-war") != null) {
            this.debug("%s is a known include because it contains the entry META-INF/enunciate/preserve-in-war.", file);
            return false;
        }
        if (loader.findResource(Main.class.getName().replace('.', '/').concat(".class")) != null) {
            this.debug("%s is a known exclude because it appears to be tools.jar.", file);
            return true;
        }
        if (loader.findResource(Context.class.getName().replace('.', '/').concat(".class")) != null) {
            this.debug("%s is a known exclude because it appears to be apt-jelly.", file);
            return true;
        }
        if (loader.findResource(FreemarkerModel.class.getName().replace('.', '/').concat(".class")) != null) {
            this.debug("%s is a known exclude because it appears to be the apt-jelly-freemarker libs.", file);
            return true;
        }
        if (loader.findResource(Configuration.class.getName().replace('.', '/').concat(".class")) != null) {
            this.debug("%s is a known exclude because it appears to be the freemarker libs.", file);
            return true;
        }
        if (loader.findResource(Enunciate.class.getName().replace('.', '/').concat(".class")) != null) {
            this.debug("%s is a known exclude because it appears to be the enunciate core jar.", file);
            return true;
        }
        if (loader.findResource("javax/servlet/ServletContext.class") != null) {
            this.debug("%s is a known exclude because it appears to be the servlet api.", file);
            return true;
        }
        if (loader.findResource("org/codehaus/enunciate/modules/xfire_client/EnunciatedClientSoapSerializerHandler.class") != null) {
            this.debug("%s is a known exclude because it appears to be the enunciated xfire client tools jar.", file);
            return true;
        }
        if (loader.findResource("javax/swing/SwingBeanInfoBase.class") != null) {
            this.debug("%s is a known exclude because it appears to be dt.jar.", file);
            return true;
        }
        if (loader.findResource("HTMLConverter.class") != null) {
            this.debug("%s is a known exclude because it appears to be htmlconverter.jar.", file);
            return true;
        }
        if (loader.findResource("sun/tools/jconsole/JConsole.class") != null) {
            this.debug("%s is a known exclude because it appears to be jconsole.jar.", file);
            return true;
        }
        if (loader.findResource("sun/jvm/hotspot/debugger/Debugger.class") != null) {
            this.debug("%s is a known exclude because it appears to be sa-jdi.jar.", file);
            return true;
        }
        if (loader.findResource("sun/io/ByteToCharDoubleByte.class") != null) {
            this.debug("%s is a known exclude because it appears to be charsets.jar.", file);
            return true;
        }
        if (loader.findResource("com/sun/deploy/ClientContainer.class") != null) {
            this.debug("%s is a known exclude because it appears to be deploy.jar.", file);
            return true;
        }
        if (loader.findResource("com/sun/javaws/Globals.class") != null) {
            this.debug("%s is a known exclude because it appears to be javaws.jar.", file);
            return true;
        }
        if (loader.findResource("javax/crypto/SecretKey.class") != null) {
            this.debug("%s is a known exclude because it appears to be jce.jar.", file);
            return true;
        }
        if (loader.findResource("sun/net/www/protocol/https/HttpsClient.class") != null) {
            this.debug("%s is a known exclude because it appears to be jsse.jar.", file);
            return true;
        }
        if (loader.findResource("sun/plugin/JavaRunTime.class") != null) {
            this.debug("%s is a known exclude because it appears to be plugin.jar.", file);
            return true;
        }
        if (loader.findResource("com/sun/corba/se/impl/activation/ServerMain.class") != null) {
            this.debug("%s is a known exclude because it appears to be rt.jar.", file);
            return true;
        }
        if (ServiceLoader.load(DeploymentModule.class, loader).iterator().hasNext()) {
            this.debug("%s is a known exclude because it appears to be an enunciate module.", file);
            return true;
        }
        return false;
    }

    @Override
    public int getOrder() {
        return 300;
    }

    @Override
    public RuleSet getConfigurationRules() {
        return null;
    }

    @Override
    public Validator getValidator() {
        return null;
    }

    public WebAppConfig getWebAppConfig() {
        return this.getEnunciate() != null && this.getEnunciate().getConfig() != null ? this.getEnunciate().getConfig().getWebAppConfig() : null;
    }

    @Override
    public boolean isDisabled() {
        return this.getWebAppConfig() != null && this.getWebAppConfig().isDisabled();
    }

    @Override
    public File getBuildDir() {
        File buildDir = null;
        WebAppConfig webAppConfig = this.getWebAppConfig();
        if (webAppConfig != null && webAppConfig.getDir() != null) {
            buildDir = this.getEnunciate().resolvePath(webAppConfig.getDir());
            buildDir.mkdirs();
        }
        return buildDir == null ? super.getBuildDir() : buildDir;
    }
}

