/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.main;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import org.codehaus.enunciate.main.BaseArtifact;
import org.codehaus.enunciate.main.Enunciate;

public class TextArtifact
extends BaseArtifact {
    private boolean publicArtifact = true;
    private final String text;

    public TextArtifact(String module, String id, String text) {
        super(module, id);
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    @Override
    public void exportTo(File file, Enunciate enunciate) throws IOException {
        if (file.exists() && file.isDirectory()) {
            file = new File(file, this.getId());
        }
        file.getParentFile().mkdirs();
        PrintWriter writer = new PrintWriter(file);
        writer.print(this.text);
        writer.flush();
        writer.close();
    }

    @Override
    public long getSize() {
        try {
            return this.text.getBytes("utf-8").length;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isPublic() {
        return this.publicArtifact;
    }

    public void setPublic(boolean bundled) {
        this.publicArtifact = bundled;
    }
}

