/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.main;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.codehaus.enunciate.main.ClasspathHandler;
import org.codehaus.enunciate.main.ClasspathResource;
import org.codehaus.enunciate.main.Enunciate;
import org.codehaus.enunciate.main.JarClasspathResource;
import org.codehaus.enunciate.util.JaxbPackageInfoWriter;

public class PackageInfoClasspathHandler
implements ClasspathHandler {
    private final Enunciate enunciate;
    private final Map<String, File> packageInfoSources = new HashMap<String, File>();
    private final File tempSourcesDir;

    public PackageInfoClasspathHandler(Enunciate enunciate) throws IOException {
        this.enunciate = enunciate;
        this.tempSourcesDir = enunciate.createTempDir();
    }

    @Override
    public void startPathEntry(File pathEntry) {
    }

    @Override
    public void handleResource(ClasspathResource resource) {
        String path = resource.getPath();
        if (path.startsWith("com/sun/tools")) {
            return;
        }
        if (path.startsWith("com/google/gwt")) {
            return;
        }
        if (resource instanceof JarClasspathResource) {
            if (path.endsWith("package-info.class")) {
                if (!this.packageInfoSources.containsKey(path)) {
                    File sourceFile = new File(this.tempSourcesDir, path.substring(0, path.length() - 6) + ".java");
                    this.enunciate.debug("Generating package source file %s...", sourceFile);
                    try {
                        InputStream resourceStream = resource.read();
                        if (this.writePackageSourceFile(resourceStream, sourceFile)) {
                            this.packageInfoSources.put(path, sourceFile);
                        }
                        resourceStream.close();
                    }
                    catch (IOException e) {
                        this.enunciate.warn("Unable to generate package source file %s (%s).", sourceFile, e.getMessage());
                    }
                }
            } else if (path.endsWith("package-info.java")) {
                File sourceFile = new File(this.tempSourcesDir, path);
                this.enunciate.debug("Noticed the source for %s, extracting to %s.", path, sourceFile);
                try {
                    int len;
                    InputStream in = resource.read();
                    sourceFile.getParentFile().mkdirs();
                    FileOutputStream out = new FileOutputStream(sourceFile);
                    byte[] buffer = new byte[2048];
                    while ((len = in.read(buffer)) > 0) {
                        out.write(buffer, 0, len);
                    }
                    out.flush();
                    out.close();
                    in.close();
                    this.packageInfoSources.put(path, sourceFile);
                }
                catch (IOException e) {
                    this.enunciate.warn("Unable to extract source file %s (%s).", sourceFile, e.getMessage());
                }
            }
        }
    }

    @Override
    public boolean endPathEntry(File pathEntry) {
        return false;
    }

    protected boolean writePackageSourceFile(InputStream bytecode, File packageSourceFile) throws IOException {
        JaxbPackageInfoWriter writer = new JaxbPackageInfoWriter();
        String info = writer.write(bytecode);
        if (info != null) {
            packageSourceFile.getParentFile().mkdirs();
            FileWriter out = new FileWriter(packageSourceFile);
            out.write(info);
            out.flush();
            out.close();
            return true;
        }
        return false;
    }

    public Set<File> getPackageInfoSources() {
        return new HashSet<File>(this.packageInfoSources.values());
    }
}

