/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.main;

import java.io.File;
import org.codehaus.enunciate.main.Enunciate;

public class Main {
    private Main() {
    }

    public static void main(String[] args) throws Exception {
        Enunciate enunciate = new Enunciate();
        if (args == null || args.length < 1) {
            Main.printUsage();
            System.exit(1);
        }
        for (int argIndex = 0; argIndex < args.length; ++argIndex) {
            Option opt;
            String option = args[argIndex];
            if (!option.startsWith("-")) {
                String[] sourceFiles = new String[args.length - argIndex];
                System.arraycopy(args, argIndex, sourceFiles, 0, sourceFiles.length);
                enunciate.setSourceFiles(sourceFiles);
                break;
            }
            option = option.startsWith("--") ? option.substring(2) : option.substring(1);
            boolean handled = false;
            Option[] arr$ = Option.values();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && !(handled = (opt = arr$[i$]).handle(option, enunciate)); ++i$) {
            }
            if (!handled) {
                if (args.length > ++argIndex) {
                    Option opt2;
                    String value = args[argIndex];
                    Option[] arr$2 = Option.values();
                    int len$2 = arr$2.length;
                    for (int i$ = 0; i$ < len$2 && !(handled = (opt2 = arr$2[i$]).handle(option, value, enunciate)); ++i$) {
                    }
                } else {
                    System.out.println("Unable to parse option: " + option + " (try specifying a value).");
                    Main.printUsage();
                    System.exit(1);
                }
            }
            if (handled) continue;
            System.out.println("Unknown option: " + option);
            Main.printUsage();
            System.exit(1);
        }
        enunciate.execute();
    }

    public static void printUsage() {
        System.out.println("Usage: <enunciate command> [options] [source files]");
        System.out.println("Where possible options include:");
        for (Option option : Option.values()) {
            System.out.println(option.getHelpInfo());
        }
    }

    public static enum Option {
        verbose("v", "Print verbose output to the console."),
        debug("vv", "Print debug-level output to the console."),
        disableDebugInfo("xg", "Disable compilation with debug info."),
        javacCheck("Xc", "Do a javac check before invoking Enunciate."),
        javacArguments("Xa", "argument", "Extra arguments to pass to javac.  May be repeated."),
        configFile("f", "file", "The enunciate xml config file."),
        generateDir("g", "dir", "The output directory for the \"generate\" step."),
        compileDir("c", "dir", "The output directory for the \"compile\" step."),
        buildDir("b", "dir", "The output directory for the \"build\" step."),
        packageDir("p", "dir", "The output directory for the \"package\" step."),
        classpath("cp", "path", "The classpath to use (defaults to the system classpath)."),
        target("t", "target", "The target step (defaults to \"package\"). Possible values: \"generate\", \"compile\", \"build\", \"package\"."),
        export("E[artifactId]", "file or dir", "The file (or directory) to which to export the artifact identified by [artifactId]");

        private final String id;
        private final String valueName;
        private final String description;

        private Option(String id, String description) {
            this(id, null, description);
        }

        private Option(String id, String valueName, String description) {
            this.id = id;
            this.valueName = valueName;
            this.description = description;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.toString();
        }

        public String getValueName() {
            return this.valueName;
        }

        public String getDescription() {
            return this.description;
        }

        public String getHelpInfo() {
            String optionFormat = this == export ? String.format("-%s %s", this.getId(), this.getValueName()) : (this.valueName == null ? String.format("[%-3s| --%s]", "-" + this.getId(), this.getName()) : String.format("[%-3s| --%s] <%s>", "-" + this.getId(), this.getName(), this.getValueName()));
            return String.format("  %-30s %s", optionFormat, this.getDescription());
        }

        public boolean handle(String option, Enunciate enunciate) {
            if (!this.getId().equals(option) && !this.getName().equals(option)) {
                return false;
            }
            switch (this) {
                case verbose: {
                    enunciate.setVerbose(true);
                    return true;
                }
                case debug: {
                    enunciate.setDebug(true);
                    return true;
                }
                case javacCheck: {
                    enunciate.setJavacCheck(true);
                    return true;
                }
                case disableDebugInfo: {
                    enunciate.setCompileDebugInfo(false);
                    return true;
                }
            }
            return false;
        }

        public boolean handle(String option, String value, Enunciate enunciate) {
            if (this != export && !this.getId().equals(option) && !this.getName().equals(option)) {
                return false;
            }
            switch (this) {
                case configFile: {
                    File file = new File(value);
                    if (!file.exists()) {
                        throw new IllegalArgumentException("File not found: " + file.getAbsolutePath());
                    }
                    enunciate.setConfigFile(file);
                    return true;
                }
                case generateDir: {
                    File dir = new File(value);
                    if (!dir.exists()) {
                        throw new IllegalArgumentException("Generate directory not found: " + dir.getAbsolutePath());
                    }
                    if (!dir.isDirectory()) {
                        throw new IllegalArgumentException("Generate directory " + dir.getAbsolutePath() + " is not a directory.");
                    }
                    enunciate.setGenerateDir(dir);
                    return true;
                }
                case compileDir: {
                    File dir = new File(value);
                    if (!dir.exists()) {
                        throw new IllegalArgumentException("Compile directory not found: " + dir.getAbsolutePath());
                    }
                    if (!dir.isDirectory()) {
                        throw new IllegalArgumentException("Compile directory " + dir.getAbsolutePath() + " is not a directory.");
                    }
                    enunciate.setCompileDir(dir);
                    return true;
                }
                case buildDir: {
                    File dir = new File(value);
                    if (!dir.exists()) {
                        throw new IllegalArgumentException("Build directory not found: " + dir.getAbsolutePath());
                    }
                    if (!dir.isDirectory()) {
                        throw new IllegalArgumentException("Build directory " + dir.getAbsolutePath() + " is not a directory.");
                    }
                    enunciate.setBuildDir(dir);
                    return true;
                }
                case packageDir: {
                    File dir = new File(value);
                    if (!dir.exists()) {
                        throw new IllegalArgumentException("Package directory not found: " + dir.getAbsolutePath());
                    }
                    if (!dir.isDirectory()) {
                        throw new IllegalArgumentException("Package directory " + dir.getAbsolutePath() + " is not a directory.");
                    }
                    enunciate.setPackageDir(dir);
                    return true;
                }
                case classpath: {
                    enunciate.setRuntimeClasspath(value);
                    return true;
                }
                case target: {
                    try {
                        enunciate.setTarget(Enunciate.Target.valueOf(value.toUpperCase()));
                    }
                    catch (IllegalArgumentException e) {
                        throw new IllegalArgumentException("Unknown target: " + value);
                    }
                    return true;
                }
                case export: {
                    if (!option.startsWith("E")) {
                        return false;
                    }
                    enunciate.addExport(option.substring(1), new File(value));
                    return true;
                }
                case javacArguments: {
                    enunciate.getConfiguredJavacArguments().add(value);
                    return true;
                }
            }
            return false;
        }
    }
}

