/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.main;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.codehaus.enunciate.apt.EnunciateClasspathListener;
import org.codehaus.enunciate.config.APIImport;
import org.codehaus.enunciate.main.ClasspathHandler;
import org.codehaus.enunciate.main.ClasspathResource;
import org.codehaus.enunciate.main.Enunciate;
import org.codehaus.enunciate.modules.DeploymentModule;
import org.codehaus.enunciate.util.AntPatternMatcher;

public class ImportedClassesClasspathHandler
implements ClasspathHandler {
    private final Enunciate enunciate;
    private final Map<String, File> classesToSources = new HashMap<String, File>();
    private final File tempSourcesDir;
    private File currentEntry;
    private Map<String, File> currentEntryClassesToSources;
    private boolean classesImportedFromCurrentEntry;

    public ImportedClassesClasspathHandler(Enunciate enunciate) throws IOException {
        this.enunciate = enunciate;
        this.tempSourcesDir = enunciate.createTempDir();
    }

    public Map<String, File> getClassesToSources() {
        return this.classesToSources;
    }

    @Override
    public void startPathEntry(File pathEntry) {
        this.currentEntry = pathEntry;
        this.currentEntryClassesToSources = new HashMap<String, File>();
        this.classesImportedFromCurrentEntry = false;
    }

    @Override
    public void handleResource(ClasspathResource resource) {
        String path = resource.getPath();
        if (path.endsWith(".class")) {
            String classname = path.substring(0, path.length() - 6).replace('/', '.').replace('$', '.');
            if (!classname.endsWith(".package-info")) {
                this.enunciate.debug("Noticed class %s in %s.", classname, this.currentEntry);
                this.currentEntryClassesToSources.put(classname, this.currentEntryClassesToSources.get(classname));
            }
        } else if (path.endsWith(".java")) {
            String classname = path.substring(0, path.length() - 5).replace('/', '.');
            if (!classname.endsWith(".package-info")) {
                File sourcesFile = new File(this.tempSourcesDir, path);
                this.enunciate.debug("Noticed the source for class %s in %s, extracting to %s.", classname, this.currentEntry, sourcesFile);
                try {
                    int len;
                    InputStream in = resource.read();
                    sourcesFile.getParentFile().mkdirs();
                    FileOutputStream out = new FileOutputStream(sourcesFile);
                    byte[] buffer = new byte[2048];
                    while ((len = in.read(buffer)) > 0) {
                        out.write(buffer, 0, len);
                    }
                    out.flush();
                    out.close();
                    in.close();
                    this.currentEntryClassesToSources.put(classname, sourcesFile);
                }
                catch (IOException e) {
                    this.enunciate.warn("Unable to extract source file %s (%s).", sourcesFile, e.getMessage());
                }
            }
        } else if ("META-INF/enunciate/api-exports".equals(path)) {
            this.enunciate.debug("Importing classes listed in META-INF/enunciate/api-exports in %s.", this.currentEntry);
            try {
                InputStream in = resource.read();
                Set<String> autoImports = this.readAutoImports(in);
                in.close();
                for (String autoImport : autoImports) {
                    this.classesImportedFromCurrentEntry = this.classesImportedFromCurrentEntry || !this.classesToSources.containsKey(autoImport);
                    this.classesToSources.put(autoImport, this.classesToSources.get(autoImport));
                }
            }
            catch (IOException e) {
                this.enunciate.warn("Unable to read export list found in %s: %s.", this.currentEntry, e.getMessage());
            }
        }
    }

    @Override
    public boolean endPathEntry(File pathEntry) {
        if (this.enunciate.getConfig() != null) {
            Set<String> classesFound = this.currentEntryClassesToSources.keySet();
            for (DeploymentModule deploymentModule : this.enunciate.getConfig().getEnabledModules()) {
                if (!(deploymentModule instanceof EnunciateClasspathListener)) continue;
                ((EnunciateClasspathListener)((Object)deploymentModule)).onClassesFound(classesFound);
            }
        }
        this.classesImportedFromCurrentEntry = this.copyImportedClasses(this.currentEntryClassesToSources, this.classesToSources) || this.classesImportedFromCurrentEntry;
        this.currentEntry = null;
        this.currentEntryClassesToSources = null;
        return this.classesImportedFromCurrentEntry;
    }

    private Set<String> readAutoImports(InputStream in) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        TreeSet<String> autoImports = new TreeSet<String>();
        String classname = reader.readLine();
        while (classname != null) {
            autoImports.add(classname);
            classname = reader.readLine();
        }
        return autoImports;
    }

    protected boolean copyImportedClasses(Map<String, File> foundClasses2Sources, Map<String, File> classes2sources) {
        boolean imported = false;
        for (Map.Entry<String, File> foundEntry : foundClasses2Sources.entrySet()) {
            if (foundEntry.getKey().endsWith(".package-info")) {
                File sourceFile = foundEntry.getValue();
                if (sourceFile == null) continue;
                imported |= !classes2sources.containsKey(foundEntry.getKey());
                classes2sources.put(foundEntry.getKey(), sourceFile);
                continue;
            }
            if (this.enunciate.getConfig() == null || this.enunciate.getConfig().getAPIImports() == null || this.enunciate.getConfig().getAPIImports().isEmpty()) continue;
            AntPatternMatcher matcher = new AntPatternMatcher();
            matcher.setPathSeparator(".");
            for (APIImport apiImport : this.enunciate.getConfig().getAPIImports()) {
                String pattern = apiImport.getPattern();
                if (pattern == null) continue;
                if (!classes2sources.containsKey(foundEntry.getKey())) {
                    if (pattern.equals(foundEntry.getKey())) {
                        this.enunciate.debug("Class %s will be imported because it was explicitly listed.", foundEntry.getKey());
                        imported |= !classes2sources.containsKey(foundEntry.getKey());
                        classes2sources.put(foundEntry.getKey(), apiImport.isSeekSource() ? foundEntry.getValue() : null);
                        continue;
                    }
                    if (!matcher.isPattern(pattern) || !matcher.match(pattern, foundEntry.getKey())) continue;
                    this.enunciate.debug("Class %s will be imported because it matches pattern %s.", foundEntry.getKey(), pattern);
                    imported |= !classes2sources.containsKey(foundEntry.getKey());
                    classes2sources.put(foundEntry.getKey(), apiImport.isSeekSource() ? foundEntry.getValue() : null);
                    continue;
                }
                if (foundEntry.getValue() == null) continue;
                imported |= !classes2sources.containsKey(foundEntry.getKey());
                classes2sources.put(foundEntry.getKey(), foundEntry.getValue());
            }
        }
        return imported;
    }
}

