/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.main;

import java.io.File;
import java.io.IOException;
import org.codehaus.enunciate.main.ArtifactType;
import org.codehaus.enunciate.main.BaseArtifact;
import org.codehaus.enunciate.main.Enunciate;

public class FileArtifact
extends BaseArtifact {
    private boolean publicArtifact = true;
    private final File file;
    private String description;
    private ArtifactType artifactType;

    public FileArtifact(String module, String id, File file) {
        super(module, id);
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public void exportTo(File file, Enunciate enunciate) throws IOException {
        if (!this.file.exists()) {
            throw new IOException("Unable to export non-existing file " + this.file.getAbsolutePath());
        }
        if (this.file.isDirectory()) {
            if (file.exists() && file.isDirectory()) {
                enunciate.copyDir(this.file, file, new File[0]);
            } else {
                enunciate.zip(file, this.file);
            }
        } else if (file.exists() && file.isDirectory()) {
            enunciate.copyFile(this.file, new File(file, this.file.getName()));
        } else {
            enunciate.copyFile(this.file, file);
        }
    }

    @Override
    public long getSize() {
        return this.file.length();
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public boolean isPublic() {
        return this.publicArtifact;
    }

    public void setPublic(boolean bundled) {
        this.publicArtifact = bundled;
    }

    public ArtifactType getArtifactType() {
        return this.artifactType;
    }

    public void setArtifactType(ArtifactType artifactType) {
        this.artifactType = artifactType;
    }
}

