/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.main;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.filters.ExpandProperties;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.codehaus.enunciate.EnunciateException;
import org.codehaus.enunciate.config.EnunciateConfiguration;
import org.codehaus.enunciate.main.Enunciate;
import org.codehaus.enunciate.modules.BasicAppModule;
import org.codehaus.enunciate.modules.DeploymentModule;
import org.xml.sax.SAXException;

public class EnunciateTask
extends MatchingTask {
    private boolean verbose = false;
    private boolean debug = false;
    private boolean compileDebugInfo = true;
    private File configFile;
    private File basedir;
    private Path classpath;
    private File generateDir;
    private File compileDir;
    private File buildDir;
    private File packageDir;
    private File scratchDir;
    private File gwtHome;
    private File flexHome;
    private Enunciate.Target target;
    private final ArrayList<Export> exports = new ArrayList();
    private final ArrayList<JavacArgument> javacArguments = new ArrayList();

    public void execute() throws BuildException {
        if (this.basedir == null) {
            throw new BuildException("A base directory must be specified.");
        }
        if (this.gwtHome != null) {
            System.setProperty("gwt.home", this.gwtHome.getAbsolutePath());
        }
        if (this.flexHome != null) {
            System.setProperty("flex.home", this.flexHome.getAbsolutePath());
        }
        DirectoryScanner scanner = this.getDirectoryScanner(this.basedir);
        scanner.scan();
        String[] files = scanner.getIncludedFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = new File(this.basedir, files[i]);
            files[i] = file.getAbsolutePath();
        }
        try {
            EnunciateConfiguration config;
            AntLoggingEnunciate proxy = new AntLoggingEnunciate(files);
            if (this.classpath != null) {
                proxy.setRuntimeClasspath(this.classpath.toString());
                AntClassLoader loader = new AntClassLoader(Enunciate.class.getClassLoader(), this.getProject(), this.classpath, true);
                proxy.setBuildClasspath(loader.getClasspath());
                Thread.currentThread().setContextClassLoader((ClassLoader)loader);
                ArrayList<DeploymentModule> modules = new ArrayList<DeploymentModule>();
                Iterator<DeploymentModule> discoveredModules = ServiceLoader.load(DeploymentModule.class, (ClassLoader)loader).iterator();
                this.getProject().log("Loading modules from the specified classpath....");
                while (discoveredModules.hasNext()) {
                    DeploymentModule discoveredModule = discoveredModules.next();
                    this.getProject().log("Discovered module " + discoveredModule.getName());
                    modules.add(discoveredModule);
                }
                modules.add(new BasicAppModule());
                config = new EnunciateConfiguration(modules);
            } else {
                config = new EnunciateConfiguration();
            }
            proxy.setConfig(config);
            if (this.configFile != null) {
                this.getProject().log("Loading config " + this.configFile);
                ExpandProperties reader = new ExpandProperties((Reader)new FileReader(this.configFile));
                reader.setProject(this.getProject());
                config.load((Reader)reader);
                proxy.setConfigFile(this.configFile);
            }
            if (this.generateDir != null) {
                proxy.setGenerateDir(this.generateDir);
            }
            if (this.compileDir != null) {
                proxy.setCompileDir(this.compileDir);
            }
            if (this.buildDir != null) {
                proxy.setBuildDir(this.buildDir);
            }
            if (this.packageDir != null) {
                proxy.setPackageDir(this.packageDir);
            }
            if (this.scratchDir != null) {
                proxy.setScratchDir(this.scratchDir);
            }
            if (this.target != null) {
                proxy.setTarget(this.target);
            }
            for (Export export : this.exports) {
                proxy.addExport(export.getArtifactId(), export.getDestination());
            }
            for (JavacArgument javacArgument : this.javacArguments) {
                proxy.getConfiguredJavacArguments().add(javacArgument.getArgument());
            }
            proxy.setVerbose(this.verbose);
            proxy.setDebug(this.debug);
            proxy.execute();
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
        catch (EnunciateException e) {
            throw new BuildException((Throwable)e);
        }
        catch (SAXException e) {
            throw new BuildException((Throwable)e);
        }
    }

    public void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    public void setDir(File basedir) {
        this.setBasedir(basedir);
    }

    public void setGenerateDir(File generateDir) {
        this.generateDir = generateDir;
    }

    public void setCompileDir(File compileDir) {
        this.compileDir = compileDir;
    }

    public void setBuildDir(File buildDir) {
        this.buildDir = buildDir;
    }

    public void setPackageDir(File packageDir) {
        this.packageDir = packageDir;
    }

    public void setScratchDir(File scratchDir) {
        this.scratchDir = scratchDir;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setConfigFile(File config) {
        this.configFile = config;
    }

    public void setTarget(String target) {
        this.target = Enunciate.Target.valueOf(target.toUpperCase());
    }

    public void setGwtHome(File gwtHome) {
        this.gwtHome = gwtHome;
    }

    public void setFlexHome(File flexHome) {
        this.flexHome = flexHome;
    }

    public boolean isCompileDebugInfo() {
        return this.compileDebugInfo;
    }

    public void setCompileDebugInfo(boolean compileDebugInfo) {
        this.compileDebugInfo = compileDebugInfo;
    }

    public void setClasspath(Path classpath) {
        if (this.classpath == null) {
            this.classpath = classpath;
        } else {
            this.classpath.append(classpath);
        }
    }

    public Path getClasspath() {
        return this.classpath;
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void setClasspathRef(Reference ref) {
        this.createClasspath().setRefid(ref);
    }

    public Export createExport() {
        Export export = new Export();
        this.exports.add(export);
        return export;
    }

    public JavacArgument createJavacArgument() {
        JavacArgument export = new JavacArgument();
        this.javacArguments.add(export);
        return export;
    }

    private class AntLoggingEnunciate
    extends Enunciate {
        public AntLoggingEnunciate(String[] sourceFiles) {
            super(sourceFiles);
        }

        @Override
        public void debug(String message, Object ... formatArgs) {
            if (EnunciateTask.this.debug) {
                EnunciateTask.this.getProject().log(String.format(message, formatArgs), 3);
            }
        }

        @Override
        public void info(String message, Object ... formatArgs) {
            if (EnunciateTask.this.verbose) {
                EnunciateTask.this.getProject().log(String.format(message, formatArgs), 2);
            }
        }

        @Override
        public void warn(String message, Object ... formatArgs) {
            EnunciateTask.this.getProject().log(String.format(message, formatArgs), 1);
        }

        @Override
        public void error(String message, Object ... formatArgs) {
            EnunciateTask.this.getProject().log(String.format(message, formatArgs), 0);
        }
    }

    public static class JavacArgument {
        private String argument;

        public String getArgument() {
            return this.argument;
        }

        public void setArgument(String argument) {
            this.argument = argument;
        }
    }

    public static class Export {
        private String artifactId;
        private File destination;

        public String getArtifactId() {
            return this.artifactId;
        }

        public void setArtifactId(String artifactId) {
            this.artifactId = artifactId;
        }

        public File getDestination() {
            return this.destination;
        }

        public void setDestination(File destination) {
            this.destination = destination;
        }
    }
}

