/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.main;

import com.sun.mirror.apt.AnnotationProcessorFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URI;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.codehaus.enunciate.EnunciateException;
import org.codehaus.enunciate.apt.EnunciateAnnotationProcessorFactory;
import org.codehaus.enunciate.config.APIImport;
import org.codehaus.enunciate.config.EnunciateConfiguration;
import org.codehaus.enunciate.main.Artifact;
import org.codehaus.enunciate.main.ClasspathHandler;
import org.codehaus.enunciate.main.EnunciateExecutionException;
import org.codehaus.enunciate.main.FileClasspathResource;
import org.codehaus.enunciate.main.ImportedClassesClasspathHandler;
import org.codehaus.enunciate.main.JarClasspathResource;
import org.codehaus.enunciate.main.Main;
import org.codehaus.enunciate.main.PackageInfoClasspathHandler;
import org.codehaus.enunciate.main.webapp.WebAppFragment;
import org.codehaus.enunciate.main.webapp.WebAppFragmentComparator;
import org.codehaus.enunciate.modules.DeploymentModule;
import org.codehaus.enunciate.modules.SpecProviderModule;
import org.codehaus.enunciate.util.AntPatternMatcher;
import org.xml.sax.SAXException;

public class Enunciate {
    private boolean verbose = false;
    private boolean debug = false;
    private boolean javacCheck = false;
    private boolean compileDebugInfo = true;
    private String encoding;
    private File configFile;
    private File generateDir;
    private File compileDir;
    private File buildDir;
    private File packageDir;
    private File scratchDir;
    private String runtimeClasspath;
    private String buildClasspath;
    private EnunciateConfiguration config;
    private Target target = Target.PACKAGE;
    private final HashMap<String, Object> properties = new HashMap();
    private final Set<Artifact> artifacts = new TreeSet<Artifact>();
    private final HashMap<String, File> exports = new HashMap();
    private final List<String> sourceFiles = new ArrayList<String>();
    private final Set<File> additionalSourceRoots = new TreeSet<File>();
    private final Set<WebAppFragment> webAppFragments = new TreeSet<WebAppFragment>(new WebAppFragmentComparator());
    private final List<ClasspathHandler> classpathHandlers = new ArrayList<ClasspathHandler>();
    private final List<String> configuredJavacArguments = new ArrayList<String>();
    private static FileFilter JAVA_FILTER = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.getName().endsWith(".java");
        }
    };
    private static FileFilter EXPORTS_FILTER = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.getName().endsWith(".java");
        }
    };
    private static FileFilter DIR_FILTER = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.isDirectory();
        }
    };

    public static void main(String[] args) throws Exception {
        Main.main(args);
    }

    protected Enunciate() {
    }

    protected void setSourceFiles(String[] sourceFiles) {
        for (String sourceFile : sourceFiles) {
            if (sourceFile.endsWith(".java")) continue;
            throw new IllegalArgumentException("Illegal name of java source file: " + sourceFile + ".  (Must end with \".java\")");
        }
        this.sourceFiles.addAll(Arrays.asList(sourceFiles));
    }

    public Enunciate(String[] sourceFiles) {
        this.setSourceFiles(sourceFiles);
    }

    public Enunciate(String[] sourceFiles, EnunciateConfiguration config) {
        this.setSourceFiles(sourceFiles);
        this.config = config;
    }

    public Enunciate(List<String> sourceFiles) {
        this.setSourceFiles(sourceFiles.toArray(new String[sourceFiles.size()]));
    }

    public Stepper getStepper() throws EnunciateException, IOException {
        return new Stepper();
    }

    public void execute() throws EnunciateException, IOException {
        Stepper stepper = this.getStepper();
        stepper.stepTo(this.target);
        stepper.close();
    }

    protected void doClose() throws EnunciateException, IOException {
        this.info("closing enunciate.", new Object[0]);
        for (DeploymentModule deploymentModule : this.config.getAllModules()) {
            this.debug("closing enunciate module %s.", deploymentModule.getName());
            deploymentModule.close();
        }
        HashSet<String> exportedArtifacts = new HashSet<String>();
        for (Artifact artifact : this.artifacts) {
            String artifactId = artifact.getId();
            Map.Entry<String, File> export = null;
            for (Map.Entry<String, File> entry : this.exports.entrySet()) {
                if (!artifactId.equals(entry.getKey()) && !artifact.getAliases().contains(entry.getKey())) continue;
                export = entry;
            }
            if (export == null) continue;
            File dest = (File)export.getValue();
            this.debug("Exporting artifact %s to %s.", export.getKey(), dest);
            artifact.exportTo(dest, this);
            exportedArtifacts.add(export.getKey());
        }
        for (String export : this.exports.keySet()) {
            if (exportedArtifacts.remove(export)) continue;
            this.warn("WARNING: Unknown artifact '%s'.  Artifact will not be exported.", export);
        }
    }

    protected void doPackage() throws IOException, EnunciateException {
        File packageDir = this.getPackageDir();
        if (packageDir == null) {
            packageDir = this.createTempDir();
            this.debug("No package directory specified, assigned %s.", packageDir);
            this.setPackageDir(packageDir);
        }
        if (packageDir.equals(this.getBuildDir())) {
            throw new EnunciateException("The package output directory cannot be the same as the build directory. (BTW, if you don't specify a package output directory, a suitable temp directory wil be created for you.)");
        }
        for (DeploymentModule deploymentModule : this.config.getAllModules()) {
            if (!deploymentModule.isDisabled()) {
                this.debug("Invoking %s step for module %s", new Object[]{Target.PACKAGE, deploymentModule.getName()});
                deploymentModule.step(Target.PACKAGE);
                continue;
            }
            this.debug("Not invoking %s step for module %s (module is disabled).", new Object[]{Target.PACKAGE, deploymentModule.getName()});
        }
    }

    protected void doBuild() throws IOException, EnunciateException {
        File buildDir = this.getBuildDir();
        if (buildDir == null) {
            buildDir = this.createTempDir();
            this.debug("No build directory specified, assigned %s.", buildDir);
            this.setBuildDir(buildDir);
        }
        if (buildDir.equals(this.getCompileDir())) {
            throw new EnunciateException("The build output directory cannot be the same as the compile directory. (BTW, if you don't specify a build output directory, a suitable temp directory wil be created for you.)");
        }
        for (DeploymentModule deploymentModule : this.config.getAllModules()) {
            if (!deploymentModule.isDisabled()) {
                this.debug("Invoking %s step for module %s", new Object[]{Target.BUILD, deploymentModule.getName()});
                deploymentModule.step(Target.BUILD);
                continue;
            }
            this.debug("Not invoking %s step for module %s (module is disabled).", new Object[]{Target.BUILD, deploymentModule.getName()});
        }
    }

    protected void doCompile() throws IOException, EnunciateException {
        File destdir = this.getCompileDir();
        if (destdir == null) {
            destdir = this.createTempDir();
            this.debug("No compile directory specified, assigned %s.", destdir);
            this.setCompileDir(destdir);
        }
        if (this.compileDir.equals(this.getBuildDir())) {
            throw new EnunciateException("The compile output directory cannot be the same as the generate directory. (BTW, if you don't specify a compile output directory, a suitable temp directory wil be created for you.)");
        }
        for (DeploymentModule deploymentModule : this.config.getAllModules()) {
            if (!deploymentModule.isDisabled()) {
                this.debug("Invoking %s step for module %s", new Object[]{Target.COMPILE, deploymentModule.getName()});
                deploymentModule.step(Target.COMPILE);
                continue;
            }
            this.debug("Not invoking %s step for module %s (module is disabled).", new Object[]{Target.COMPILE, deploymentModule.getName()});
        }
    }

    protected void doGenerate() throws IOException, EnunciateException {
        File genDir = this.getGenerateDir();
        if (genDir == null) {
            genDir = this.createTempDir();
            this.debug("No generate directory specified, assigned %s.", genDir);
            this.setGenerateDir(genDir);
        }
        ArrayList<String> sourceFiles = new ArrayList<String>(Arrays.asList(this.getSourceFiles()));
        ArrayList<String> importClasses = new ArrayList<String>();
        ArrayList<ClasspathHandler> handlers = new ArrayList<ClasspathHandler>();
        ImportedClassesClasspathHandler importedClassesHandler = new ImportedClassesClasspathHandler(this);
        PackageInfoClasspathHandler packageInfoHandler = new PackageInfoClasspathHandler(this);
        handlers.add(importedClassesHandler);
        handlers.add(packageInfoHandler);
        handlers.addAll(this.classpathHandlers);
        this.scanClasspath(handlers);
        Map<String, File> classes2sources = importedClassesHandler.getClassesToSources();
        if (this.config != null && this.config.getAPIImports() != null && !this.config.getAPIImports().isEmpty()) {
            AntPatternMatcher matcher = new AntPatternMatcher();
            matcher.setPathSeparator(".");
            for (APIImport apiImport : this.config.getAPIImports()) {
                if (matcher.isPattern(apiImport.getPattern()) || classes2sources.containsKey(apiImport.getPattern())) continue;
                this.warn("Class %s was explicitly imported, but it was not found on the classpath. We'll try to import it anyway.", apiImport.getPattern());
                classes2sources.put(apiImport.getPattern(), null);
            }
        }
        for (Map.Entry<String, File> importClass : classes2sources.entrySet()) {
            if (importClass.getValue() != null) {
                this.debug("Class %s has a source file that Enunciate will use.", importClass.getKey());
                sourceFiles.add(importClass.getValue().getAbsolutePath());
                continue;
            }
            importClasses.add(importClass.getKey());
        }
        Set<File> packageInfoFiles = packageInfoHandler.getPackageInfoSources();
        for (File packageInfoFile : packageInfoFiles) {
            sourceFiles.add(packageInfoFile.getAbsolutePath());
        }
        if (sourceFiles.isEmpty()) {
            File tempSource = this.createTempFile("EnunciateMockClass", ".java");
            FileWriter writer = new FileWriter(tempSource);
            writer.write(String.format("public class %s {}", tempSource.getName().substring(0, tempSource.getName().length() - 5)));
            writer.flush();
            writer.close();
            sourceFiles.add(tempSource.getAbsolutePath());
        }
        this.invokeApt(sourceFiles.toArray(new String[sourceFiles.size()]), importClasses.toArray(new String[importClasses.size()]));
    }

    protected void scanClasspath(final Collection<ClasspathHandler> classpathHandlers) throws IOException {
        LinkedList<String> classpathToScan = new LinkedList<String>(Arrays.asList(this.getEnunciateRuntimeClasspath().split(File.pathSeparator)));
        while (!classpathToScan.isEmpty()) {
            String pathItem = classpathToScan.removeFirst();
            final File pathFile = new File(pathItem);
            if (pathFile.exists()) {
                String sourceEntry;
                boolean lookupSourceEntry = false;
                if (pathFile.isDirectory()) {
                    for (ClasspathHandler handler : classpathHandlers) {
                        handler.startPathEntry(pathFile);
                    }
                    this.visitFiles(pathFile, null, new FileVisitor(){

                        @Override
                        public void visit(File file) {
                            FileClasspathResource entry = new FileClasspathResource(file, pathFile);
                            for (ClasspathHandler handler : classpathHandlers) {
                                handler.handleResource(entry);
                            }
                        }
                    });
                    for (ClasspathHandler handler : classpathHandlers) {
                        lookupSourceEntry |= handler.endPathEntry(pathFile);
                    }
                } else {
                    String specTitle;
                    JarFile jarFile;
                    try {
                        jarFile = new JarFile(pathFile);
                    }
                    catch (IOException e) {
                        this.warn("%s doesn't appear to be a jar file, so it will be ignored on the classpath.", pathFile);
                        continue;
                    }
                    Manifest manifest = jarFile.getManifest();
                    if (manifest != null && manifest.getMainAttributes() != null && "Java Platform API Specification".equalsIgnoreCase(String.valueOf(specTitle = manifest.getMainAttributes().getValue(Attributes.Name.SPECIFICATION_TITLE)).trim())) {
                        this.debug("Not going to scan %s as it appears to be the SDK runtime.", pathFile);
                        continue;
                    }
                    for (ClasspathHandler handler : classpathHandlers) {
                        handler.startPathEntry(pathFile);
                    }
                    Enumeration<JarEntry> entries = jarFile.entries();
                    while (entries.hasMoreElements()) {
                        JarClasspathResource entry = new JarClasspathResource(jarFile, entries.nextElement());
                        for (ClasspathHandler handler : classpathHandlers) {
                            handler.handleResource(entry);
                        }
                    }
                    for (ClasspathHandler handler : classpathHandlers) {
                        lookupSourceEntry |= handler.endPathEntry(pathFile);
                    }
                }
                if (!lookupSourceEntry || (sourceEntry = this.lookupSourceEntry(pathFile)) == null) continue;
                classpathToScan.add(sourceEntry);
                continue;
            }
            this.debug("Classpath entry %s cannot be scanned because it doesn't exist on the filesystem.", pathItem);
        }
    }

    protected String lookupSourceEntry(File pathEntry) {
        return null;
    }

    protected void doInit() throws EnunciateException, IOException {
        if (this.isJavacCheck()) {
            this.invokeJavac(this.createTempDir(), this.getSourceFiles());
        }
        if (this.config == null) {
            this.config = this.loadConfig();
        }
        this.initModules(this.config.getAllModules());
    }

    protected void initModules(Collection<DeploymentModule> deploymentModules) throws EnunciateException, IOException {
        Iterator it;
        StringBuilder moduleList;
        this.info("initializing enunciate.", new Object[0]);
        TreeSet<String> jaxwsProviderModules = new TreeSet<String>();
        TreeSet<String> jaxrsProviderModules = new TreeSet<String>();
        for (DeploymentModule deploymentModule : deploymentModules) {
            this.debug("initializing enunciate module %s.", deploymentModule.getName());
            deploymentModule.init(this);
            if (deploymentModule.isDisabled() || !(deploymentModule instanceof SpecProviderModule)) continue;
            if (((SpecProviderModule)((Object)deploymentModule)).isJaxwsProvider()) {
                jaxwsProviderModules.add(deploymentModule.getName());
            }
            if (!((SpecProviderModule)((Object)deploymentModule)).isJaxrsProvider()) continue;
            jaxrsProviderModules.add(deploymentModule.getName());
        }
        if (jaxwsProviderModules.size() > 1) {
            moduleList = new StringBuilder();
            it = jaxwsProviderModules.iterator();
            String conjunction = "";
            while (it.hasNext()) {
                String module = (String)it.next();
                if (!it.hasNext()) {
                    conjunction = " and ";
                }
                moduleList.append(conjunction).append(module);
                if (!it.hasNext()) continue;
                conjunction = ", ";
            }
            throw new EnunciateException("There are multiple modules that are configured to be JAX-WS providers: " + moduleList + ". You might have unnecessary modules on the classpath. Anyway, you must disable all but one JAX-WS provider module.");
        }
        if (jaxrsProviderModules.size() > 1) {
            moduleList = new StringBuilder();
            it = jaxrsProviderModules.iterator();
            String conjunction = "";
            while (it.hasNext()) {
                String module = (String)it.next();
                if (!it.hasNext()) {
                    conjunction = " and ";
                }
                moduleList.append(conjunction).append(module);
                if (!it.hasNext()) continue;
                conjunction = ", ";
            }
            throw new EnunciateException("There are multiple modules that are configured to be JAX-RS providers: " + moduleList + ". You might have unnecessary modules on the classpath. Anyway, you must disable all but one JAX-RS provider module.");
        }
    }

    public void info(String message, Object ... formatArgs) {
        if (this.isVerbose()) {
            System.out.println(String.format(message, formatArgs));
        }
    }

    public void debug(String message, Object ... formatArgs) {
        if (this.isDebug()) {
            System.out.println(String.format(message, formatArgs));
        }
    }

    public void warn(String message, Object ... formatArgs) {
        System.out.println(String.format(message, formatArgs));
    }

    public void error(String message, Object ... formatArgs) {
        System.err.println(String.format(message, formatArgs));
    }

    public File createTempDir() throws IOException {
        Double random = Math.random() * 10000.0;
        File scratchDir = this.getScratchDir();
        if (scratchDir != null && !scratchDir.exists()) {
            scratchDir.mkdirs();
        }
        File tempDir = File.createTempFile("enunciate" + random.intValue(), "", scratchDir);
        tempDir.delete();
        tempDir.mkdirs();
        this.debug("Created directory %s", tempDir);
        return tempDir;
    }

    public File createTempFile(String baseName, String suffix) throws IOException {
        Double random = Math.random() * 10000.0;
        File scratchDir = this.getScratchDir();
        if (scratchDir != null && !scratchDir.exists()) {
            scratchDir.mkdirs();
        }
        return File.createTempFile(baseName + random.intValue(), suffix, scratchDir);
    }

    public String[] getSourceFiles() {
        return this.sourceFiles.toArray(new String[this.sourceFiles.size()]);
    }

    protected EnunciateConfiguration loadConfig() throws IOException {
        EnunciateConfiguration config = new EnunciateConfiguration();
        File configFile = this.getConfigFile();
        if (configFile == null) {
            this.info("No config file specified, using defaults....", new Object[0]);
        } else if (!configFile.exists()) {
            this.warn("Config file %s doesn't exist, using defaults....", configFile);
        } else {
            try {
                config.load(configFile);
            }
            catch (SAXException e) {
                throw new IOException("Error parsing enunciate configuration file " + configFile + ": " + e.getMessage());
            }
        }
        return config;
    }

    public Collection<String> getJavaFiles(File basedir) {
        ArrayList<String> files = new ArrayList<String>();
        this.findFiles(basedir, JAVA_FILTER, files);
        return files;
    }

    public Collection<String> getFiles(File basedir, FileFilter filter) {
        ArrayList<String> files = new ArrayList<String>();
        this.findFiles(basedir, filter, files);
        return files;
    }

    private void findFiles(File dir, FileFilter filter, final Collection<String> filenames) {
        this.visitFiles(dir, filter, new FileVisitor(){

            @Override
            public void visit(File file) {
                filenames.add(file.getAbsolutePath());
            }
        });
    }

    private void visitFiles(File dir, FileFilter filter, FileVisitor visitor) {
        File[] dirs;
        File[] files = dir.listFiles(filter);
        if (files != null) {
            for (File file : files) {
                visitor.visit(file);
            }
        }
        if ((dirs = dir.listFiles(DIR_FILTER)) != null) {
            for (File subdir : dirs) {
                this.visitFiles(subdir, filter, visitor);
            }
        }
    }

    public String getEnunciateRuntimeClasspath() {
        String classpath = this.getRuntimeClasspath();
        if (classpath == null) {
            classpath = System.getProperty("java.class.path");
        }
        return classpath;
    }

    public String getEnunciateBuildClasspath() {
        String classpath = this.getBuildClasspath();
        if (classpath == null) {
            classpath = this.getEnunciateRuntimeClasspath();
        }
        return classpath;
    }

    protected void invokeApt(String[] sourceFiles, String ... additionalApiClasses) throws IOException, EnunciateException {
        ArrayList<String> args = new ArrayList<String>();
        String classpath = this.getEnunciateRuntimeClasspath();
        args.add("-cp");
        args.add(classpath);
        if (this.isVerbose()) {
            args.add("-Averbose");
        }
        args.add("-nocompile");
        if (this.getGenerateDir() != null) {
            args.add("-s");
            args.add(this.getGenerateDir().getAbsolutePath());
        }
        args.addAll(Arrays.asList(sourceFiles));
        if (this.isDebug()) {
            StringBuilder message = new StringBuilder("Invoking APT with arguments:");
            for (String arg : args) {
                message.append(' ');
                message.append(arg);
            }
            this.debug(message.toString(), new Object[0]);
        }
        EnunciateAnnotationProcessorFactory apf = new EnunciateAnnotationProcessorFactory(this, additionalApiClasses);
        com.sun.tools.apt.Main.process((AnnotationProcessorFactory)apf, (String[])args.toArray(new String[args.size()]));
        apf.throwAnyErrors();
    }

    public void compileSources(File compileDir) throws EnunciateException {
        ArrayList<String> sources = new ArrayList<String>(Arrays.asList(this.getSourceFiles()));
        for (File sourceRoot : this.getAdditionalSourceRoots()) {
            sources.addAll(this.getJavaFiles(sourceRoot));
        }
        this.invokeJavac(compileDir, sources.toArray(new String[sources.size()]));
    }

    public void invokeJavac(File compileDir, String[] sourceFiles) throws EnunciateException {
        String classpath = this.getEnunciateRuntimeClasspath();
        this.invokeJavac(classpath, compileDir, sourceFiles);
    }

    public void invokeJavac(String classpath, File compileDir, String[] sourceFiles) throws EnunciateException {
        this.invokeJavac(classpath, "1.5", compileDir, new ArrayList<String>(), sourceFiles);
    }

    public void invokeJavac(String classpath, String version, File compileDir, List<String> additionalArgs, String[] sourceFiles) throws EnunciateException {
        if (sourceFiles == null || sourceFiles.length == 0) {
            this.warn("Skipping compile.  No source files specified.", new Object[0]);
            return;
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add("-cp");
        args.add(classpath);
        args.add("-source");
        args.add(version);
        args.add("-target");
        args.add(version);
        if (this.isCompileDebugInfo()) {
            args.add("-g");
        }
        if (this.isDebug()) {
            args.add("-verbose");
        }
        if (this.getEncoding() != null) {
            args.add("-encoding");
            args.add(this.getEncoding());
        }
        args.add("-d");
        args.add(compileDir.getAbsolutePath());
        args.addAll(additionalArgs);
        args.addAll(this.configuredJavacArguments);
        args.addAll(Arrays.asList(sourceFiles));
        if (this.isDebug()) {
            StringBuilder message = new StringBuilder("Invoking Javac with arguments:");
            for (String arg : args) {
                message.append(' ');
                message.append(arg);
            }
            this.debug(message.toString(), new Object[0]);
        }
        compileDir.mkdirs();
        int procCode = com.sun.tools.javac.Main.compile(args.toArray(new String[args.size()]));
        if (procCode != 0) {
            throw new EnunciateException("compile failed.");
        }
    }

    public void copyDir(File from, File to, File ... excludes) throws IOException {
        if (from != null && from.exists()) {
            File[] files = from.listFiles();
            if (!to.exists()) {
                to.mkdirs();
            }
            block0: for (File file : files) {
                if (excludes != null) {
                    for (File exclude : excludes) {
                        if (file.equals(exclude)) continue block0;
                    }
                }
                if (file.isDirectory()) {
                    this.copyDir(file, new File(to, file.getName()), new File[0]);
                    continue;
                }
                this.copyFile(file, new File(to, file.getName()));
            }
        }
    }

    public void extractBase(InputStream baseIn, File toDir) throws IOException {
        ZipInputStream in = new ZipInputStream(baseIn);
        ZipEntry entry = in.getNextEntry();
        while (entry != null) {
            File file = new File(toDir, entry.getName());
            this.debug("Extracting %s to %s.", entry.getName(), file);
            if (entry.isDirectory()) {
                file.mkdirs();
            } else {
                int len;
                FileOutputStream out = new FileOutputStream(file);
                byte[] buffer = new byte[2048];
                while ((len = in.read(buffer)) > 0) {
                    out.write(buffer, 0, len);
                }
                out.close();
            }
            in.closeEntry();
            entry = in.getNextEntry();
        }
    }

    public void copyFile(File src, File fromDir, File toDir) throws IOException {
        URI fromURI = fromDir.toURI();
        URI srcURI = src.toURI();
        URI relativeURI = fromURI.relativize(srcURI);
        File toFile = new File(toDir, relativeURI.getPath());
        this.copyFile(src, toFile);
    }

    public void copyFile(File from, File to) throws IOException {
        FileChannel srcChannel = new FileInputStream(from).getChannel();
        if (!(to = to.getAbsoluteFile()).exists() && to.getParentFile() != null) {
            to.getParentFile().mkdirs();
        }
        this.debug("Copying %s to %s ", from, to);
        FileChannel dstChannel = new FileOutputStream(to, false).getChannel();
        dstChannel.transferFrom(srcChannel, 0L, srcChannel.size());
        srcChannel.close();
        dstChannel.close();
    }

    public void copyResource(String resource, File to) throws IOException {
        URL url = this.getClass().getResource(resource);
        if (url == null) {
            throw new IOException("Request to copy a resource that was not found: " + resource);
        }
        this.copyResource(url, to);
    }

    public void copyResource(URL url, File to) throws IOException {
        int len;
        InputStream stream = url.openStream();
        this.debug("Copying resource %s to %s...", url, to);
        FileOutputStream out = new FileOutputStream(to);
        byte[] buffer = new byte[2048];
        while ((len = stream.read(buffer)) > 0) {
            out.write(buffer, 0, len);
        }
    }

    public void zip(File toFile, File ... dirs) throws IOException {
        if (!toFile.getParentFile().exists()) {
            this.debug("Creating directory %s...", toFile.getParentFile());
            toFile.getParentFile().mkdirs();
        }
        byte[] buffer = new byte[2048];
        ZipOutputStream zipout = new ZipOutputStream(new FileOutputStream(toFile));
        for (File dir : dirs) {
            URI baseURI = dir.toURI();
            this.debug("Adding contents of directory %s to zip file %s...", dir, toFile);
            ArrayList<File> files = new ArrayList<File>();
            this.buildFileList(files, dir);
            for (File file : files) {
                ZipEntry entry = new ZipEntry(baseURI.relativize(file.toURI()).getPath());
                this.debug("Adding entry %s...", entry.getName());
                zipout.putNextEntry(entry);
                if (!file.isDirectory()) {
                    int len;
                    FileInputStream in = new FileInputStream(file);
                    while ((len = in.read(buffer)) > 0) {
                        zipout.write(buffer, 0, len);
                    }
                    in.close();
                }
                zipout.closeEntry();
            }
        }
        zipout.close();
    }

    public File resolvePath(String filePath) {
        File configFile;
        File downloadFile;
        if (File.separatorChar != '/') {
            filePath = filePath.replace('/', File.separatorChar);
        }
        if (!(downloadFile = new File(filePath)).isAbsolute() && (configFile = this.getConfigFile()) != null) {
            downloadFile = new File(configFile.getAbsoluteFile().getParentFile(), filePath);
            this.debug("%s relatived to %s.", filePath, downloadFile.getAbsolutePath());
        }
        return downloadFile;
    }

    public String readFile(File file) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        String line = reader.readLine();
        StringWriter writer = new StringWriter();
        while (line != null) {
            writer.append(line).append('\n');
            line = reader.readLine();
        }
        reader.close();
        return writer.toString();
    }

    public boolean isUpToDate(File sourceFile, File destFile) {
        if (sourceFile == null) {
            throw new IllegalArgumentException();
        }
        if (!sourceFile.isDirectory()) {
            return this.isUpToDate(Arrays.asList(sourceFile), destFile);
        }
        ArrayList<File> sourceFiles = new ArrayList<File>();
        this.buildFileList(sourceFiles, sourceFile);
        return this.isUpToDate(sourceFiles, destFile);
    }

    public boolean isUpToDateWithSources(File destDir) {
        ArrayList<File> sources = new ArrayList<File>();
        for (String source : this.getSourceFiles()) {
            File sourceFile = new File(source);
            if (!sourceFile.exists()) continue;
            sources.add(sourceFile);
        }
        return this.isUpToDate(sources, destDir);
    }

    protected boolean isUpToDate(List<File> sourceFiles, File destFile) {
        List<Object> destFiles;
        if (destFile == null || !destFile.exists()) {
            this.debug("%s is NOT up-to-date because it doesn't exist.", destFile);
            return false;
        }
        if (!destFile.isDirectory()) {
            destFiles = Arrays.asList(destFile);
        } else {
            destFiles = new ArrayList<File>();
            this.buildFileList(destFiles, destFile);
        }
        if (destFiles.isEmpty()) {
            this.debug("%s is NOT up-to-date because it's an empty directory.", destFile);
            return false;
        }
        if (sourceFiles == null || sourceFiles.isEmpty()) {
            this.debug("%s is up-to-date because the list of source files is empty.", destFile);
            return true;
        }
        File youngestSource = this.getYoungest(sourceFiles);
        File oldestDest = this.getOldest(destFiles);
        if (youngestSource.lastModified() < oldestDest.lastModified()) {
            this.debug("%s is up-to-date because its oldest file, %s, is younger than the youngest source file, %s.", destFile, oldestDest, youngestSource);
            return true;
        }
        this.debug("%s is NOT up-to-date because its oldest file, %s, is older than the youngest source file, %s.", destFile, oldestDest, youngestSource);
        return false;
    }

    protected File getYoungest(List<File> files) {
        if (files == null || files.isEmpty()) {
            return null;
        }
        File latest = files.get(0);
        for (File file : files) {
            latest = latest.lastModified() > file.lastModified() ? latest : file;
        }
        return latest;
    }

    protected File getOldest(List<File> files) {
        if (files == null || files.isEmpty()) {
            return null;
        }
        File earliest = files.get(0);
        for (File file : files) {
            earliest = earliest.lastModified() < file.lastModified() ? earliest : file;
        }
        return earliest;
    }

    protected void buildFileList(List<File> list, File ... dirs) {
        for (File dir : dirs) {
            for (File file : dir.listFiles()) {
                if (file.isDirectory()) {
                    this.buildFileList(list, file);
                    continue;
                }
                list.add(file);
            }
        }
    }

    public boolean isVerbose() {
        return this.verbose || this.isDebug();
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public String getVersion() {
        String version = "1.0";
        URL resource = Enunciate.class.getResource("/enunciate.properties");
        if (resource != null) {
            Properties properties = new Properties();
            try {
                properties.load(resource.openStream());
                version = (String)properties.get("version");
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return version;
    }

    public boolean isJavacCheck() {
        return this.javacCheck;
    }

    public void setJavacCheck(boolean javacCheck) {
        this.javacCheck = javacCheck;
    }

    public boolean isCompileDebugInfo() {
        return this.compileDebugInfo;
    }

    public void setCompileDebugInfo(boolean compileDebugInfo) {
        this.compileDebugInfo = compileDebugInfo;
    }

    public File getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(File configFile) {
        this.configFile = configFile;
    }

    public File getCompileDir() {
        return this.compileDir;
    }

    public void setCompileDir(File compileDir) {
        this.compileDir = compileDir;
    }

    public File getBuildDir() {
        return this.buildDir;
    }

    public void setBuildDir(File buildDir) {
        this.buildDir = buildDir;
    }

    public File getPackageDir() {
        return this.packageDir;
    }

    public void setPackageDir(File packageDir) {
        this.packageDir = packageDir;
    }

    public File getScratchDir() {
        return this.scratchDir;
    }

    public void setScratchDir(File scratchDir) {
        this.scratchDir = scratchDir;
    }

    public File getGenerateDir() {
        return this.generateDir;
    }

    public void setGenerateDir(File generateDir) {
        this.generateDir = generateDir;
    }

    public String getRuntimeClasspath() {
        return this.runtimeClasspath;
    }

    public void setRuntimeClasspath(String runtimeClasspath) {
        this.runtimeClasspath = runtimeClasspath;
    }

    public String getBuildClasspath() {
        return this.buildClasspath;
    }

    public void setBuildClasspath(String buildClasspath) {
        this.buildClasspath = buildClasspath;
    }

    public Target getTarget() {
        return this.target;
    }

    public void setTarget(Target target) {
        this.target = target;
    }

    public void setProperty(String property, Object value) {
        this.properties.put(property, value);
    }

    public Set<Artifact> getArtifacts() {
        return Collections.unmodifiableSet(this.artifacts);
    }

    public Artifact findArtifact(String artifactId) {
        if (artifactId != null) {
            for (Artifact artifact : this.artifacts) {
                if (!artifactId.equals(artifact.getId()) && !artifact.getAliases().contains(artifactId)) continue;
                return artifact;
            }
        }
        return null;
    }

    public boolean addArtifact(Artifact artifact) {
        this.debug("Artifact %s added for module %s.", artifact.getId(), artifact.getModule());
        return this.artifacts.add(artifact);
    }

    public void addWebAppFragment(WebAppFragment fragment) {
        this.webAppFragments.add(fragment);
    }

    public void addClasspathHandler(ClasspathHandler handler) {
        this.classpathHandlers.add(handler);
    }

    public Set<WebAppFragment> getWebAppFragments() {
        return Collections.unmodifiableSet(this.webAppFragments);
    }

    public void addAdditionalSourceRoot(File root) {
        this.debug("Adding " + root + " as an additional source root.", new Object[0]);
        this.additionalSourceRoots.add(root);
    }

    public Set<File> getAdditionalSourceRoots() {
        return Collections.unmodifiableSet(this.additionalSourceRoots);
    }

    public void addExport(String artifactId, File destination) {
        this.exports.put(artifactId, destination);
    }

    public Object getProperty(String property) {
        return this.properties.get(property);
    }

    public EnunciateConfiguration getConfig() {
        return this.config;
    }

    public boolean isModuleEnabled(String moduleName) {
        if (this.config != null) {
            for (DeploymentModule module : this.config.getEnabledModules()) {
                if (!module.getName().equals(moduleName)) continue;
                return true;
            }
        }
        return false;
    }

    public List<String> getConfiguredJavacArguments() {
        return this.configuredJavacArguments;
    }

    public void setConfig(EnunciateConfiguration config) {
        this.config = config;
    }

    public final class Stepper {
        private Target nextTarget;

        private Stepper() throws EnunciateException, IOException {
            Enunciate.this.doInit();
            this.nextTarget = Target.GENERATE;
        }

        public Target getNextTarget() {
            return this.nextTarget;
        }

        public synchronized void step() throws EnunciateException, IOException {
            if (this.nextTarget == null) {
                throw new EnunciateExecutionException("All steps completed.");
            }
            Enunciate.this.info("invoking enunciate:%s step...", this.nextTarget.toString().toLowerCase());
            switch (this.nextTarget) {
                case GENERATE: {
                    Enunciate.this.doGenerate();
                    this.nextTarget = Target.COMPILE;
                    break;
                }
                case COMPILE: {
                    Enunciate.this.doCompile();
                    this.nextTarget = Target.BUILD;
                    break;
                }
                case BUILD: {
                    Enunciate.this.doBuild();
                    this.nextTarget = Target.PACKAGE;
                    break;
                }
                case PACKAGE: {
                    Enunciate.this.doPackage();
                    this.nextTarget = null;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown next step: " + (Object)((Object)this.nextTarget));
                }
            }
        }

        public synchronized void stepTo(Target target) throws EnunciateException, IOException {
            if (this.nextTarget == null) {
                throw new EnunciateExecutionException("Cannot step: stepper must be initialized.");
            }
            while (this.nextTarget != null && this.nextTarget.ordinal() <= target.ordinal()) {
                this.step();
            }
        }

        public synchronized void close() throws EnunciateException, IOException {
            Enunciate.this.doClose();
        }
    }

    public static interface FileVisitor {
        public void visit(File var1);
    }

    public static enum Target {
        GENERATE,
        COMPILE,
        BUILD,
        PACKAGE;

    }
}

