/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.main;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.codehaus.enunciate.main.Artifact;
import org.codehaus.enunciate.main.ArtifactBundle;
import org.codehaus.enunciate.main.BaseArtifact;
import org.codehaus.enunciate.main.Enunciate;
import org.codehaus.enunciate.main.FileArtifact;
import org.codehaus.enunciate.main.NamedArtifact;

public class ClientLibraryArtifact
extends BaseArtifact
implements ArtifactBundle,
NamedArtifact {
    private final String name;
    private Date created;
    private String platform;
    private String description;
    private final ArrayList<FileArtifact> artifacts = new ArrayList();
    private long size = -1L;

    public ClientLibraryArtifact(String module, String id, String name) {
        super(module, id);
        this.name = name;
        this.created = new Date();
    }

    @Override
    public void exportTo(File file, Enunciate enunciate) throws IOException {
        File dir = file.exists() && file.isDirectory() ? file : enunciate.createTempDir();
        for (FileArtifact artifact : this.artifacts) {
            enunciate.copyFile(artifact.getFile(), new File(dir, artifact.getFile().getName()));
        }
        if (!file.exists() || !file.isDirectory()) {
            enunciate.zip(file, dir);
            this.size = file.length();
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Collection<? extends Artifact> getArtifacts() {
        return this.artifacts;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    public void addArtifact(FileArtifact artifact) {
        this.artifacts.add(artifact);
    }

    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public String getPlatform() {
        return this.platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

