/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.main;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.codehaus.enunciate.main.Artifact;
import org.codehaus.enunciate.main.ArtifactBundle;
import org.codehaus.enunciate.main.ArtifactDependency;

public abstract class BaseArtifact
implements Artifact {
    private final String module;
    private final String id;
    private final List<ArtifactDependency> dependencies = new ArrayList<ArtifactDependency>();
    private final Set<String> aliases = new TreeSet<String>();

    protected BaseArtifact(String module, String id) {
        this.module = module;
        this.id = id;
    }

    @Override
    public String getModule() {
        return this.module;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public int compareTo(Artifact artifact) {
        String thisId = this.id == null ? "" : this.id;
        String otherId = artifact.getId();
        if (otherId == null) {
            otherId = "";
        }
        return thisId.compareTo(otherId);
    }

    @Override
    public boolean isPublic() {
        return this instanceof ArtifactBundle;
    }

    @Override
    public List<ArtifactDependency> getDependencies() {
        return this.dependencies;
    }

    public void addDependency(ArtifactDependency dependency) {
        this.dependencies.add(dependency);
    }

    public void setDependencies(List<ArtifactDependency> dependencies) {
        this.dependencies.clear();
        this.dependencies.addAll(dependencies);
    }

    @Override
    public Set<String> getAliases() {
        return Collections.unmodifiableSet(this.aliases);
    }

    public void addAlias(String alias) {
        this.aliases.add(alias);
    }
}

