/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.contract.validation;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.enunciate.apt.EnunciateFreemarkerModel;
import org.codehaus.enunciate.contract.validation.ValidationResult;
import org.codehaus.enunciate.contract.validation.Validator;

public class ValidatorChain
implements Validator {
    private final Map<String, Validator> validators = new LinkedHashMap<String, Validator>();

    public List<Validator> getValidators() {
        return Collections.list(Collections.enumeration(this.validators.values()));
    }

    public Map<String, Validator> getValidatorsByLabel() {
        return Collections.unmodifiableMap(this.validators);
    }

    public void addValidator(String label, Validator validator) {
        this.validators.put(label, validator);
    }

    @Override
    public ValidationResult validate(EnunciateFreemarkerModel model) {
        ValidationResult result = new ValidationResult();
        for (Map.Entry<String, Validator> validatorEntry : this.validators.entrySet()) {
            result.aggregate(validatorEntry.getKey(), validatorEntry.getValue().validate(model));
        }
        return result;
    }
}

