/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.contract.validation;

import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.MemberDeclaration;
import com.sun.mirror.declaration.ParameterDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.util.SourcePosition;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.codehaus.enunciate.contract.jaxb.Accessor;
import org.codehaus.enunciate.contract.jaxb.TypeDefinition;
import org.codehaus.enunciate.contract.validation.ValidationMessage;

public class ValidationResult {
    private String label;
    private final List<ValidationMessage> errors = new ArrayList<ValidationMessage>();
    private final List<ValidationMessage> warnings = new ArrayList<ValidationMessage>();

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public void addError(SourcePosition position, String text) {
        this.errors.add(new ValidationMessage(position, text));
    }

    public void addError(Declaration declaration, String text) {
        if (declaration == null) {
            this.errors.add(new ValidationMessage(null, text));
        } else {
            if (declaration instanceof TypeDefinition) {
                text = this.appendReferenceInformation(text, ((TypeDefinition)declaration).getReferencedFrom());
            } else if (declaration instanceof Accessor) {
                text = this.appendReferenceInformation(text, ((Accessor)declaration).getReferencedFrom());
            }
            if (declaration.getPosition() != null) {
                this.errors.add(new ValidationMessage(declaration.getPosition(), text));
            } else {
                this.errors.add(new ValidationMessage(null, this.toString(declaration) + ": " + text));
            }
        }
    }

    protected String appendReferenceInformation(String text, Set<String> referencedFrom) {
        if (referencedFrom.isEmpty()) {
            return text;
        }
        StringBuilder builder = new StringBuilder(text).append(" (This was added to the model from ");
        Iterator<String> locations = referencedFrom.iterator();
        while (locations.hasNext()) {
            String location = locations.next();
            builder.append(location);
            if (!locations.hasNext()) continue;
            builder.append(", and from ");
        }
        builder.append(')');
        return builder.toString();
    }

    public List<ValidationMessage> getErrors() {
        return this.errors;
    }

    public boolean hasWarnings() {
        return !this.warnings.isEmpty();
    }

    public void addWarning(SourcePosition position, String text) {
        this.warnings.add(new ValidationMessage(position, text));
    }

    public void addWarning(Declaration declaration, String text) {
        if (declaration == null) {
            this.errors.add(new ValidationMessage(null, text));
        } else if (declaration.getPosition() != null) {
            this.warnings.add(new ValidationMessage(declaration.getPosition(), text));
        } else {
            this.warnings.add(new ValidationMessage(null, this.toString(declaration) + ": " + text));
        }
    }

    public List<ValidationMessage> getWarnings() {
        return this.warnings;
    }

    public void aggregate(ValidationResult result) {
        this.errors.addAll(result.errors);
        this.warnings.addAll(result.warnings);
    }

    public void aggregate(String label, ValidationResult result) {
        for (ValidationMessage error : result.errors) {
            error.setLabel(label);
            this.errors.add(error);
        }
        for (ValidationMessage warning : result.warnings) {
            warning.setLabel(label);
            this.warnings.add(warning);
        }
    }

    private String toString(Declaration declaration) {
        StringBuilder builder = new StringBuilder();
        if (declaration instanceof TypeDeclaration) {
            builder.append(((TypeDeclaration)declaration).getQualifiedName());
        } else if (declaration instanceof MemberDeclaration) {
            if (((MemberDeclaration)declaration).getDeclaringType() != null) {
                builder.append(((MemberDeclaration)declaration).getDeclaringType().getQualifiedName());
                builder.append('.');
            }
            builder.append(declaration.getSimpleName());
        } else if (declaration instanceof ParameterDeclaration) {
            builder.append("Parameter ").append(declaration.getSimpleName());
        } else {
            builder.append(declaration.getSimpleName());
        }
        return builder.toString();
    }
}

