/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.contract.validation;

import com.sun.mirror.declaration.Declaration;
import org.codehaus.enunciate.contract.jaxb.ComplexTypeDefinition;
import org.codehaus.enunciate.contract.jaxb.EnumTypeDefinition;
import org.codehaus.enunciate.contract.jaxb.RootElementDeclaration;
import org.codehaus.enunciate.contract.jaxb.SimpleTypeDefinition;
import org.codehaus.enunciate.contract.jaxb.TypeDefinition;
import org.codehaus.enunciate.contract.jaxws.EndpointInterface;
import org.codehaus.enunciate.contract.jaxws.WebMessage;
import org.codehaus.enunciate.contract.jaxws.WebMessagePart;
import org.codehaus.enunciate.contract.jaxws.WebMethod;
import org.codehaus.enunciate.contract.validation.BaseValidator;
import org.codehaus.enunciate.contract.validation.ValidationResult;

public class EmptyNamespaceValidator
extends BaseValidator {
    @Override
    public ValidationResult validateEndpointInterface(EndpointInterface ei) {
        ValidationResult result = new ValidationResult();
        String ns = ei.getTargetNamespace();
        if (ns == null || "".equals(ns)) {
            result.addError((Declaration)ei, "Endpoint interface is in the empty namespace.");
        }
        for (WebMethod webMethod : ei.getWebMethods()) {
            for (WebMessage message : webMethod.getMessages()) {
                for (WebMessagePart messagePart : message.getParts()) {
                    if (!messagePart.isImplicitSchemaElement() || (ns = messagePart.getParticleQName().getNamespaceURI()) != null && !"".equals(ns)) continue;
                    result.addError((Declaration)webMethod, "A particle for a message part (message: " + message.getMessageName() + ", part: " + messagePart.getPartName() + ") of this web method is in the empty namespace.");
                }
            }
        }
        return result;
    }

    @Override
    public ValidationResult validateComplexType(ComplexTypeDefinition complexType) {
        return this.validateType(complexType);
    }

    @Override
    public ValidationResult validateSimpleType(SimpleTypeDefinition simpleType) {
        return this.validateType(simpleType);
    }

    @Override
    public ValidationResult validateEnumType(EnumTypeDefinition enumType) {
        return this.validateType(enumType);
    }

    public ValidationResult validateType(TypeDefinition typeDefinition) {
        ValidationResult result = new ValidationResult();
        String ns = typeDefinition.getNamespace();
        if (ns == null || "".equals(ns)) {
            result.addError((Declaration)typeDefinition, "Type is defined in the empty namespace.");
        }
        return result;
    }

    @Override
    public ValidationResult validateRootElement(RootElementDeclaration rootElementDeclaration) {
        ValidationResult result = new ValidationResult();
        String ns = rootElementDeclaration.getNamespace();
        if (ns == null || "".equals(ns)) {
            result.addError(rootElementDeclaration, "Element is defined in the empty namespace.");
        }
        return result;
    }
}

