/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.contract.validation;

import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.ConstructorDeclaration;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.EnumDeclaration;
import com.sun.mirror.declaration.FieldDeclaration;
import com.sun.mirror.declaration.InterfaceDeclaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.Modifier;
import com.sun.mirror.declaration.ParameterDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.type.DeclaredType;
import com.sun.mirror.type.EnumType;
import com.sun.mirror.type.InterfaceType;
import com.sun.mirror.type.MirroredTypeException;
import com.sun.mirror.type.PrimitiveType;
import com.sun.mirror.type.TypeMirror;
import com.sun.mirror.type.VoidType;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.ws.rs.CookieParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlSchemaTypes;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import javax.xml.namespace.QName;
import net.sf.jelly.apt.decorations.TypeMirrorDecorator;
import net.sf.jelly.apt.decorations.declaration.DecoratedMethodDeclaration;
import net.sf.jelly.apt.decorations.declaration.PropertyDeclaration;
import net.sf.jelly.apt.decorations.type.DecoratedDeclaredType;
import net.sf.jelly.apt.decorations.type.DecoratedTypeMirror;
import org.codehaus.enunciate.apt.EnunciateFreemarkerModel;
import org.codehaus.enunciate.contract.jaxb.Accessor;
import org.codehaus.enunciate.contract.jaxb.Attribute;
import org.codehaus.enunciate.contract.jaxb.ComplexTypeDefinition;
import org.codehaus.enunciate.contract.jaxb.Element;
import org.codehaus.enunciate.contract.jaxb.ElementRef;
import org.codehaus.enunciate.contract.jaxb.EnumTypeDefinition;
import org.codehaus.enunciate.contract.jaxb.RootElementDeclaration;
import org.codehaus.enunciate.contract.jaxb.Schema;
import org.codehaus.enunciate.contract.jaxb.SimpleTypeDefinition;
import org.codehaus.enunciate.contract.jaxb.TypeDefinition;
import org.codehaus.enunciate.contract.jaxb.Value;
import org.codehaus.enunciate.contract.jaxb.types.KnownXmlType;
import org.codehaus.enunciate.contract.jaxb.types.XmlClassType;
import org.codehaus.enunciate.contract.jaxrs.ResourceEntityParameter;
import org.codehaus.enunciate.contract.jaxrs.ResourceMethod;
import org.codehaus.enunciate.contract.jaxrs.ResourceParameter;
import org.codehaus.enunciate.contract.jaxrs.RootResource;
import org.codehaus.enunciate.contract.jaxws.EndpointImplementation;
import org.codehaus.enunciate.contract.jaxws.EndpointInterface;
import org.codehaus.enunciate.contract.jaxws.RequestWrapper;
import org.codehaus.enunciate.contract.jaxws.ResponseWrapper;
import org.codehaus.enunciate.contract.jaxws.WebMessage;
import org.codehaus.enunciate.contract.jaxws.WebMessagePart;
import org.codehaus.enunciate.contract.jaxws.WebParam;
import org.codehaus.enunciate.contract.jaxws.WebResult;
import org.codehaus.enunciate.contract.validation.BaseValidator;
import org.codehaus.enunciate.contract.validation.ConfigurableRules;
import org.codehaus.enunciate.contract.validation.ValidationException;
import org.codehaus.enunciate.contract.validation.ValidationResult;
import org.codehaus.enunciate.qname.XmlQNameEnum;

public class DefaultValidator
extends BaseValidator
implements ConfigurableRules {
    private final Set<String> disabledRules = new TreeSet<String>();

    @Override
    public void disableRules(Set<String> ruleIds) {
        if (ruleIds != null) {
            this.disabledRules.addAll(ruleIds);
        }
    }

    @Override
    public ValidationResult validate(EnunciateFreemarkerModel model) {
        ValidationResult result = super.validate(model);
        TreeSet<String> uniqueContentTypeIds = new TreeSet<String>();
        for (String contentType : model.getContentTypesToIds().keySet()) {
            String id = model.getContentTypesToIds().get(contentType);
            if (uniqueContentTypeIds.add(id)) continue;
            StringBuilder builder = new StringBuilder("All content types must have unique ids.  The id '").append(id).append("' is assigned to the following content types: '").append(contentType).append("'");
            for (String ct : model.getContentTypesToIds().keySet()) {
                if (contentType.equals(ct) || !id.equals(model.getContentTypesToIds().get(ct))) continue;
                builder.append(", '").append(ct).append("'");
            }
            builder.append(". Please use the Enunciate configuration to specify a unique id for each content type.");
            result.addError((Declaration)null, builder.toString());
            break;
        }
        return result;
    }

    @Override
    public ValidationResult validateEndpointInterface(EndpointInterface ei) {
        Declaration delegate;
        WebService ws;
        ValidationResult result = new ValidationResult();
        if (ei.getEndpointImplementations() == null || ei.getEndpointImplementations().isEmpty()) {
            result.addWarning((Declaration)ei, "Endpoint interface has no implementations!  It will NOT be deployed...");
        }
        if ((ws = (WebService)(delegate = ei.getDelegate()).getAnnotation(WebService.class)) == null) {
            result.addError(delegate, "Not an endpoint interface: no WebService annotation");
        } else {
            if ((ei.getPackage() == null || "".equals(ei.getPackage().getQualifiedName())) && ei.getTargetNamespace() == null) {
                result.addError(delegate, "An endpoint interface in no package must specify a target namespace.");
            }
            if (ws.endpointInterface() != null && !"".equals(ws.endpointInterface())) {
                result.addError(delegate, "Not an endpoint interface (it references another endpoint interface).");
            }
        }
        if (delegate instanceof AnnotationTypeDeclaration) {
            result.addError(delegate, "Annotation types are not valid endpoint interfaces.");
        }
        if (delegate instanceof EnumDeclaration) {
            result.addError(delegate, "Enums cannot be endpoint interfaces.");
        }
        org.codehaus.enunciate.contract.jaxws.WebMethod styleHead = null;
        TreeSet<org.codehaus.enunciate.contract.jaxws.WebMethod> uniquelyNamedWebMethods = new TreeSet<org.codehaus.enunciate.contract.jaxws.WebMethod>();
        for (org.codehaus.enunciate.contract.jaxws.WebMethod webMethod : ei.getWebMethods()) {
            if (styleHead == null) {
                styleHead = webMethod;
            } else if (styleHead.getSoapBindingStyle() != webMethod.getSoapBindingStyle()) {
                result.addError((Declaration)webMethod, "Mixed-style endpoint interfaces break conformity to the WS-I Basic Profile.  The '" + webMethod.getSimpleName() + "' method has " + webMethod.getSoapBindingStyle() + " style, which isn't the same as the " + styleHead.getSimpleName() + " method  on the endpoint which has '" + styleHead.getSoapBindingStyle() + "' style.");
            }
            if (!uniquelyNamedWebMethods.add(webMethod)) {
                result.addError((Declaration)webMethod, "Web methods must have unique operation names.  Use annotations to disambiguate.");
            }
            result.aggregate(this.validateWebMethod(webMethod));
        }
        for (EndpointImplementation implementation : ei.getEndpointImplementations()) {
            result.aggregate(this.validateEndpointImplementation(implementation));
        }
        if (ei.getSoapUse() == SOAPBinding.Use.ENCODED) {
            result.addError((Declaration)ei, "Enunciate does not support encoded-use web services.");
        }
        return result;
    }

    public ValidationResult validateEndpointImplementation(EndpointImplementation impl) {
        ValidationResult result = new ValidationResult();
        Declaration delegate = impl.getDelegate();
        WebService ws = (WebService)delegate.getAnnotation(WebService.class);
        if (ws == null) {
            result.addError(delegate, "Not an endpoint implementation (no WebService annotation).");
        }
        if (delegate instanceof EnumDeclaration) {
            result.addError(delegate, "An enum cannot be an endpoint implementation.");
        }
        if (!this.isAssignable((TypeDeclaration)delegate, (TypeDeclaration)impl.getEndpointInterface().getDelegate())) {
            result.addError(delegate, "Class does not implement its endpoint interface!");
        }
        return result;
    }

    protected boolean isAssignable(TypeDeclaration declaration1, TypeDeclaration declaration2) {
        String iffqn = declaration2.getQualifiedName();
        if (declaration1.getQualifiedName().equals(iffqn)) {
            return true;
        }
        Collection superinterfaces = declaration1.getSuperinterfaces();
        for (InterfaceType interfaceType : superinterfaces) {
            InterfaceDeclaration declaration = interfaceType.getDeclaration();
            if (declaration == null || !this.isAssignable((TypeDeclaration)declaration, declaration2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ValidationResult validateRootResources(List<RootResource> rootResources) {
        ValidationResult result = new ValidationResult();
        for (RootResource rootResource : rootResources) {
            for (FieldDeclaration field : rootResource.getFields()) {
                if (!this.isSuppliableByJAXRS((Declaration)field) || field.getAnnotation(Context.class) != null || this.isConvertableToStringByJAXRS(field.getType())) continue;
                result.addError((Declaration)field, "Unsupported JAX-RS type.");
            }
            for (PropertyDeclaration prop : rootResource.getProperties()) {
                if (!this.isSuppliableByJAXRS((Declaration)prop) || prop.getAnnotation(Context.class) != null || this.isConvertableToStringByJAXRS(prop.getPropertyType())) continue;
                result.addError((Declaration)prop.getSetter(), "Unsupported JAX-RS type.");
            }
            for (ResourceMethod resourceMethod : rootResource.getResourceMethods(true)) {
                DecoratedTypeMirror decorated;
                if (resourceMethod.getDeclaredEntityParameters().size() > 1) {
                    result.addError((Declaration)resourceMethod, "No more than one JAX-RS entity parameter is allowed (all other parameters must be annotated with one of the JAX-RS resource parameter annotations).");
                }
                int formParamCount = 0;
                for (ResourceParameter resourceParameter : resourceMethod.getResourceParameters()) {
                    if (!resourceParameter.isFormParam()) continue;
                    ++formParamCount;
                }
                ResourceEntityParameter entityParam = resourceMethod.getEntityParameter();
                if (entityParam == null || formParamCount <= 0 || (decorated = (DecoratedTypeMirror)TypeMirrorDecorator.decorate((TypeMirror)entityParam.getType())).isInstanceOf(MultivaluedMap.class.getName())) continue;
                result.addError((Declaration)entityParam, "An entity parameter must be of type MultivaluedMap<String, String> if there is another parameter annotated with @FormParam.");
            }
        }
        return result;
    }

    protected boolean isConvertableToStringByJAXRS(TypeMirror type) {
        TypeDeclaration declaration;
        DecoratedTypeMirror decorated = (DecoratedTypeMirror)TypeMirrorDecorator.decorate((TypeMirror)type);
        if (decorated.isInstanceOf("java.util.List") || decorated.isInstanceOf("java.util.Set") || decorated.isInstanceOf("java.util.SortedSet")) {
            Collection typeArgs = ((DeclaredType)type).getActualTypeArguments();
            if (typeArgs != null && typeArgs.size() == 1) {
                type = (TypeMirror)typeArgs.iterator().next();
            } else {
                return false;
            }
        }
        if (type instanceof PrimitiveType) {
            return true;
        }
        if (this.isString(type)) {
            return true;
        }
        if (type instanceof DeclaredType && (declaration = ((DeclaredType)type).getDeclaration()) != null) {
            if (declaration instanceof ClassDeclaration) {
                for (ConstructorDeclaration constructor : ((ClassDeclaration)declaration).getConstructors()) {
                    if (constructor.getParameters().size() != 1 || !this.isString(((ParameterDeclaration)constructor.getParameters().iterator().next()).getType())) continue;
                    return true;
                }
            }
            for (MethodDeclaration method : declaration.getMethods()) {
                if (!method.getModifiers().contains(Modifier.STATIC) || !"valueOf".equals(method.getSimpleName()) || !this.isString(method.getReturnType())) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isString(TypeMirror type) {
        return type != null && type instanceof DeclaredType && ((DeclaredType)type).getDeclaration() != null && String.class.getName().equals(((DeclaredType)type).getDeclaration().getQualifiedName());
    }

    protected boolean isSuppliableByJAXRS(Declaration declaration) {
        return declaration.getAnnotation(MatrixParam.class) != null || declaration.getAnnotation(PathParam.class) != null || declaration.getAnnotation(QueryParam.class) != null || declaration.getAnnotation(CookieParam.class) != null || declaration.getAnnotation(HeaderParam.class) != null || declaration.getAnnotation(Context.class) != null;
    }

    public ValidationResult validateWebMethod(org.codehaus.enunciate.contract.jaxws.WebMethod webMethod) {
        WebMethod annotation;
        ValidationResult result = new ValidationResult();
        if (!webMethod.getModifiers().contains(Modifier.PUBLIC)) {
            result.addError((Declaration)webMethod, "A non-public method cannot be a web method.");
        }
        if ((annotation = (WebMethod)webMethod.getAnnotation(WebMethod.class)) != null && annotation.exclude()) {
            result.addError((Declaration)webMethod, "A method marked as excluded cannot be a web method.");
        }
        if (webMethod.getSoapUse() == SOAPBinding.Use.ENCODED) {
            result.addError((Declaration)webMethod, "Enunciate doesn't support ENCODED-use web methods.");
        }
        ArrayList<WebMessage> inParams = new ArrayList<WebMessage>();
        ArrayList<WebMessage> outParams = new ArrayList<WebMessage>();
        boolean oneway = webMethod.isOneWay();
        SOAPBinding.ParameterStyle parameterStyle = webMethod.getSoapParameterStyle();
        SOAPBinding.Style soapBindingStyle = webMethod.getSoapBindingStyle();
        if (oneway && !(webMethod.getReturnType() instanceof VoidType)) {
            result.addError((Declaration)webMethod, "A one-way method must have a void return type.");
        }
        if (oneway && webMethod.getThrownTypes() != null && !webMethod.getThrownTypes().isEmpty()) {
            result.addError((Declaration)webMethod, "A one-way method can't throw any exceptions.");
        }
        if (parameterStyle == SOAPBinding.ParameterStyle.BARE && soapBindingStyle != SOAPBinding.Style.DOCUMENT) {
            result.addError((Declaration)webMethod, "A BARE web method must have a DOCUMENT binding style.");
        }
        for (WebParam webParam : webMethod.getWebParameters()) {
            if (webParam.getMode() != WebParam.Mode.INOUT || webParam.isHolder()) continue;
            result.addError((Declaration)webParam, "An INOUT parameter must have a type of javax.xml.ws.Holder");
        }
        for (WebMessage webMessage : webMethod.getMessages()) {
            String description;
            DecoratedTypeMirror type;
            if (oneway && webMessage.isOutput()) {
                result.addError((Declaration)webMethod, "A one-way method cannot have any 'out' messages (i.e. non-void return values, thrown exceptions, out parameters, or in/out parameters).");
            }
            if (!webMessage.isHeader()) {
                if (webMessage.isInput()) {
                    inParams.add(webMessage);
                }
                if (webMessage.isOutput()) {
                    outParams.add(webMessage);
                }
            } else if (webMessage instanceof WebResult) {
                WebResult webResult = (WebResult)webMessage;
                if ("".equals(webResult.getElementName())) {
                    result.addError((Declaration)webResult.getWebMethod(), "A web result that is a header must specify a name with the @WebResult annotation.");
                }
                if ((type = (DecoratedTypeMirror)webResult.getType()).isCollection() || type.isArray()) {
                    description = type.isCollection() ? "an instance of java.util.Collection" : "an array";
                    result.addWarning((Declaration)webMethod, "The header return value that is " + description + " may not (de)serialize " + "correctly.  The spec is unclear as to how this should be handled.");
                }
            } else {
                WebParam webParam = (WebParam)webMessage;
                if ("".equals(webParam.getElementName())) {
                    result.addError((Declaration)webParam, "A header parameter must specify a name using the @WebParam annotation.");
                }
                if ((type = (DecoratedTypeMirror)webParam.getType()).isCollection() || type.isArray()) {
                    description = type.isCollection() ? "an instance of java.util.Collection" : "an array";
                    result.addWarning((Declaration)webParam, "The header parameter that is " + description + " may not (de)serialize correctly.  " + "The spec is unclear as to how this should be handled.");
                }
            }
            if (parameterStyle == SOAPBinding.ParameterStyle.BARE) {
                if (webMessage instanceof WebParam) {
                    DecoratedTypeMirror paramType = (DecoratedTypeMirror)((WebParam)webMessage).getType();
                    if (!paramType.isArray()) continue;
                    result.addError((Declaration)webMethod, "A BARE web method must not have an array as a parameter.");
                    continue;
                }
                if (webMessage instanceof RequestWrapper) {
                    result.addError((Declaration)webMethod, "A BARE web method shouldn't have a request wrapper.");
                    continue;
                }
                if (!(webMessage instanceof ResponseWrapper)) continue;
                result.addError((Declaration)webMethod, "A BARE web method shouldn't have a response wrapper.");
                continue;
            }
            if (soapBindingStyle != SOAPBinding.Style.RPC) continue;
            Collection<WebMessagePart> parts = webMessage.getParts();
            for (WebMessagePart part : parts) {
                WebParam webParam;
                DecoratedTypeMirror paramType;
                if (!(part instanceof WebParam) || !(paramType = (DecoratedTypeMirror)(webParam = (WebParam)part).getType()).isCollection() && !paramType.isArray()) continue;
                String description2 = paramType.isCollection() ? "An instance of java.util.Collection" : "An array";
                result.addWarning((Declaration)webParam, description2 + " as an RPC-style web message part may " + "not be (de)serialized as you expect.  The spec is unclear as to how this should be handled.");
            }
        }
        if (parameterStyle == SOAPBinding.ParameterStyle.BARE) {
            if (inParams.size() > 1) {
                result.addError((Declaration)webMethod, "A BARE web method must not have more than one 'in' parameter.");
            } else if (inParams.isEmpty()) {
                result.addWarning((Declaration)webMethod, "A BARE web method should have one IN parameter.");
            }
            if (outParams.size() > 1) {
                result.addError((Declaration)webMethod, "A BARE web method must not have more than one 'out' message (i.e. non-void return values, out parameters, or in/out parameters).");
            } else if (outParams.isEmpty() && !webMethod.isOneWay()) {
                result.addError((Declaration)webMethod, "A BARE web method that is not one-way must have one OUT parameter.");
            }
        }
        return result;
    }

    @Override
    public ValidationResult validateComplexType(ComplexTypeDefinition complexType) {
        ValidationResult result = this.validateTypeDefinition(complexType);
        try {
            complexType.getBaseType();
        }
        catch (ValidationException e) {
            result.addError((Declaration)complexType, e.getMessage());
        }
        if (complexType.getValue() != null) {
            if (!complexType.isBaseObject()) {
                result.addError((Declaration)complexType, "A type with an @XmlValue must not extend another object (other than java.lang.Object).");
            }
            if (!complexType.getElements().isEmpty()) {
                result.addError((Declaration)complexType, "A type definition cannot have both an xml value and elements.");
            } else if (complexType.getAttributes().isEmpty()) {
                result.addError((Declaration)complexType, "Should be a simple type, not a complex type.");
            }
        }
        return result;
    }

    @Override
    public ValidationResult validateSimpleType(SimpleTypeDefinition simpleType) {
        ValidationResult result = this.validateTypeDefinition(simpleType);
        try {
            org.codehaus.enunciate.contract.jaxb.types.XmlType baseType = simpleType.getBaseType();
            if (baseType == null) {
                result.addError((Declaration)simpleType, "No base type specified.");
            } else if (baseType instanceof XmlClassType && ((XmlClassType)baseType).getTypeDefinition() instanceof ComplexTypeDefinition) {
                result.addError((Declaration)simpleType, "A simple type must have a simple base type. " + new QName(baseType.getNamespace(), baseType.getName()) + " is a complex type.");
            }
        }
        catch (ValidationException e) {
            result.addError((Declaration)simpleType, e.getMessage());
        }
        return result;
    }

    @Override
    public ValidationResult validateEnumType(EnumTypeDefinition enumType) {
        return this.validateSimpleType(enumType);
    }

    public ValidationResult validateTypeDefinition(TypeDefinition typeDef) {
        boolean needsNoArgConstructor;
        ValidationResult result = this.validatePackage(typeDef.getSchema());
        if (this.isXmlTransient((Declaration)typeDef)) {
            result.addError((Declaration)typeDef, "XmlTransient type definition.");
        }
        XmlType xmlType = (XmlType)typeDef.getAnnotation(XmlType.class);
        if (typeDef.getDeclaringType() != null && !typeDef.getModifiers().contains(Modifier.STATIC)) {
            result.addError((Declaration)typeDef, "An xml type must be either a top-level class or a nested static class.");
        }
        boolean bl = needsNoArgConstructor = !(typeDef instanceof EnumTypeDefinition) && !this.disabledRules.contains("jaxb.noarg.constructor");
        if (needsNoArgConstructor && xmlType != null) {
            String factoryClassFqn = null;
            try {
                Class factoryClass = xmlType.factoryClass();
                if (factoryClass != XmlType.DEFAULT.class) {
                    factoryClassFqn = factoryClass.getName();
                }
            }
            catch (MirroredTypeException e) {
                TypeMirror typeMirror = e.getTypeMirror();
                if (!(typeMirror instanceof DeclaredType)) {
                    result.addError((Declaration)typeDef, "Unsupported factory class: " + typeMirror);
                }
                factoryClassFqn = ((DeclaredType)typeMirror).getDeclaration().getQualifiedName();
            }
            String factoryMethod = xmlType.factoryMethod();
            if (factoryClassFqn != null || !"".equals(factoryMethod)) {
                needsNoArgConstructor = false;
                TypeDeclaration factoryDeclaration = net.sf.jelly.apt.Context.getCurrentEnvironment().getTypeDeclaration(factoryClassFqn);
                Collection methods = factoryDeclaration.getMethods();
                boolean methodFound = false;
                for (MethodDeclaration method : methods) {
                    if (!method.getSimpleName().equals(factoryMethod) || method.getParameters().size() != 0 || !method.getModifiers().contains(Modifier.STATIC)) continue;
                    methodFound = true;
                    break;
                }
                if (!methodFound) {
                    result.addError((Declaration)typeDef, "A static, parameterless factory method named " + factoryMethod + " was not found on " + factoryClassFqn);
                }
            } else if (typeDef.getAnnotation(XmlJavaTypeAdapter.class) != null) {
                needsNoArgConstructor = false;
            }
            String[] propOrder = xmlType.propOrder();
            if (propOrder.length <= 0 || !"".equals(propOrder[0])) {
                // empty if block
            }
        }
        if (needsNoArgConstructor) {
            boolean hasNoArgConstructor = false;
            Collection constructors = typeDef.getConstructors();
            for (ConstructorDeclaration constructor : constructors) {
                if (constructor.getParameters().size() != 0) continue;
                hasNoArgConstructor = true;
                break;
            }
            if (!hasNoArgConstructor) {
                result.addError((Declaration)typeDef, "A TypeDefinition must have a no-arg constructor or be annotated with a factory method.");
            }
        }
        HashMap<QName, Attribute> attributeNames = new HashMap<QName, Attribute>();
        for (Attribute attribute : typeDef.getAttributes()) {
            QName attributeQName = new QName(attribute.getNamespace(), attribute.getName());
            Attribute sameName = attributeNames.put(attributeQName, attribute);
            if (sameName != null) {
                result.addError((Declaration)attribute, "Attribute has the same name (" + attributeQName + ") as " + sameName.getPosition() + ".  Please use annotations to disambiguate.");
            }
            result.aggregate(this.validateAttribute(attribute));
        }
        if (typeDef.getValue() != null) {
            result.aggregate(this.validateValue(typeDef.getValue()));
            if (!typeDef.getElements().isEmpty()) {
                result.addError((Declaration)typeDef.getValue(), "A type definition cannot have both an xml value and child element(s).");
            }
        } else {
            HashMap elementNames = new HashMap();
            for (Element element : typeDef.getElements()) {
                for (Element element2 : element.getChoices()) {
                    QName choiceQName;
                    Element sameName;
                    HashMap<QName, Element> choiceNames;
                    QName wrapperQName = null;
                    if (element2.isWrapped()) {
                        wrapperQName = new QName(element2.getWrapperNamespace(), element2.getWrapperName());
                    }
                    if ((choiceNames = (HashMap<QName, Element>)elementNames.get(wrapperQName)) == null) {
                        choiceNames = new HashMap<QName, Element>();
                        elementNames.put(wrapperQName, choiceNames);
                    }
                    if ((sameName = choiceNames.put(choiceQName = new QName(element2.getNamespace(), element2.getName()), element2)) != null) {
                        result.addError((Declaration)element2, "Element (or element choice) has the same name (" + choiceQName + ") as " + sameName.getPosition() + ".  Please use annotations to disambiguate.");
                    } else if (wrapperQName == null && elementNames.containsKey(choiceQName)) {
                        result.addError((Declaration)element2, "Element (or element choice) has the same name (" + choiceQName + ") as element wrapper for " + ((Element)((HashMap)elementNames.get(choiceQName)).values().iterator().next()).getPosition() + ".  Please use annotations to disambiguate.");
                    } else if (wrapperQName != null && elementNames.containsKey(null) && ((HashMap)elementNames.get(null)).containsKey(wrapperQName)) {
                        result.addError((Declaration)element, "Wrapper for element has the same name (" + wrapperQName + ") as " + ((Element)((HashMap)elementNames.get(null)).get(wrapperQName)).getPosition() + ". Please use annotations to disambiguate.");
                    }
                    if (wrapperQName == null) continue;
                }
                if (element instanceof ElementRef) {
                    result.aggregate(this.validateElementRef((ElementRef)element));
                    continue;
                }
                result.aggregate(this.validateElement(element));
            }
        }
        if (typeDef.getXmlID() != null) {
            result.aggregate(this.validateXmlID(typeDef.getXmlID()));
        }
        return result;
    }

    @Override
    public ValidationResult validateRootElement(RootElementDeclaration rootElementDeclaration) {
        return new ValidationResult();
    }

    protected boolean isXmlTransient(Declaration declaration) {
        return declaration.getAnnotation(XmlTransient.class) != null;
    }

    public ValidationResult validatePackage(Schema schema) {
        XmlSchemaTypes schemaTypes;
        ValidationResult result = new ValidationResult();
        XmlSchemaType schemaType = (XmlSchemaType)schema.getAnnotation(XmlSchemaType.class);
        if (schemaType != null) {
            try {
                if (schemaType.type() == XmlSchemaType.DEFAULT.class) {
                    result.addError((Declaration)schema, "A type must be specified at the package-level for @XmlSchemaType.");
                }
            }
            catch (MirroredTypeException e) {
                // empty catch block
            }
        }
        if ((schemaTypes = (XmlSchemaTypes)schema.getAnnotation(XmlSchemaTypes.class)) != null) {
            for (XmlSchemaType xmlSchemaType : schemaTypes.value()) {
                try {
                    if (xmlSchemaType.type() != XmlSchemaType.DEFAULT.class) continue;
                    result.addError((Declaration)schema, "A type must be specified at the package-level for all types of @XmlSchemaTypes.");
                }
                catch (MirroredTypeException e) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    public ValidationResult validateAttribute(Attribute attribute) {
        ValidationResult result = this.validateAccessor(attribute);
        org.codehaus.enunciate.contract.jaxb.types.XmlType baseType = attribute.getBaseType();
        if (baseType == null) {
            result.addError((Declaration)attribute, "No base type specified.");
        } else if (baseType instanceof XmlClassType && ((XmlClassType)baseType).getTypeDefinition() instanceof ComplexTypeDefinition) {
            result.addError((Declaration)attribute, "An attribute must have a simple base type. " + new QName(baseType.getNamespace(), baseType.getName()) + " is a complex type.");
        } else if (attribute.isBinaryData()) {
            result.addError((Declaration)attribute, "Attributes can't have binary data.");
        }
        return result;
    }

    public ValidationResult validateElement(Element element) {
        ValidationResult result = this.validateAccessor(element);
        XmlElements xmlElements = (XmlElements)element.getAnnotation(XmlElements.class);
        if (element.isCollectionType() && element.getBaseType() != KnownXmlType.ANY_TYPE && xmlElements != null && xmlElements.value() != null && xmlElements.value().length > 1) {
            TypeMirror itemType = element.getCollectionItemType();
            if (itemType instanceof DeclaredType && ((DeclaredType)itemType).getDeclaration() != null) {
                String fqn = ((DeclaredType)itemType).getDeclaration().getQualifiedName();
                for (XmlElement xmlElement : xmlElements.value()) {
                    DecoratedTypeMirror elementCandidate;
                    try {
                        Class clazz = xmlElement.type();
                        AnnotationProcessorEnvironment env = net.sf.jelly.apt.Context.getCurrentEnvironment();
                        DeclaredType declaredType = env.getTypeUtils().getDeclaredType(env.getTypeDeclaration(clazz.getName()), new TypeMirror[0]);
                        elementCandidate = (DecoratedTypeMirror)TypeMirrorDecorator.decorate((TypeMirror)declaredType);
                    }
                    catch (MirroredTypeException e) {
                        elementCandidate = (DecoratedTypeMirror)TypeMirrorDecorator.decorate((TypeMirror)e.getTypeMirror());
                    }
                    if (elementCandidate.isInstanceOf(fqn)) continue;
                    result.addError((Declaration)element, elementCandidate + " is not an instance of " + fqn);
                }
            } else {
                result.addWarning((Declaration)element, "Unknown or invisible collection item type.");
            }
        }
        return result;
    }

    public ValidationResult validateValue(Value value) {
        ValidationResult result = this.validateAccessor(value);
        org.codehaus.enunciate.contract.jaxb.types.XmlType baseType = value.getBaseType();
        if (baseType == null) {
            result.addError((Declaration)value, "No base type specified.");
        } else if (baseType instanceof XmlClassType && ((XmlClassType)baseType).getTypeDefinition() instanceof ComplexTypeDefinition) {
            result.addError((Declaration)value, "An xml value must have a simple base type. " + new QName(baseType.getNamespace(), baseType.getName()) + " is a complex type.");
        }
        return result;
    }

    public ValidationResult validateElementRef(ElementRef elementRef) {
        ValidationResult result = this.validateAccessor(elementRef);
        if (elementRef.getAnnotation(XmlElement.class) != null || elementRef.getAnnotation(XmlElements.class) != null) {
            result.addError((Declaration)elementRef, "The xml element ref cannot be annotated also with XmlElement or XmlElements.");
        }
        if (elementRef.isCollectionType() && elementRef.getChoices().isEmpty()) {
            result.addError((Declaration)elementRef, String.format("Member %s of %s: no known root element subtypes of %s", elementRef.getSimpleName(), elementRef.getTypeDefinition().getQualifiedName(), elementRef.getBareAccessorType()));
        }
        return result;
    }

    public ValidationResult validateAccessor(Accessor accessor) {
        ValidationResult result = new ValidationResult();
        if (accessor.getDelegate() instanceof PropertyDeclaration) {
            PropertyDeclaration property = (PropertyDeclaration)accessor.getDelegate();
            DecoratedMethodDeclaration getter = property.getGetter();
            DecoratedMethodDeclaration setter = property.getSetter();
            if (getter != null && setter != null) {
                Map getterAnnotations = getter.getAnnotations();
                Map setterAnnotations = setter.getAnnotations();
                for (String annotation : getterAnnotations.keySet()) {
                    if (!annotation.startsWith(XmlElement.class.getPackage().getName()) || !setterAnnotations.containsKey(annotation)) continue;
                    result.addError((Declaration)setter, "'" + annotation + "' is on both the getter and setter.");
                }
            }
        }
        if (accessor.isXmlIDREF() && accessor.getAccessorForXmlID() == null) {
            if (this.disabledRules.contains("jaxb.xmlidref.references.xmlid")) {
                result.addError((Declaration)accessor, "An XML IDREF must have a base type that references another type that has an XML ID.");
            } else {
                result.addWarning((Declaration)accessor, "An XML IDREF must have a base type that references another type that has an XML ID.");
            }
        }
        if (accessor.isReferencesQNameEnum()) {
            TypeMirror enumRef;
            TypeMirror accessorType = accessor.getAccessorType();
            if (!(accessorType instanceof DecoratedDeclaredType) || !((DecoratedDeclaredType)accessorType).isInstanceOf(QName.class.getName()) && !((DecoratedDeclaredType)accessorType).isInstanceOf(URI.class.getName())) {
                result.addError((Declaration)accessor, "An accessor that references a QName enumeration must return QName or URI.");
            }
            if (!((enumRef = accessor.getQNameEnumRef()) instanceof EnumType) || ((EnumType)enumRef).getDeclaration() == null || ((DeclaredType)enumRef).getDeclaration().getAnnotation(XmlQNameEnum.class) == null) {
                result.addError((Declaration)accessor, "A QName enum reference must reference an enum type annotated with @org.codehaus.enunciate.qname.XmlQNameEnum.");
            }
        }
        return result;
    }

    public ValidationResult validateXmlID(Accessor accessor) {
        TypeMirror accessorType;
        ValidationResult result = new ValidationResult();
        TypeMirror typeMirror = accessorType = accessor.isAdapted() ? accessor.getAdapterType().getAdaptingType() : accessor.getAccessorType();
        if (!(accessorType instanceof DeclaredType) || !((DeclaredType)accessorType).getDeclaration().getQualifiedName().startsWith(String.class.getName())) {
            result.addError((Declaration)accessor, "An xml id must be a string.");
        }
        return result;
    }
}

