/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.contract.json;

import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.PackageDeclaration;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.enunciate.contract.json.JsonRootElementDeclaration;
import org.codehaus.enunciate.contract.json.JsonTypeDefinition;
import org.codehaus.enunciate.json.JsonSchema;

public final class JsonSchemaInfo {
    private final String schemaId;
    private final String documentation;
    private final Map<String, JsonRootElementDeclaration> topLevelTypes = new HashMap<String, JsonRootElementDeclaration>();
    private final Map<String, JsonTypeDefinition> types = new HashMap<String, JsonTypeDefinition>();

    public static String schemaIdForType(ClassDeclaration delegate) {
        assert (delegate != null);
        PackageDeclaration schemaPackage = delegate.getPackage();
        return JsonSchemaInfo.schemaIdForPackage(schemaPackage);
    }

    public static String schemaIdForPackage(PackageDeclaration schemaPackage) {
        assert (schemaPackage != null) : "schemaPackage:null";
        JsonSchema jsonSchema = (JsonSchema)schemaPackage.getAnnotation(JsonSchema.class);
        if (jsonSchema != null && jsonSchema.schemaId() != null) {
            return jsonSchema.schemaId();
        }
        return schemaPackage.getQualifiedName();
    }

    public JsonSchemaInfo(PackageDeclaration schemaPackage) {
        assert (schemaPackage != null) : "schemaPackage:null";
        this.schemaId = JsonSchemaInfo.schemaIdForPackage(schemaPackage);
        this.documentation = schemaPackage.getDocComment();
    }

    public String getSchemaId() {
        return this.schemaId;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public Map<String, JsonRootElementDeclaration> getTopLevelTypesByName() {
        return this.topLevelTypes;
    }

    public Map<String, JsonTypeDefinition> getTypesByName() {
        return this.types;
    }

    public Collection<JsonTypeDefinition> getTypes() {
        return this.getTypesByName().values();
    }
}

