/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.contract.json;

import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.type.ArrayType;
import com.sun.mirror.type.DeclaredType;
import com.sun.mirror.type.TypeMirror;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.sf.jelly.apt.decorations.JavaDoc;
import net.sf.jelly.apt.decorations.TypeMirrorDecorator;
import net.sf.jelly.apt.decorations.declaration.PropertyDeclaration;
import net.sf.jelly.apt.decorations.type.DecoratedTypeMirror;
import org.codehaus.enunciate.contract.json.JsonTypeDefinition;
import org.codehaus.enunciate.json.JsonIgnore;
import org.codehaus.enunciate.json.JsonName;

public final class JsonObjectTypeDefinition
extends JsonTypeDefinition {
    private final Map<String, JsonPropertyDeclaration> propertiesByName;

    JsonObjectTypeDefinition(ClassDeclaration delegate) {
        super(delegate);
        HashMap<String, JsonPropertyDeclaration> propertiesByName = new HashMap<String, JsonPropertyDeclaration>();
        for (PropertyDeclaration propertyDeclaration : this.getProperties()) {
            if (propertyDeclaration.getAnnotation(JsonIgnore.class) != null) continue;
            JsonPropertyDeclaration property = new JsonPropertyDeclaration(propertyDeclaration);
            propertiesByName.put(property.getPropertyName(), property);
        }
        this.propertiesByName = Collections.unmodifiableMap(propertiesByName);
    }

    public Map<String, JsonPropertyDeclaration> getJsonPropertiesByName() {
        return this.propertiesByName;
    }

    public Collection<JsonPropertyDeclaration> getJsonProperties() {
        return this.getJsonPropertiesByName().values();
    }

    public static final class JsonPropertyDeclaration
    extends PropertyDeclaration {
        private final boolean isList;
        private final TypeMirror targetType;

        private JsonPropertyDeclaration(PropertyDeclaration propertyDeclaration) {
            super(propertyDeclaration.getGetter(), propertyDeclaration.getSetter());
            DecoratedTypeMirror decoratedPropertyType = (DecoratedTypeMirror)TypeMirrorDecorator.decorate((TypeMirror)this.getPropertyType());
            boolean bl = this.isList = decoratedPropertyType.isCollection() || decoratedPropertyType.isArray();
            if (decoratedPropertyType.isCollection() && this.getPropertyType() instanceof DeclaredType) {
                DeclaredType declaredType = (DeclaredType)this.getPropertyType();
                Collection actualTypeArguments = declaredType.getActualTypeArguments();
                this.targetType = actualTypeArguments != null && actualTypeArguments.size() == 1 ? TypeMirrorDecorator.decorate((TypeMirror)((TypeMirror)actualTypeArguments.iterator().next())) : this.getPropertyType();
            } else if (decoratedPropertyType.isArray() && this.getPropertyType() instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)this.getPropertyType();
                this.targetType = TypeMirrorDecorator.decorate((TypeMirror)arrayType.getComponentType());
            } else {
                this.targetType = this.getPropertyType();
            }
        }

        public String getPropertyName() {
            JsonName jsonName = (JsonName)this.getAnnotation(JsonName.class);
            return jsonName == null ? super.getPropertyName() : jsonName.value();
        }

        public String getPropertyDescription() {
            String docValue = this.getDocValue();
            if (docValue != null && docValue.trim().length() > 0) {
                return docValue;
            }
            JavaDoc.JavaDocTagList javaDocTagList = (JavaDoc.JavaDocTagList)this.getJavaDoc().get((Object)"return");
            if (javaDocTagList == null) {
                return null;
            }
            StringBuilder builder = new StringBuilder();
            boolean firstValue = true;
            for (String value : javaDocTagList) {
                if (firstValue) {
                    firstValue = false;
                } else {
                    builder.append('\n');
                }
                builder.append(value);
            }
            return builder.toString();
        }

        public boolean isList() {
            return this.isList;
        }

        public String getTypeName() {
            return this.targetType.toString();
        }

        public TypeMirror getTargetType() {
            return this.targetType;
        }
    }
}

