/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.contract.json;

import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.EnumConstantDeclaration;
import com.sun.mirror.declaration.EnumDeclaration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.codehaus.enunciate.contract.json.JsonTypeDefinition;

public final class JsonEnumTypeDefinition
extends JsonTypeDefinition {
    private final Collection<EnumValue> enumValues;

    JsonEnumTypeDefinition(EnumDeclaration delegate) {
        super((ClassDeclaration)delegate);
        ArrayList<EnumValue> enumValues = new ArrayList<EnumValue>(delegate.getEnumConstants().size());
        for (EnumConstantDeclaration constantDeclaration : delegate.getEnumConstants()) {
            enumValues.add(new EnumValue(constantDeclaration.getSimpleName(), constantDeclaration.getDocComment()));
        }
        this.enumValues = Collections.unmodifiableCollection(enumValues);
    }

    public Collection<EnumValue> getEnumValues() {
        return this.enumValues;
    }

    public static final class EnumValue {
        private final String name;
        private final String description;

        private EnumValue(String name, String description) {
            assert (name != null);
            this.name = name;
            this.description = description;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

