/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.contract.jaxws;

import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.type.ArrayType;
import com.sun.mirror.type.PrimitiveType;
import com.sun.mirror.type.TypeMirror;
import com.sun.mirror.util.SourcePosition;
import com.sun.mirror.util.TypeVisitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.jws.WebParam;
import javax.jws.soap.SOAPBinding;
import javax.xml.namespace.QName;
import net.sf.jelly.apt.decorations.TypeMirrorDecorator;
import net.sf.jelly.apt.decorations.type.DecoratedTypeMirror;
import org.codehaus.enunciate.contract.jaxb.ImplicitChildElement;
import org.codehaus.enunciate.contract.jaxb.adapters.Adaptable;
import org.codehaus.enunciate.contract.jaxb.adapters.AdapterType;
import org.codehaus.enunciate.contract.jaxb.adapters.AdapterUtil;
import org.codehaus.enunciate.contract.jaxb.types.XmlType;
import org.codehaus.enunciate.contract.jaxb.types.XmlTypeException;
import org.codehaus.enunciate.contract.jaxb.types.XmlTypeFactory;
import org.codehaus.enunciate.contract.jaxws.WebMessage;
import org.codehaus.enunciate.contract.jaxws.WebMessagePart;
import org.codehaus.enunciate.contract.jaxws.WebMethod;
import org.codehaus.enunciate.contract.validation.ValidationException;

public class WebResult
extends DecoratedTypeMirror
implements Adaptable,
WebMessage,
WebMessagePart,
ImplicitChildElement {
    private final boolean header;
    private final String name;
    private final String elementName;
    private final String partName;
    private final WebMethod method;
    private final AdapterType adapterType;
    private final javax.jws.WebResult annotation;

    protected WebResult(TypeMirror delegate, WebMethod method) {
        super(delegate);
        this.method = method;
        this.annotation = (javax.jws.WebResult)method.getAnnotation(javax.jws.WebResult.class);
        String partName = "return";
        if (this.annotation != null && !"".equals(this.annotation.partName())) {
            partName = this.annotation.partName();
        }
        this.partName = partName;
        this.header = this.annotation != null && this.annotation.header();
        this.adapterType = AdapterUtil.findAdapterType((Declaration)method);
        String name = "return";
        this.elementName = this.annotation != null && this.annotation.name() != null && !"".equals(this.annotation.name()) ? (name = this.annotation.name()) : (!this.isHeader() && this.isImplicitSchemaElement() ? method.getSimpleName() + "Response" : (this.header ? "" : name));
        this.name = name;
    }

    public void accept(TypeVisitor typeVisitor) {
        this.delegate.accept(typeVisitor);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getTargetNamespace() {
        String targetNamespace;
        String string = targetNamespace = this.isImplicitSchemaElement() ? this.method.getDeclaringEndpointInterface().getTargetNamespace() : "";
        if (this.annotation != null && this.annotation.targetNamespace() != null && !"".equals(this.annotation.targetNamespace())) {
            targetNamespace = this.annotation.targetNamespace();
        }
        return targetNamespace;
    }

    @Override
    public String getPartName() {
        return this.partName;
    }

    @Override
    public WebMethod getWebMethod() {
        return this.method;
    }

    public boolean isBare() {
        return this.method.getSoapParameterStyle() == SOAPBinding.ParameterStyle.BARE;
    }

    public WebParam.Mode getMode() {
        return WebParam.Mode.OUT;
    }

    @Override
    public String getMessageName() {
        String messageName = null;
        if (this.isBare()) {
            messageName = this.method.getDeclaringEndpointInterface().getSimpleName() + "." + this.method.getSimpleName() + "Response";
        } else if (this.isHeader()) {
            messageName = this.method.getDeclaringEndpointInterface().getSimpleName() + "." + this.method.getSimpleName() + "." + this.getName();
        }
        return messageName;
    }

    @Override
    public String getMessageDocs() {
        if (this.isBare()) {
            return this.getDocComment();
        }
        return null;
    }

    @Override
    public boolean isInput() {
        return false;
    }

    @Override
    public boolean isOutput() {
        return true;
    }

    @Override
    public boolean isHeader() {
        return this.header;
    }

    @Override
    public boolean isFault() {
        return false;
    }

    @Override
    public String getPartDocs() {
        if (this.isBare()) {
            return null;
        }
        return this.getDocComment();
    }

    @Override
    public WebMessagePart.ParticleType getParticleType() {
        return this.method.getSoapBindingStyle() == SOAPBinding.Style.RPC ? (this.isHeader() ? WebMessagePart.ParticleType.ELEMENT : WebMessagePart.ParticleType.TYPE) : WebMessagePart.ParticleType.ELEMENT;
    }

    @Override
    public QName getParticleQName() {
        if (this.method.getSoapBindingStyle() == SOAPBinding.Style.RPC && !this.isHeader()) {
            return this.getTypeQName();
        }
        return new QName(this.getTargetNamespace(), this.getElementName());
    }

    @Override
    public boolean isImplicitSchemaElement() {
        return this.isHeader() || this.method.getSoapBindingStyle() != SOAPBinding.Style.RPC && this.method.getSoapParameterStyle() == SOAPBinding.ParameterStyle.BARE;
    }

    @Override
    public Collection<WebMessagePart> getParts() {
        if (!this.isBare() && !this.isHeader()) {
            throw new UnsupportedOperationException("Web result doesn't represent a complex method input/output.");
        }
        return new ArrayList<WebMessagePart>(Arrays.asList(this));
    }

    @Override
    public QName getTypeQName() {
        return this.getXmlType().getQname();
    }

    @Override
    public XmlType getXmlType() {
        try {
            XmlType xmlType = XmlTypeFactory.findSpecifiedType(this);
            if (xmlType == null) {
                xmlType = XmlTypeFactory.getXmlType(this.getType());
            }
            return xmlType;
        }
        catch (XmlTypeException e) {
            throw new ValidationException(this.method.getPosition(), "Result of method " + this.getWebMethod().getSimpleName() + " of " + this.getWebMethod().getDeclaringEndpointInterface().getQualifiedName() + ": " + e.getMessage());
        }
    }

    @Override
    public String getMimeType() {
        return null;
    }

    @Override
    public boolean isSwaRef() {
        return false;
    }

    @Override
    public int getMinOccurs() {
        DecoratedTypeMirror typeMirror = (DecoratedTypeMirror)TypeMirrorDecorator.decorate((TypeMirror)this.delegate);
        return typeMirror.isPrimitive() ? 1 : 0;
    }

    @Override
    public String getMaxOccurs() {
        TypeMirror componentType;
        boolean unbounded;
        DecoratedTypeMirror typeMirror = (DecoratedTypeMirror)TypeMirrorDecorator.decorate((TypeMirror)this.delegate);
        boolean bl = unbounded = typeMirror.isCollection() || typeMirror.isArray();
        if (typeMirror.isArray() && (componentType = ((ArrayType)typeMirror).getComponentType()) instanceof PrimitiveType && ((PrimitiveType)componentType).getKind() == PrimitiveType.Kind.BYTE) {
            unbounded = false;
        }
        return unbounded ? "unbounded" : "1";
    }

    @Override
    public String getElementName() {
        return this.elementName;
    }

    @Override
    public String getElementDocs() {
        return ((DecoratedTypeMirror)this.delegate).getDocComment();
    }

    @Override
    public TypeMirror getType() {
        return this.delegate;
    }

    @Override
    public boolean isAdapted() {
        return this.adapterType != null;
    }

    @Override
    public AdapterType getAdapterType() {
        return this.adapterType;
    }

    public boolean isVoid() {
        return ((DecoratedTypeMirror)this.delegate).isVoid();
    }

    @Override
    public SourcePosition getPosition() {
        return this.method.getPosition();
    }
}

