/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.contract.jaxws;

import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.ParameterDeclaration;
import com.sun.mirror.type.ArrayType;
import com.sun.mirror.type.DeclaredType;
import com.sun.mirror.type.PrimitiveType;
import com.sun.mirror.type.TypeMirror;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.jws.WebParam;
import javax.jws.soap.SOAPBinding;
import javax.xml.bind.annotation.XmlAttachmentRef;
import javax.xml.bind.annotation.XmlMimeType;
import javax.xml.namespace.QName;
import javax.xml.ws.Holder;
import net.sf.jelly.apt.decorations.declaration.DecoratedParameterDeclaration;
import net.sf.jelly.apt.decorations.type.DecoratedTypeMirror;
import net.sf.jelly.apt.freemarker.FreemarkerModel;
import org.codehaus.enunciate.ClientName;
import org.codehaus.enunciate.apt.EnunciateFreemarkerModel;
import org.codehaus.enunciate.contract.jaxb.ImplicitChildElement;
import org.codehaus.enunciate.contract.jaxb.adapters.Adaptable;
import org.codehaus.enunciate.contract.jaxb.adapters.AdapterType;
import org.codehaus.enunciate.contract.jaxb.adapters.AdapterUtil;
import org.codehaus.enunciate.contract.jaxb.types.XmlType;
import org.codehaus.enunciate.contract.jaxb.types.XmlTypeException;
import org.codehaus.enunciate.contract.jaxb.types.XmlTypeFactory;
import org.codehaus.enunciate.contract.jaxws.WebMessage;
import org.codehaus.enunciate.contract.jaxws.WebMessagePart;
import org.codehaus.enunciate.contract.jaxws.WebMethod;
import org.codehaus.enunciate.contract.validation.ValidationException;
import org.codehaus.enunciate.util.MapType;
import org.codehaus.enunciate.util.MapTypeUtil;

public class WebParam
extends DecoratedParameterDeclaration
implements Adaptable,
WebMessage,
WebMessagePart,
ImplicitChildElement {
    private final javax.jws.WebParam annotation;
    private final WebMethod method;
    private final AdapterType adapterType;
    private final boolean forceSpecCompliance;
    private final int parameterIndex;

    protected WebParam(ParameterDeclaration delegate, WebMethod method, int parameterIndex) {
        super(delegate);
        this.method = method;
        this.parameterIndex = parameterIndex;
        if (this.method == null) {
            throw new IllegalArgumentException("A web method must be provided.");
        }
        this.annotation = (javax.jws.WebParam)delegate.getAnnotation(javax.jws.WebParam.class);
        this.adapterType = AdapterUtil.findAdapterType((Declaration)this);
        EnunciateFreemarkerModel model = (EnunciateFreemarkerModel)FreemarkerModel.get();
        this.forceSpecCompliance = model != null && model.getEnunciateConfig() != null && model.getEnunciateConfig().isForceJAXWSSpecCompliance();
    }

    public String getBaseParamName() {
        return this.forceSpecCompliance ? "arg" + this.parameterIndex : this.getSimpleName();
    }

    @Override
    public WebMethod getWebMethod() {
        return this.method;
    }

    @Override
    public String getElementName() {
        String name;
        String string = name = this.isHeader() ? "" : this.getBaseParamName();
        if (this.annotation != null && this.annotation.name() != null && !"".equals(this.annotation.name())) {
            name = this.annotation.name();
        } else if (!this.isHeader() && this.isImplicitSchemaElement()) {
            name = this.method.getSimpleName();
        }
        return name;
    }

    @Override
    public String getTargetNamespace() {
        String namespace;
        String string = namespace = this.isImplicitSchemaElement() ? this.method.getDeclaringEndpointInterface().getTargetNamespace() : "";
        if (this.annotation != null && this.annotation.targetNamespace() != null && !"".equals(this.annotation.targetNamespace())) {
            namespace = this.annotation.targetNamespace();
        }
        return namespace;
    }

    public String getClientSimpleName() {
        String clientSimpleName = this.getSimpleName();
        ClientName clientName = (ClientName)this.getAnnotation(ClientName.class);
        if (clientName != null) {
            clientSimpleName = clientName.value();
        }
        return clientSimpleName;
    }

    @Override
    public String getElementDocs() {
        return this.getDelegate().getDocComment();
    }

    @Override
    public String getPartName() {
        String partName = this.getBaseParamName();
        if (this.annotation != null && this.annotation.partName() != null && !"".equals(this.annotation.partName())) {
            partName = this.annotation.partName();
        }
        return partName;
    }

    @Override
    public String getMessageName() {
        String messageName = null;
        if (this.isBare()) {
            messageName = this.method.getDeclaringEndpointInterface().getSimpleName() + "." + this.method.getSimpleName();
        } else if (this.isHeader()) {
            messageName = this.method.getDeclaringEndpointInterface().getSimpleName() + "." + this.method.getSimpleName() + "." + this.getBaseParamName();
        }
        return messageName;
    }

    @Override
    public String getMessageDocs() {
        if (this.isBare()) {
            return this.getDelegate().getDocComment();
        }
        return null;
    }

    @Override
    public String getPartDocs() {
        if (this.isBare()) {
            return null;
        }
        return this.getDelegate().getDocComment();
    }

    @Override
    public WebMessagePart.ParticleType getParticleType() {
        return this.method.getSoapBindingStyle() == SOAPBinding.Style.RPC ? (this.isHeader() ? WebMessagePart.ParticleType.ELEMENT : WebMessagePart.ParticleType.TYPE) : WebMessagePart.ParticleType.ELEMENT;
    }

    @Override
    public QName getParticleQName() {
        if (this.method.getSoapBindingStyle() == SOAPBinding.Style.RPC && !this.isHeader()) {
            return this.getTypeQName();
        }
        return new QName(this.getTargetNamespace(), this.getElementName());
    }

    @Override
    public boolean isImplicitSchemaElement() {
        return this.isHeader() || this.method.getSoapBindingStyle() != SOAPBinding.Style.RPC && this.method.getSoapParameterStyle() == SOAPBinding.ParameterStyle.BARE;
    }

    @Override
    public QName getTypeQName() {
        return this.getXmlType().getQname();
    }

    @Override
    public TypeMirror getType() {
        Object type = super.getType();
        MapType mapType = MapTypeUtil.findMapType(type);
        if (mapType != null) {
            type = mapType;
        }
        return type;
    }

    @Override
    public XmlType getXmlType() {
        try {
            XmlType xmlType = XmlTypeFactory.findSpecifiedType(this);
            if (xmlType == null) {
                TypeMirror type = this.getType();
                if (this.isHolder()) {
                    Collection typeArgs = ((DeclaredType)type).getActualTypeArguments();
                    if (typeArgs == null || typeArgs.size() == 0) {
                        throw new ValidationException(this.getPosition(), "Parameter " + this.getSimpleName() + ": unable to get the type of the holder.");
                    }
                    type = (TypeMirror)typeArgs.iterator().next();
                }
                xmlType = XmlTypeFactory.getXmlType(type);
            }
            return xmlType;
        }
        catch (XmlTypeException e) {
            throw new ValidationException(this.getPosition(), "Parameter " + this.getSimpleName() + ": " + e.getMessage());
        }
    }

    @Override
    public String getMimeType() {
        XmlMimeType mimeType = (XmlMimeType)this.getAnnotation(XmlMimeType.class);
        return mimeType == null ? null : mimeType.value();
    }

    @Override
    public boolean isSwaRef() {
        return this.getAnnotation(XmlAttachmentRef.class) != null;
    }

    @Override
    public int getMinOccurs() {
        DecoratedTypeMirror paramType = (DecoratedTypeMirror)this.getType();
        return paramType.isPrimitive() ? 1 : 0;
    }

    @Override
    public String getMaxOccurs() {
        TypeMirror componentType;
        boolean unbounded;
        DecoratedTypeMirror paramType = (DecoratedTypeMirror)this.getType();
        boolean bl = unbounded = paramType.isCollection() || paramType.isArray();
        if (paramType.isArray() && (componentType = ((ArrayType)paramType).getComponentType()) instanceof PrimitiveType && ((PrimitiveType)componentType).getKind() == PrimitiveType.Kind.BYTE) {
            unbounded = false;
        }
        return unbounded ? "unbounded" : "1";
    }

    public WebParam.Mode getMode() {
        WebParam.Mode mode = WebParam.Mode.IN;
        if (this.annotation != null && this.annotation.mode() != null) {
            mode = this.annotation.mode();
        }
        return mode;
    }

    @Override
    public boolean isHeader() {
        boolean header = false;
        if (this.annotation != null) {
            header = this.annotation.header();
        }
        return header;
    }

    private boolean isBare() {
        return this.method.getSoapParameterStyle() == SOAPBinding.ParameterStyle.BARE;
    }

    @Override
    public boolean isInput() {
        return this.getMode() == WebParam.Mode.IN || this.getMode() == WebParam.Mode.INOUT && this.isHolder();
    }

    @Override
    public boolean isOutput() {
        return this.getMode() == WebParam.Mode.OUT || this.getMode() == WebParam.Mode.INOUT && this.isHolder();
    }

    public boolean isHolder() {
        return ((DecoratedTypeMirror)this.getType()).isInstanceOf(Holder.class.getName());
    }

    @Override
    public boolean isFault() {
        return false;
    }

    @Override
    public Collection<WebMessagePart> getParts() {
        if (!this.isBare() && !this.isHeader()) {
            throw new UnsupportedOperationException("Web param doesn't represent a complex method input/output.");
        }
        return new ArrayList<WebMessagePart>(Arrays.asList(this));
    }

    @Override
    public boolean isAdapted() {
        return this.adapterType != null;
    }

    @Override
    public AdapterType getAdapterType() {
        return this.adapterType;
    }
}

