/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.contract.jaxws;

import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.ParameterDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.type.DeclaredType;
import com.sun.mirror.type.ReferenceType;
import com.sun.mirror.type.TypeMirror;
import com.sun.mirror.type.VoidType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.jws.Oneway;
import javax.jws.soap.SOAPBinding;
import net.sf.jelly.apt.decorations.declaration.DecoratedMethodDeclaration;
import org.codehaus.enunciate.ClientName;
import org.codehaus.enunciate.contract.jaxws.EndpointInterface;
import org.codehaus.enunciate.contract.jaxws.RPCInputMessage;
import org.codehaus.enunciate.contract.jaxws.RPCOutputMessage;
import org.codehaus.enunciate.contract.jaxws.RequestWrapper;
import org.codehaus.enunciate.contract.jaxws.ResponseWrapper;
import org.codehaus.enunciate.contract.jaxws.WebFault;
import org.codehaus.enunciate.contract.jaxws.WebMessage;
import org.codehaus.enunciate.contract.jaxws.WebMessagePart;
import org.codehaus.enunciate.contract.jaxws.WebParam;
import org.codehaus.enunciate.contract.jaxws.WebResult;
import org.codehaus.enunciate.contract.validation.ValidationException;
import org.codehaus.enunciate.util.MapType;
import org.codehaus.enunciate.util.MapTypeUtil;

public class WebMethod
extends DecoratedMethodDeclaration
implements Comparable<WebMethod> {
    private final javax.jws.WebMethod annotation = (javax.jws.WebMethod)this.getAnnotation(javax.jws.WebMethod.class);
    private final boolean oneWay = this.getAnnotation(Oneway.class) != null;
    private final EndpointInterface endpointInterface;
    private final WebResult webResult;
    private final Collection<WebParam> webParams;
    private final Collection<WebFault> webFaults;
    private final Collection<WebMessage> messages;
    private final RequestWrapper requestWrapper;
    private final ResponseWrapper responseWrapper;

    public WebMethod(MethodDeclaration delegate, EndpointInterface endpointInterface) {
        super(delegate);
        this.endpointInterface = endpointInterface;
        this.webResult = new WebResult(this.getReturnType(), this);
        Collection parameters = this.getParameters();
        ArrayList<WebParam> webParameters = new ArrayList<WebParam>(parameters.size());
        int parameterIndex = 0;
        for (ParameterDeclaration parameter : parameters) {
            webParameters.add(new WebParam(parameter, this, parameterIndex++));
        }
        this.webParams = webParameters;
        ArrayList<WebFault> webFaults = new ArrayList<WebFault>();
        for (ReferenceType referenceType : this.getThrownTypes()) {
            if (!(referenceType instanceof DeclaredType)) {
                throw new ValidationException(this.getPosition(), "Method " + this.getSimpleName() + " of " + endpointInterface.getQualifiedName() + ": Thrown type must be a declared type.");
            }
            TypeDeclaration declaration = ((DeclaredType)referenceType).getDeclaration();
            if (declaration == null) {
                throw new ValidationException(this.getPosition(), "Method " + this.getSimpleName() + " of " + endpointInterface.getQualifiedName() + ": unknown declaration for " + referenceType);
            }
            webFaults.add(new WebFault((ClassDeclaration)declaration));
        }
        this.webFaults = webFaults;
        ArrayList<WebMessage> messages = new ArrayList<WebMessage>();
        SOAPBinding.Style bindingStyle = this.getSoapBindingStyle();
        for (WebParam webParam : webParameters) {
            if (!webParam.isHeader()) continue;
            messages.add(webParam);
        }
        if (this.webResult.isHeader()) {
            messages.add(this.webResult);
        }
        RequestWrapper requestWrapper = null;
        ResponseWrapper responseWrapper = null;
        if (bindingStyle == SOAPBinding.Style.DOCUMENT) {
            SOAPBinding.ParameterStyle parameterStyle = this.getSoapParameterStyle();
            if (parameterStyle == SOAPBinding.ParameterStyle.WRAPPED) {
                requestWrapper = new RequestWrapper(this);
                messages.add(requestWrapper);
                if (!this.isOneWay()) {
                    responseWrapper = new ResponseWrapper(this);
                    messages.add(responseWrapper);
                }
                messages.addAll(webFaults);
            } else {
                for (WebParam webParam : webParameters) {
                    if (webParam.isHeader()) continue;
                    messages.add(webParam);
                }
                if (!(this.isOneWay() || this.getReturnType() instanceof VoidType || this.webResult.isHeader())) {
                    messages.add(this.webResult);
                }
                messages.addAll(webFaults);
            }
        } else {
            messages.add(new RPCInputMessage(this));
            messages.add(new RPCOutputMessage(this));
            messages.addAll(webFaults);
        }
        this.messages = messages;
        this.requestWrapper = requestWrapper;
        this.responseWrapper = responseWrapper;
    }

    public String getClientSimpleName() {
        String clientSimpleName = this.getSimpleName();
        ClientName clientName = (ClientName)this.getAnnotation(ClientName.class);
        if (clientName != null) {
            clientSimpleName = clientName.value();
        }
        return clientSimpleName;
    }

    public TypeMirror getReturnType() {
        Object type = super.getReturnType();
        MapType mapType = MapTypeUtil.findMapType(type);
        if (mapType != null) {
            type = mapType;
        }
        return type;
    }

    public WebResult getWebResult() {
        return this.webResult;
    }

    public Collection<WebParam> getWebParameters() {
        return this.webParams;
    }

    public Collection<WebFault> getWebFaults() {
        return this.webFaults;
    }

    public Collection<WebMessage> getMessages() {
        return this.messages;
    }

    public RequestWrapper getRequestWrapper() {
        return this.requestWrapper;
    }

    public ResponseWrapper getResponseWrapper() {
        return this.responseWrapper;
    }

    public Set<String> getReferencedNamespaces() {
        HashSet<String> namespaces = new HashSet<String>();
        Collection<WebMessage> messages = this.getMessages();
        for (WebMessage message : messages) {
            for (WebMessagePart part : message.getParts()) {
                namespaces.add(part.getParticleQName().getNamespaceURI());
            }
        }
        return namespaces;
    }

    public String getOperationName() {
        String operationName = this.getSimpleName();
        if (this.annotation != null && !"".equals(this.annotation.operationName())) {
            return this.annotation.operationName();
        }
        return operationName;
    }

    public String getAction() {
        String action = "";
        if (this.annotation != null) {
            action = this.annotation.action();
        }
        return action;
    }

    public boolean isOneWay() {
        return this.oneWay;
    }

    public SOAPBinding.Style getSoapBindingStyle() {
        SOAPBinding.Style style = this.getDeclaringEndpointInterface().getSoapBindingStyle();
        SOAPBinding bindingInfo = (SOAPBinding)this.getAnnotation(SOAPBinding.class);
        if (bindingInfo != null) {
            style = bindingInfo.style();
        }
        return style;
    }

    public EndpointInterface getDeclaringEndpointInterface() {
        return this.endpointInterface;
    }

    public SOAPBinding.Use getSoapUse() {
        SOAPBinding.Use use = this.getDeclaringEndpointInterface().getSoapUse();
        SOAPBinding bindingInfo = (SOAPBinding)this.getAnnotation(SOAPBinding.class);
        if (bindingInfo != null) {
            use = bindingInfo.use();
        }
        return use;
    }

    public SOAPBinding.ParameterStyle getSoapParameterStyle() {
        SOAPBinding.ParameterStyle style = this.getDeclaringEndpointInterface().getSoapParameterStyle();
        SOAPBinding bindingInfo = (SOAPBinding)this.getAnnotation(SOAPBinding.class);
        if (bindingInfo != null) {
            style = bindingInfo.parameterStyle();
        }
        return style;
    }

    public boolean isDocLitWrapped() {
        return this.getSoapBindingStyle() == SOAPBinding.Style.DOCUMENT && this.getSoapUse() == SOAPBinding.Use.LITERAL && this.getSoapParameterStyle() == SOAPBinding.ParameterStyle.WRAPPED;
    }

    @Override
    public int compareTo(WebMethod webMethod) {
        return this.getOperationName().compareTo(webMethod.getOperationName());
    }
}

