/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.contract.jaxws;

import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.ConstructorDeclaration;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.Modifier;
import com.sun.mirror.declaration.PackageDeclaration;
import com.sun.mirror.declaration.ParameterDeclaration;
import com.sun.mirror.type.ArrayType;
import com.sun.mirror.type.ClassType;
import com.sun.mirror.type.PrimitiveType;
import com.sun.mirror.type.TypeMirror;
import com.sun.mirror.util.SourcePosition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.TreeSet;
import javax.xml.bind.annotation.XmlAttachmentRef;
import javax.xml.bind.annotation.XmlMimeType;
import javax.xml.namespace.QName;
import net.sf.jelly.apt.decorations.TypeMirrorDecorator;
import net.sf.jelly.apt.decorations.declaration.DecoratedClassDeclaration;
import net.sf.jelly.apt.decorations.declaration.PropertyDeclaration;
import net.sf.jelly.apt.decorations.type.DecoratedTypeMirror;
import net.sf.jelly.apt.freemarker.FreemarkerModel;
import org.codehaus.enunciate.ClientName;
import org.codehaus.enunciate.XmlTransient;
import org.codehaus.enunciate.apt.EnunciateFreemarkerModel;
import org.codehaus.enunciate.contract.jaxb.ElementDeclaration;
import org.codehaus.enunciate.contract.jaxb.ImplicitChildElement;
import org.codehaus.enunciate.contract.jaxb.ImplicitRootElement;
import org.codehaus.enunciate.contract.jaxb.adapters.Adaptable;
import org.codehaus.enunciate.contract.jaxb.adapters.AdapterType;
import org.codehaus.enunciate.contract.jaxb.adapters.AdapterUtil;
import org.codehaus.enunciate.contract.jaxb.types.XmlType;
import org.codehaus.enunciate.contract.jaxb.types.XmlTypeException;
import org.codehaus.enunciate.contract.jaxb.types.XmlTypeFactory;
import org.codehaus.enunciate.contract.jaxws.WebMessage;
import org.codehaus.enunciate.contract.jaxws.WebMessagePart;
import org.codehaus.enunciate.contract.jaxws.WebMethod;
import org.codehaus.enunciate.contract.validation.ValidationException;
import org.codehaus.enunciate.soap.annotations.WebFaultPropertyOrder;
import org.codehaus.enunciate.util.MapType;
import org.codehaus.enunciate.util.MapTypeUtil;

public class WebFault
extends DecoratedClassDeclaration
implements WebMessage,
WebMessagePart,
ImplicitRootElement {
    private final javax.xml.ws.WebFault annotation = (javax.xml.ws.WebFault)this.getAnnotation(javax.xml.ws.WebFault.class);
    private final ClassType explicitFaultBeanType;

    public WebFault(ClassDeclaration delegate) {
        super(delegate);
        ClassType explicitFaultBeanType = null;
        Collection properties = this.getProperties();
        PropertyDeclaration faultInfoProperty = null;
        for (PropertyDeclaration propertyDeclaration : properties) {
            if (!"faultInfo".equals(propertyDeclaration.getPropertyName())) continue;
            faultInfoProperty = propertyDeclaration;
            break;
        }
        if (faultInfoProperty != null && faultInfoProperty.getPropertyType() instanceof ClassType) {
            ClassType faultInfoType = (ClassType)faultInfoProperty.getPropertyType();
            if (faultInfoType.getDeclaration() == null) {
                throw new ValidationException(this.getPosition(), this.getQualifiedName() + ": class not found: " + faultInfoType + ".");
            }
            boolean messageConstructorFound = false;
            boolean messageAndThrowableConstructorFound = false;
            Collection constructors = this.getConstructors();
            for (ConstructorDeclaration constructor : constructors) {
                ParameterDeclaration[] parameters;
                if (!constructor.getModifiers().contains(Modifier.PUBLIC) || (parameters = constructor.getParameters().toArray(new ParameterDeclaration[constructor.getParameters().size()])).length < 2) continue;
                DecoratedTypeMirror param0Type = (DecoratedTypeMirror)TypeMirrorDecorator.decorate((TypeMirror)parameters[0].getType());
                DecoratedTypeMirror param1Type = (DecoratedTypeMirror)TypeMirrorDecorator.decorate((TypeMirror)parameters[1].getType());
                if (parameters.length == 2) {
                    messageConstructorFound |= param0Type.isInstanceOf(String.class.getName()) && param1Type.isInstanceOf(faultInfoType.getDeclaration().getQualifiedName());
                    continue;
                }
                if (parameters.length != 3) continue;
                DecoratedTypeMirror param2Type = (DecoratedTypeMirror)TypeMirrorDecorator.decorate((TypeMirror)parameters[2].getType());
                messageAndThrowableConstructorFound |= param0Type.isInstanceOf(String.class.getName()) && param1Type.isInstanceOf(faultInfoType.getDeclaration().getQualifiedName()) && param2Type.isInstanceOf(Throwable.class.getName());
            }
            if (messageConstructorFound && messageAndThrowableConstructorFound) {
                explicitFaultBeanType = faultInfoType;
            }
        }
        if (faultInfoProperty != null && explicitFaultBeanType == null) {
            throw new ValidationException(faultInfoProperty.getPosition(), "The 'getFaultInfo' method is only allowed on a web fault if you're declaring an explicit fault bean, and you don't have the right constructor signatures set up in order for '" + faultInfoProperty.getPropertyType() + "' to be an explicit fault bean.");
        }
        this.explicitFaultBeanType = explicitFaultBeanType;
    }

    @Override
    public String getMessageName() {
        return this.getSimpleName();
    }

    @Override
    public String getMessageDocs() {
        return this.getElementDocs();
    }

    @Override
    public String getElementName() {
        String name = null;
        if (this.isImplicitSchemaElement()) {
            name = this.getSimpleName();
            if (this.annotation != null && this.annotation.name() != null && !"".equals(this.annotation.name())) {
                name = this.annotation.name();
            }
        }
        return name;
    }

    public String getClientSimpleName() {
        String clientSimpleName = this.getSimpleName();
        ClientName clientName = (ClientName)this.getAnnotation(ClientName.class);
        if (clientName != null) {
            clientSimpleName = clientName.value();
        }
        return clientSimpleName;
    }

    @Override
    public String getElementDocs() {
        String docs = this.getJavaDoc().toString();
        if (docs.trim().length() == 0) {
            docs = null;
        }
        return docs;
    }

    @Override
    public String getPartName() {
        return this.getSimpleName();
    }

    @Override
    public String getPartDocs() {
        return null;
    }

    public String getImplicitFaultBeanQualifiedName() {
        String faultBean = null;
        if (this.isImplicitSchemaElement()) {
            faultBean = this.getPackage().getQualifiedName() + ".jaxws." + this.getSimpleName() + "Bean";
            if (this.annotation != null && this.annotation.faultBean() != null && !"".equals(this.annotation.faultBean())) {
                faultBean = this.annotation.faultBean();
            }
        }
        return faultBean;
    }

    public ClassType getExplicitFaultBeanType() {
        return this.explicitFaultBeanType;
    }

    public ElementDeclaration findExplicitFaultBean() {
        if (this.explicitFaultBeanType == null || this.explicitFaultBeanType.getDeclaration() == null) {
            return null;
        }
        return ((EnunciateFreemarkerModel)FreemarkerModel.get()).findElementDeclaration(this.explicitFaultBeanType.getDeclaration());
    }

    @Override
    public WebMessagePart.ParticleType getParticleType() {
        return WebMessagePart.ParticleType.ELEMENT;
    }

    @Override
    public QName getParticleQName() {
        ElementDeclaration faultBean = this.findExplicitFaultBean();
        if (faultBean != null) {
            return new QName(faultBean.getNamespace(), faultBean.getName());
        }
        return new QName(this.getTargetNamespace(), this.getElementName());
    }

    @Override
    public String getTargetNamespace() {
        String targetNamespace = null;
        if (this.isImplicitSchemaElement()) {
            if (this.annotation != null) {
                targetNamespace = this.annotation.targetNamespace();
            }
            if (targetNamespace == null || "".equals(targetNamespace)) {
                targetNamespace = this.calculateNamespaceURI();
            }
        }
        return targetNamespace;
    }

    protected String calculateNamespaceURI() {
        PackageDeclaration pkg = this.getPackage();
        if (pkg == null || "".equals(pkg.getQualifiedName())) {
            throw new ValidationException(this.getPosition(), this.getQualifiedName() + ": a web fault in no package must specify a target namespace.");
        }
        String[] tokens = pkg.getQualifiedName().split("\\.");
        String uri = "http://";
        for (int i = tokens.length - 1; i >= 0; --i) {
            uri = uri + tokens[i];
            if (i == 0) continue;
            uri = uri + ".";
        }
        uri = uri + "/";
        return uri;
    }

    @Override
    public QName getTypeQName() {
        return null;
    }

    @Override
    public boolean isImplicitSchemaElement() {
        return this.explicitFaultBeanType == null;
    }

    @Override
    public Collection<ImplicitChildElement> getChildElements() {
        if (!this.isImplicitSchemaElement()) {
            return Collections.emptyList();
        }
        TreeSet<ImplicitChildElement> childElements = new TreeSet<ImplicitChildElement>(new Comparator<ImplicitChildElement>(){

            @Override
            public int compare(ImplicitChildElement o1, ImplicitChildElement o2) {
                return o1.getElementName().compareTo(o2.getElementName());
            }
        });
        for (PropertyDeclaration property : this.getAllFaultProperties(this)) {
            String propertyName = property.getPropertyName();
            if ("cause".equals(propertyName) || "localizedMessage".equals(propertyName) || "stackTrace".equals(propertyName) || "suppressed".equals(propertyName)) continue;
            childElements.add(new FaultBeanChildElement(property, this));
        }
        final WebFaultPropertyOrder propOrder = (WebFaultPropertyOrder)this.getAnnotation(WebFaultPropertyOrder.class);
        if (propOrder != null) {
            TreeSet<ImplicitChildElement> resorted = new TreeSet<ImplicitChildElement>(new Comparator<ImplicitChildElement>(){

                @Override
                public int compare(ImplicitChildElement o1, ImplicitChildElement o2) {
                    int index1 = -1;
                    int index2 = -1;
                    for (int i = 0; i < propOrder.value().length; ++i) {
                        String prop = propOrder.value()[i];
                        if (o1.getElementName().equals(prop)) {
                            index1 = i;
                        }
                        if (!o2.getElementName().equals(prop)) continue;
                        index2 = i;
                    }
                    if (index1 < 0) {
                        throw new ValidationException(WebFault.this.getPosition(), WebFault.this.getQualifiedName() + ": @WebFaultPropertyOrder doesn't specify a property '" + o1.getElementName() + "'.");
                    }
                    if (index2 < 0) {
                        throw new ValidationException(WebFault.this.getPosition(), WebFault.this.getQualifiedName() + ": @WebFaultPropertyOrder doesn't specify a property '" + o2.getElementName() + "'.");
                    }
                    return index1 - index2;
                }
            });
            resorted.addAll(childElements);
            childElements = resorted;
        }
        return childElements;
    }

    protected Collection<PropertyDeclaration> getAllFaultProperties(DecoratedClassDeclaration declaration) {
        ArrayList<PropertyDeclaration> properties = new ArrayList<PropertyDeclaration>();
        while (declaration != null && !Object.class.getName().equals(declaration.getQualifiedName())) {
            for (PropertyDeclaration property : declaration.getProperties()) {
                if (property.getGetter() == null || property.getAnnotation(javax.xml.bind.annotation.XmlTransient.class) != null || property.getAnnotation(XmlTransient.class) != null) continue;
                properties.add(property);
            }
            declaration = (DecoratedClassDeclaration)declaration.getSuperclass().getDeclaration();
        }
        return properties;
    }

    @Override
    public Collection<WebMessagePart> getParts() {
        return new ArrayList<WebMessagePart>(Arrays.asList(this));
    }

    @Override
    public boolean isInput() {
        return false;
    }

    @Override
    public boolean isOutput() {
        return false;
    }

    @Override
    public boolean isHeader() {
        return false;
    }

    @Override
    public boolean isFault() {
        return true;
    }

    @Override
    public WebMethod getWebMethod() {
        throw new UnsupportedOperationException("Web faults aren't associated with a specific web method.");
    }

    public static class FaultBeanChildElement
    implements Adaptable,
    ImplicitChildElement {
        private final PropertyDeclaration property;
        private final int minOccurs;
        private final String maxOccurs;
        private final AdapterType adaperType;
        private final WebFault webFault;

        private FaultBeanChildElement(PropertyDeclaration property, WebFault webFault) {
            TypeMirror componentType;
            boolean unbounded;
            DecoratedTypeMirror propertyType = (DecoratedTypeMirror)property.getPropertyType();
            this.adaperType = AdapterUtil.findAdapterType((Declaration)property.getGetter());
            int minOccurs = propertyType.isPrimitive() ? 1 : 0;
            boolean bl = unbounded = propertyType.isCollection() || propertyType.isArray();
            if (propertyType.isArray() && (componentType = ((ArrayType)propertyType).getComponentType()) instanceof PrimitiveType && ((PrimitiveType)componentType).getKind() == PrimitiveType.Kind.BYTE) {
                unbounded = false;
            }
            String maxOccurs = unbounded ? "unbounded" : "1";
            this.property = property;
            this.minOccurs = minOccurs;
            this.maxOccurs = maxOccurs;
            this.webFault = webFault;
        }

        public PropertyDeclaration getProperty() {
            return this.property;
        }

        @Override
        public String getElementName() {
            return this.property.getPropertyName();
        }

        @Override
        public String getTargetNamespace() {
            return this.webFault.getTargetNamespace();
        }

        @Override
        public String getElementDocs() {
            String docs = this.property.getJavaDoc().toString();
            if (docs.trim().length() == 0) {
                docs = null;
            }
            return docs;
        }

        @Override
        public XmlType getXmlType() {
            try {
                XmlType xmlType = XmlTypeFactory.findSpecifiedType(this);
                if (xmlType == null) {
                    xmlType = XmlTypeFactory.getXmlType(this.getType());
                }
                return xmlType;
            }
            catch (XmlTypeException e) {
                throw new ValidationException(this.property.getPosition(), "Error with property '" + this.property.getPropertyName() + "' of fault '" + this.webFault.getQualifiedName() + "'. " + e.getMessage());
            }
        }

        @Override
        public String getMimeType() {
            XmlMimeType mimeType = (XmlMimeType)this.property.getAnnotation(XmlMimeType.class);
            return mimeType == null ? null : mimeType.value();
        }

        @Override
        public boolean isSwaRef() {
            return this.property.getAnnotation(XmlAttachmentRef.class) != null;
        }

        @Override
        public QName getTypeQName() {
            return this.getXmlType().getQname();
        }

        @Override
        public int getMinOccurs() {
            return this.minOccurs;
        }

        @Override
        public String getMaxOccurs() {
            return this.maxOccurs;
        }

        @Override
        public TypeMirror getType() {
            Object propertyType = this.property.getPropertyType();
            MapType mapType = MapTypeUtil.findMapType(propertyType);
            if (mapType != null) {
                propertyType = mapType;
            }
            return propertyType;
        }

        @Override
        public boolean isAdapted() {
            return this.adaperType != null;
        }

        @Override
        public AdapterType getAdapterType() {
            return this.adaperType;
        }

        @Override
        public SourcePosition getPosition() {
            return this.property.getPosition();
        }
    }
}

